/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.cc;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import org.openconcerto.utils.cc.IdentitySet;

public final class IdentityHashSet<E>
extends AbstractSet<E>
implements IdentitySet<E>,
Cloneable {
    private static final Object VALUE = new Object();
    private final IdentityHashMap<E, Object> map;

    public IdentityHashSet() {
        this.map = new IdentityHashMap();
    }

    public IdentityHashSet(int expectedMaxSize) {
        this.map = new IdentityHashMap(expectedMaxSize);
    }

    public IdentityHashSet(Collection<? extends E> c) {
        this.map = new IdentityHashMap(Math.max((int)((float)c.size() / 0.75f) + 1, 16));
        this.addAll(c);
    }

    @Override
    public boolean add(E e) {
        return this.map.put(e, VALUE) != VALUE;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return super.addAll(c);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.map.keySet().containsAll(c);
    }

    @Override
    public boolean remove(Object o) {
        return this.map.remove(o) == VALUE;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.map.keySet().removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.map.keySet().retainAll(c);
    }

    @Override
    public Object[] toArray() {
        return this.map.keySet().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.map.keySet().toArray(a);
    }

    @Override
    public int hashCode() {
        return this.map.keySet().hashCode();
    }

    public Object clone() {
        return new IdentityHashSet<E>(this);
    }
}

