/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.cc;

public abstract class IPredicate<E> {
    private static final IPredicate<Object> truePred = new IPredicate<Object>(){

        @Override
        public boolean evaluateChecked(Object input) {
            return true;
        }
    };
    private static final IPredicate<Object> falsePred = new IPredicate<Object>(){

        @Override
        public boolean evaluateChecked(Object input) {
            return false;
        }
    };
    private static final IPredicate<Object> NotNullPred = new IPredicate<Object>(){

        @Override
        public boolean evaluateChecked(Object input) {
            return input != null;
        }
    };

    public static final <N> IPredicate<N> truePredicate() {
        return truePred;
    }

    public static final <N> IPredicate<N> falsePredicate() {
        return falsePred;
    }

    public static final <N> IPredicate<N> notNullPredicate() {
        return NotNullPred;
    }

    public abstract boolean evaluateChecked(E var1);

    public final <F extends E> IPredicate<F> cast() {
        return new IPredicate<F>(){

            @Override
            public boolean evaluateChecked(F input) {
                return IPredicate.this.evaluateChecked(input);
            }
        };
    }

    public final IPredicate<E> not() {
        if (this == truePred) {
            return IPredicate.falsePredicate();
        }
        if (this == falsePred) {
            return IPredicate.truePredicate();
        }
        return new IPredicate<E>(){

            @Override
            public boolean evaluateChecked(E input) {
                return !IPredicate.this.evaluateChecked(input);
            }
        };
    }

    public final IPredicate<E> and(final IPredicate<? super E> o) {
        if (o == this || o == truePred) {
            return this;
        }
        if (this == truePred) {
            return o.cast();
        }
        if (o == falsePred || this == falsePred) {
            return IPredicate.falsePredicate();
        }
        return new IPredicate<E>(){

            @Override
            public boolean evaluateChecked(E input) {
                return IPredicate.this.evaluateChecked(input) && o.evaluateChecked(input);
            }
        };
    }

    public final IPredicate<E> or(final IPredicate<? super E> o) {
        if (o == this || o == falsePred) {
            return this;
        }
        if (this == falsePred) {
            return o.cast();
        }
        if (o == truePred || this == truePred) {
            return IPredicate.truePredicate();
        }
        return new IPredicate<E>(){

            @Override
            public boolean evaluateChecked(E input) {
                return IPredicate.this.evaluateChecked(input) || o.evaluateChecked(input);
            }
        };
    }
}

