/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.cc;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.jcip.annotations.ThreadSafe;
import org.openconcerto.utils.CompareUtils;

@ThreadSafe
public class CopyOnWriteMap<K, V>
extends AbstractMap<K, V> {
    private Map<K, V> immutable;
    private Set<Map.Entry<K, V>> entrySet = null;

    public CopyOnWriteMap() {
        this.immutable = Collections.emptyMap();
    }

    public CopyOnWriteMap(Map<K, V> m) {
        this.immutable = Collections.unmodifiableMap(this.copy(m));
    }

    public Map<K, V> copy(Map<? extends K, ? extends V> src) {
        return new HashMap<K, V>(src);
    }

    @Override
    public synchronized V put(K key, V value) {
        Map<K, V> copy = this.copy(this.immutable);
        V res = copy.put(key, value);
        this.immutable = Collections.unmodifiableMap(copy);
        return res;
    }

    @Override
    public synchronized V remove(Object key) {
        Map<K, V> copy = this.copy(this.immutable);
        V res = copy.remove(key);
        this.immutable = Collections.unmodifiableMap(copy);
        return res;
    }

    @Override
    public synchronized void putAll(Map<? extends K, ? extends V> m) {
        Map<? extends K, ? extends V> copy = this.copy(this.immutable);
        copy.putAll(m);
        this.immutable = Collections.unmodifiableMap(copy);
    }

    @Override
    public synchronized void clear() {
        this.immutable = Collections.emptyMap();
    }

    public final synchronized Map<K, V> getImmutable() {
        return this.immutable;
    }

    @Override
    public int size() {
        return this.getImmutable().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getImmutable().isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getImmutable().containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.getImmutable().containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.getImmutable().get(key);
    }

    @Override
    public synchronized Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    @Override
    public boolean equals(Object o) {
        return this.getImmutable().equals(o);
    }

    @Override
    public int hashCode() {
        return this.getImmutable().hashCode();
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new Iterator<Map.Entry<K, V>>(){
                private final Iterator<Map.Entry<K, V>> delegate;
                private Map.Entry<K, V> current;
                {
                    this.delegate = CopyOnWriteMap.this.immutable.entrySet().iterator();
                    this.current = null;
                }

                @Override
                public boolean hasNext() {
                    return this.delegate.hasNext();
                }

                @Override
                public Map.Entry<K, V> next() {
                    this.current = this.delegate.next();
                    return this.current;
                }

                @Override
                public void remove() {
                    if (this.current == null) {
                        throw new IllegalStateException();
                    }
                    EntrySet.this.remove(this.current);
                }
            };
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return CompareUtils.equals(e.getValue(), CopyOnWriteMap.this.get(e.getKey()));
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            return CopyOnWriteMap.this.remove(((Map.Entry)o).getKey()) != null;
        }

        @Override
        public int size() {
            return CopyOnWriteMap.this.size();
        }

        @Override
        public void clear() {
            CopyOnWriteMap.this.clear();
        }
    }
}

