/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.cc;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.function.UnaryOperator;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class CopyOnWriteList<T>
extends AbstractList<T> {
    private List<T> immutable;

    public CopyOnWriteList() {
        this.immutable = Collections.emptyList();
    }

    public CopyOnWriteList(T single) {
        this.immutable = Collections.singletonList(single);
    }

    public CopyOnWriteList(Collection<? extends T> m) {
        this.immutable = Collections.unmodifiableList(this.copy(m));
    }

    protected List<T> copy(Collection<? extends T> src) {
        return new ArrayList<T>(src);
    }

    protected List<T> create(int capacity) {
        return new ArrayList(capacity);
    }

    @Override
    public Iterator<T> iterator() {
        return this.getImmutable().iterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return this.getImmutable().listIterator(index);
    }

    private void rangeCheck(int index, boolean forAdd, int size) {
        if (index < 0 || index > size || !forAdd && index == size) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(index));
        }
    }

    private String outOfBoundsMsg(int index) {
        return "Index: " + index + ", Size: " + this.size();
    }

    @Override
    public synchronized T set(int index, T element) {
        List<T> copy = this.copy(this.immutable);
        T res = copy.set(index, element);
        this.immutable = Collections.unmodifiableList(copy);
        return res;
    }

    @Override
    public synchronized boolean add(T e) {
        return super.add(e);
    }

    @Override
    public void add(int index, T element) {
        this.addAll(index, (Collection<? extends T>)Collections.singletonList(element));
    }

    @Override
    public synchronized boolean addAll(Collection<? extends T> c) {
        return this.addAll(this.size(), c);
    }

    @Override
    public synchronized boolean addAll(int index, Collection<? extends T> c) {
        int size = this.size();
        this.rangeCheck(index, true, size);
        int cSize = c.size();
        if (cSize == 0) {
            return false;
        }
        List<T> copy = this.create(size + cSize);
        int i = 0;
        while (i <= size) {
            if (i == index) {
                copy.addAll(c);
            }
            if (i < size) {
                copy.add(this.get(i));
            }
            ++i;
        }
        assert (copy.size() == size + cSize);
        this.immutable = Collections.unmodifiableList(copy);
        return true;
    }

    @Override
    public synchronized T remove(int index) {
        int size = this.size();
        this.rangeCheck(index, false, size);
        List<T> copy = this.create(size - 1);
        T res = null;
        int i = 0;
        while (i < size) {
            if (i == index) {
                res = this.get(i);
            } else {
                copy.add(this.get(i));
            }
            ++i;
        }
        assert (copy.size() == size - 1);
        this.immutable = Collections.unmodifiableList(copy);
        return res;
    }

    @Override
    public synchronized boolean remove(Object o) {
        int indexOf = this.indexOf(o);
        if (indexOf < 0) {
            return false;
        }
        this.remove(indexOf);
        return true;
    }

    @Override
    public synchronized boolean removeAll(Collection<?> c) {
        List<T> copy = this.copy(this.immutable);
        boolean res = copy.removeAll(c);
        this.immutable = Collections.unmodifiableList(copy);
        return res;
    }

    @Override
    public synchronized void clear() {
        this.immutable = Collections.emptyList();
    }

    @Override
    public synchronized boolean retainAll(Collection<?> c) {
        List<T> copy = this.copy(this.immutable);
        boolean res = copy.retainAll(c);
        this.immutable = Collections.unmodifiableList(copy);
        return res;
    }

    @Override
    public synchronized void replaceAll(UnaryOperator<T> operator) {
        List<T> copy = this.copy(this.immutable);
        copy.replaceAll(operator);
        this.immutable = Collections.unmodifiableList(copy);
    }

    @Override
    public synchronized void sort(Comparator<? super T> c) {
        Object[] a = this.toArray();
        Arrays.sort(a, c);
        List<T> copy = this.create(this.size());
        Object[] objectArray = a;
        int n = a.length;
        int n2 = 0;
        while (n2 < n) {
            Object e = objectArray[n2];
            copy.add(e);
            ++n2;
        }
        this.immutable = Collections.unmodifiableList(copy);
    }

    public final synchronized List<T> getImmutable() {
        return this.immutable;
    }

    @Override
    public T get(int index) {
        return this.getImmutable().get(index);
    }

    @Override
    public int size() {
        return this.getImmutable().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getImmutable().isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.getImmutable().contains(o);
    }

    @Override
    public boolean equals(Object o) {
        return this.getImmutable().equals(o);
    }

    @Override
    public int hashCode() {
        return this.getImmutable().hashCode();
    }
}

