/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.cc;

import java.util.Map;
import net.jcip.annotations.NotThreadSafe;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.cc.ITransformerExn;

@NotThreadSafe
public class CachedTransformer<K, V, X extends Exception>
implements ITransformerExn<K, V, X> {
    private final Map<K, V> map;
    private final boolean allowNullValue;
    private final ITransformerExn<K, V, X> function;

    public CachedTransformer(Map<K, V> map, ITransformerExn<K, V, X> function) {
        this(map, function, false);
    }

    public CachedTransformer(Map<K, V> map, ITransformerExn<K, V, X> function, boolean allowNullValue) {
        this.map = map;
        this.function = function;
        this.allowNullValue = allowNullValue;
    }

    @Override
    public final V transformChecked(K key) throws X {
        return this.get(key);
    }

    public V get(K key) throws X {
        return CollectionUtils.computeIfAbsent(this.map, key, this.function, this.allowNullValue);
    }
}

