/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Enumeration;
import java.util.Set;
import java.util.function.Function;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.zip.CRC32;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;
import org.openconcerto.utils.StreamUtils;
import org.openconcerto.utils.StringUtils;
import org.openconcerto.utils.Unzip;
import org.openconcerto.utils.cc.ITransformerExn;

public class Zip
implements Closeable {
    private final OutputStream outstream;
    private final ITransformerExn<OutputStream, ZipOutputStream, IOException> createZipStream;
    private ZipOutputStream zos;
    private final Function<String, ZipEntry> createEntry;
    private boolean entryOpen;

    public static byte[] deflate(String s) throws IOException {
        return Zip.deflate(s.getBytes(StringUtils.UTF8));
    }

    public static byte[] deflate(byte[] b) throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        DeflaterOutputStream out = new DeflaterOutputStream(bOut);
        out.write(b);
        out.close();
        return bOut.toByteArray();
    }

    public static ByteBuffer deflateToBuffer(String s) throws IOException {
        return ByteBuffer.wrap(Zip.deflate(s));
    }

    public static String inflateToString(ByteBuffer payload) throws IOException {
        return Zip.inflateToString(payload, payload.remaining());
    }

    public static String inflateToString(ByteBuffer payload, int length) throws IOException {
        byte[] b = new byte[length];
        payload.get(b);
        return Zip.inflateToString(b);
    }

    public static String inflateToString(byte[] b) throws IOException {
        return new String(Zip.inflate(b), StringUtils.UTF8);
    }

    public static byte[] inflate(byte[] b) throws IOException {
        InflaterInputStream in = new InflaterInputStream(new ByteArrayInputStream(b));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        StreamUtils.copy((InputStream)in, out);
        out.close();
        return out.toByteArray();
    }

    public static Zip createFrom(File from, File to, Set<String> excludedEntries) throws ZipException, IOException {
        Unzip unz = new Unzip(from);
        Zip res = new Zip(to);
        Enumeration<? extends ZipEntry> en = unz.entries();
        while (en.hasMoreElements()) {
            ZipEntry entry = en.nextElement();
            if (excludedEntries.contains(entry.getName())) continue;
            res.zip(entry.getName(), unz.getInputStream(entry));
        }
        unz.close();
        return res;
    }

    public static void delete(File src, Set<String> entriesName, File dest) throws ZipException, IOException {
        if (dest.exists()) {
            dest.delete();
        }
        Zip.createFrom(src, dest, entriesName).close();
    }

    public static Zip createJar(OutputStream out) {
        return new Zip(out, JarOutputStream::new, JarEntry::new);
    }

    public Zip(File f) throws FileNotFoundException {
        this(new FileOutputStream(f));
    }

    public Zip(OutputStream out) {
        this(out, ZipOutputStream::new, ZipEntry::new);
    }

    public Zip(OutputStream out, ITransformerExn<OutputStream, ZipOutputStream, IOException> createZipStream, Function<String, ZipEntry> createEntry) {
        this.outstream = out;
        this.createZipStream = createZipStream;
        this.zos = null;
        this.createEntry = createEntry;
        this.entryOpen = false;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.zos != null) {
            this.zos.close();
        } else {
            this.outstream.close();
        }
    }

    private synchronized ZipOutputStream getOutStream() throws IOException {
        if (this.zos == null) {
            this.zos = this.createZipStream.transformChecked(this.outstream);
        }
        return this.zos;
    }

    public ZipEntry createEntry(String name) {
        return this.createEntry.apply(name);
    }

    public void zip(File newFile) throws IOException {
        this.zip(newFile.getName(), newFile);
    }

    public void zip(String entryName, File newFile) throws IOException {
        ZipEntry entry = this.createEntry(entryName);
        entry.setTime(newFile.lastModified());
        Throwable throwable = null;
        Object var5_6 = null;
        try (BufferedInputStream ins = new BufferedInputStream(new FileInputStream(newFile));){
            this.zip(entry, (InputStream)ins);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void zip(String name, InputStream in) throws IOException {
        this.zip(this.createEntry(name), in);
    }

    public synchronized void zip(ZipEntry entry, InputStream in) throws IOException {
        this.putNextEntry(entry);
        byte[] b = new byte[512];
        int len = 0;
        while ((len = in.read(b)) != -1) {
            this.getOutStream().write(b, 0, len);
        }
        this.closeEntry();
    }

    public void zip(String name, byte[] in, boolean compressed) throws IOException {
        if (compressed) {
            this.zip(name, (InputStream)new ByteArrayInputStream(in));
        } else {
            this.zipNonCompressed(name, in);
        }
    }

    public synchronized void zipNonCompressed(String name, byte[] in) throws IOException {
        ZipEntry entry = this.createEntry(name);
        entry.setMethod(0);
        CRC32 crc = new CRC32();
        crc.update(in);
        entry.setCrc(crc.getValue());
        entry.setSize(in.length);
        this.putNextEntry(entry);
        this.getOutStream().write(in);
        this.closeEntry();
    }

    public synchronized OutputStream createEntryStream(String name) throws IOException {
        this.putNextEntry(name);
        return new BufferedOutputStream(this.getOutStream()){

            @Override
            public void close() throws IOException {
                this.flush();
                Zip.this.closeEntry();
            }
        };
    }

    private final synchronized void putNextEntry(String name) throws IOException, FileNotFoundException {
        this.putNextEntry(this.createEntry(name));
    }

    private final synchronized void putNextEntry(ZipEntry entry) throws IOException, FileNotFoundException {
        if (this.entryOpen) {
            throw new IllegalStateException("previous entry not closed");
        }
        this.entryOpen = true;
        this.getOutStream().putNextEntry(entry);
    }

    protected final synchronized void closeEntry() throws IOException {
        this.getOutStream().closeEntry();
        this.entryOpen = false;
    }
}

