/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;

public class MultiLock
implements Lock {
    private final List<Lock> locks;

    private static void lock(List<Lock> locks, boolean interruptibly) throws InterruptedException {
        int stop = locks.size();
        int i = 0;
        try {
            while (i < stop) {
                if (interruptibly) {
                    locks.get(i).lockInterruptibly();
                } else {
                    locks.get(i).lock();
                }
                ++i;
            }
        }
        catch (InterruptedException e) {
            MultiLock.unlock(locks, i);
            throw e;
        }
        catch (RuntimeException e) {
            MultiLock.unlock(locks, i);
            throw e;
        }
    }

    private static void unlock(List<Lock> locks, int toIndex) {
        MultiLock.unlock(locks.subList(0, toIndex));
    }

    private static void unlock(List<Lock> locks) {
        int i = locks.size() - 1;
        while (i >= 0) {
            locks.get(i).unlock();
            --i;
        }
    }

    public MultiLock(List<? extends Lock> locks) {
        this.locks = Collections.unmodifiableList(new ArrayList<Lock>(locks));
    }

    @Override
    public void lock() {
        try {
            MultiLock.lock(this.locks, false);
        }
        catch (InterruptedException e) {
            throw new Error(e);
        }
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        MultiLock.lock(this.locks, true);
    }

    @Override
    public boolean tryLock() {
        try {
            return this.tryLock(-1L, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            throw new Error(e);
        }
    }

    @Override
    public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
        int stop = this.locks.size();
        boolean ok = true;
        Exception exn = null;
        int i = 0;
        long remainingTime = unit.toNanos(time);
        try {
            while (i < stop && ok) {
                if (time <= 0L) {
                    ok = this.locks.get(i).tryLock();
                } else {
                    long before = System.nanoTime();
                    ok = this.locks.get(i).tryLock(remainingTime, TimeUnit.NANOSECONDS);
                    long after = System.nanoTime();
                    remainingTime -= after - before;
                }
                ++i;
            }
        }
        catch (InterruptedException e) {
            exn = e;
        }
        catch (RuntimeException e) {
            exn = e;
        }
        if (!ok || exn != null) {
            MultiLock.unlock(this.locks, i);
            if (exn instanceof RuntimeException) {
                throw (RuntimeException)exn;
            }
            if (exn instanceof InterruptedException) {
                throw exn;
            }
            assert (exn == null);
            return false;
        }
        return true;
    }

    @Override
    public void unlock() {
        MultiLock.unlock(this.locks);
    }

    @Override
    public Condition newCondition() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }
}

