/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.openconcerto.utils.NumberUtils;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.Tuple3;
import org.openconcerto.utils.cc.ITransformer;

public class CompareUtils {
    private static final Comparator LIST_COMPARATOR = new Comparator<List>(){

        @Override
        public int compare(List l1, List l2) {
            return CompareUtils.compareList(l1, l2);
        }
    };
    private static final Comparator<Comparable<Object>> NATURAL_COMPARATOR = new Comparator<Comparable<Object>>(){

        @Override
        public int compare(Comparable<Object> o1, Comparable<Object> o2) {
            return o1.compareTo(o2);
        }
    };
    public static final Equalizer<Object> OBJECT_EQ = new Equalizer<Object>(){

        @Override
        public boolean equals(Object o1, Object o2) {
            return CompareUtils.equals(o1, o2);
        }
    };

    public static final <A extends Comparable<A>, B extends Comparable<B>> int compare(A a1, B b1, A a2, B b2) {
        int res = a1.compareTo(a2);
        if (res != 0) {
            return res;
        }
        return b1.compareTo(b2);
    }

    public static final <A extends Comparable<A>, B extends Comparable<B>, C extends Comparable<C>> int compare(A a1, B b1, C c1, A a2, B b2, C c2) {
        int res = CompareUtils.compare(a1, b1, a2, b2);
        if (res != 0) {
            return res;
        }
        return c1.compareTo(c2);
    }

    public static final <A extends Comparable<A>, B extends Comparable<B>, C extends Comparable<C>, D extends Comparable<D>> int compare(A a1, B b1, C c1, D d1, A a2, B b2, C c2, D d2) {
        int res = CompareUtils.compare(a1, b1, c1, a2, b2, c2);
        if (res != 0) {
            return res;
        }
        return d1.compareTo(d2);
    }

    public static final <A extends Comparable<A>, B extends Comparable<B>> int compare(Tuple2<A, B> t1, Tuple2<A, B> t2) {
        return CompareUtils.compare((Comparable)t1.get0(), (Comparable)t1.get1(), (Comparable)t2.get0(), (Comparable)t2.get1());
    }

    public static final <A extends Comparable<A>, B extends Comparable<B>, C extends Comparable<C>> int compare(Tuple3<A, B, C> t1, Tuple3<A, B, C> t2) {
        return CompareUtils.compare((Comparable)t1.get0(), (Comparable)t1.get1(), (Comparable)t1.get2(), (Comparable)t2.get0(), (Comparable)t2.get1(), (Comparable)t2.get2());
    }

    public static final int compareIntNumbers(Number n1, Number n2) {
        return CompareUtils.compareLong(n1.longValue(), n2.longValue());
    }

    public static final int compareInt(int int1, int int2) {
        if (int1 < int2) {
            return -1;
        }
        if (int1 == int2) {
            return 0;
        }
        return 1;
    }

    public static final int compareLong(long int1, long int2) {
        if (int1 < int2) {
            return -1;
        }
        if (int1 == int2) {
            return 0;
        }
        return 1;
    }

    public static final <T extends Comparable<T>> int compareList(List<? extends T> l1, List<? extends T> l2) {
        return CompareUtils.compareList(l1, l2, CompareUtils.naturalOrder(), true);
    }

    public static final <T> int compareList(List<? extends T> l1, List<? extends T> l2, Comparator<? super T> comp, boolean longerAfter) {
        if (l1 == l2) {
            return 0;
        }
        Iterator<T> iter1 = l1.iterator();
        Iterator<T> iter2 = l2.iterator();
        while (iter1.hasNext() && iter2.hasNext()) {
            T t2;
            T t1 = iter1.next();
            int res = comp.compare(t1, t2 = iter2.next());
            if (res == 0) continue;
            return res;
        }
        if (!iter1.hasNext() && !iter2.hasNext()) {
            return 0;
        }
        if (iter1.hasNext()) {
            return longerAfter ? 1 : -1;
        }
        assert (iter2.hasNext());
        return longerAfter ? -1 : 1;
    }

    public static final <T extends Comparable<T>> Comparator<List<T>> getListComparator() {
        return LIST_COMPARATOR;
    }

    public static final <T> Comparator<List<T>> createListComparator(final Comparator<? super T> comp, final boolean longerAfter) {
        return new Comparator<List<T>>(){

            @Override
            public int compare(List<T> o1, List<T> o2) {
                return CompareUtils.compareList(o1, o2, comp, longerAfter);
            }
        };
    }

    public static final int compare(Object o1, Object o2) throws ClassCastException {
        if (o1 == null || o2 == null) {
            throw new NullPointerException();
        }
        if (o1 instanceof Number && o2 instanceof Number) {
            return NumberUtils.compare((Number)o1, (Number)o2);
        }
        int res = ((Comparable)o1).compareTo(o2);
        return res;
    }

    public static final <T extends Comparable<? super T>> Comparator<T> naturalOrder() {
        return NATURAL_COMPARATOR;
    }

    public static final <T> Comparator<T> createComparator(final List<? extends Comparator<T>> comparators) {
        return new Comparator<T>(){

            public String toString() {
                return "CompareUtils comparator with " + comparators;
            }

            @Override
            public int compare(T o1, T o2) {
                int result = 0;
                int i = 0;
                while (i < comparators.size() && result == 0) {
                    Comparator transf = (Comparator)comparators.get(i);
                    result = transf.compare(o1, o2);
                    ++i;
                }
                return result;
            }
        };
    }

    public static final boolean equals(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public static final <T> boolean equalsWithCompareTo(Comparable<T> o1, T o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.compareTo(o2) == 0;
    }

    public static final boolean equalsUsingIterator(Collection<?> c1, Collection<?> c2) {
        if (c1 == null && c2 == null) {
            return true;
        }
        if (c1 == null || c2 == null) {
            return false;
        }
        int size = c1.size();
        if (size != c2.size()) {
            return false;
        }
        if (size == 0) {
            return true;
        }
        Iterator<?> iter1 = c1.iterator();
        Iterator<?> iter2 = c2.iterator();
        while (iter1.hasNext()) {
            Object o2;
            Object o1 = iter1.next();
            if (CompareUtils.equals(o1, o2 = iter2.next())) continue;
            return false;
        }
        assert (!iter1.hasNext() && !iter2.hasNext());
        return true;
    }

    public static final <T> boolean equals(List<? extends T> l1, List<? extends T> l2, Equalizer<? super T> comp) {
        return CompareUtils.compare(l1, l2, comp, null) == null;
    }

    public static final <T> String compare(List<? extends T> l1, List<? extends T> l2, Equalizer<? super T> comp, ITransformer<? super T, String> toString) {
        int size = l1.size();
        if (size != l2.size()) {
            return "unequal size";
        }
        int i = 0;
        while (i < size) {
            T o2;
            T o1 = l1.get(i);
            if (!comp.equals(o1, o2 = l2.get(i))) {
                String s1 = toString == null ? String.valueOf(o1) : toString.transformChecked(o1);
                String s2 = toString == null ? String.valueOf(o2) : toString.transformChecked(o2);
                return "unequal at " + i + ": " + s1 + " != " + s2;
            }
            ++i;
        }
        return null;
    }

    public static final <T extends Comparable<? super T>> T min(T o1, T o2) {
        return o1.compareTo(o2) < 0 ? o1 : o2;
    }

    public static final <T extends Comparable<? super T>> T max(T o1, T o2) {
        return o1.compareTo(o2) < 0 ? o2 : o1;
    }

    public static interface Equalizer<T> {
        public boolean equals(T var1, T var2);
    }
}

