/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.io.Serializable;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;

public class BloomFilter<E>
implements Set<E>,
Serializable {
    private static final long serialVersionUID = 3527833617516722215L;
    private final int k;
    private final BitSet bitSet;
    private final int bitArraySize;
    private final int expectedElements;

    public BloomFilter(int bitArraySize, int expectedElements) {
        this.bitArraySize = bitArraySize;
        this.expectedElements = expectedElements;
        this.k = (int)Math.ceil((double)bitArraySize / (double)expectedElements * Math.log(2.0));
        this.bitSet = new BitSet(bitArraySize);
    }

    public double expectedFalsePositiveProbability() {
        return Math.pow(1.0 - Math.exp((double)(-this.k) * (double)this.expectedElements / (double)this.bitArraySize), this.k);
    }

    @Override
    public boolean add(E o) {
        Random r = new Random(o.hashCode());
        int x = 0;
        while (x < this.k) {
            this.bitSet.set(r.nextInt(this.bitArraySize), true);
            ++x;
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        for (E o : c) {
            this.add(o);
        }
        return false;
    }

    @Override
    public void clear() {
        int length = this.bitSet.length();
        int x = 0;
        while (x < length) {
            this.bitSet.set(x, false);
            ++x;
        }
    }

    @Override
    public boolean contains(Object o) {
        Random r = new Random(o.hashCode());
        int x = 0;
        while (x < this.k) {
            if (!this.bitSet.get(r.nextInt(this.bitArraySize))) {
                return false;
            }
            ++x;
        }
        return true;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException();
    }

    public int getBitLength() {
        return this.bitSet.length();
    }

    public static void main(String[] args) {
        BloomFilter<String> set = new BloomFilter<String>(100, 5);
        set.add("dog");
        set.add("doq");
        set.add("cat");
        set.add("mouse");
        set.add("dolphin");
        String test = "dog";
        if (set.contains(test)) {
            System.out.println(String.valueOf(test) + " is in the set with probability " + (1.0 - set.expectedFalsePositiveProbability()));
        } else {
            System.out.println(String.valueOf(test) + " is definitely not in the set");
        }
        System.out.println("BloomFilter stored in " + set.getBitLength() / 8 + " bytes");
    }
}

