/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.table;

import java.awt.Component;
import java.lang.reflect.Constructor;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.openconcerto.ui.table.TableCellRendererUtils;
import org.openconcerto.utils.cc.IPredicate;
import org.openconcerto.utils.cc.ITransformer;

public abstract class TableCellRendererDecorator
implements TableCellRenderer {
    private TableCellRenderer renderer;

    private static final <T extends TableCellRendererDecorator> ITransformer<TableCellRenderer, T> getTransf(final Class<T> clazz) {
        Constructor<T> ctor;
        try {
            ctor = clazz.getConstructor(TableCellRenderer.class);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Missing TableCellRenderer constructor in " + clazz);
        }
        return new ITransformer<TableCellRenderer, T>(){

            @Override
            public T transformChecked(TableCellRenderer input) {
                try {
                    return (TableCellRendererDecorator)ctor.newInstance(input);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Couldn't create a " + clazz + " with " + input);
                }
            }
        };
    }

    protected static final <T extends TableCellRendererDecorator> TableCellRendererDecoratorUtils<T> createUtils(Class<T> clazz) {
        return new TableCellRendererDecoratorUtils<T>(clazz);
    }

    public static void clearColumns(JTable jTable) {
        int i = 0;
        while (i < jTable.getColumnModel().getColumnCount()) {
            TableColumn tc = jTable.getColumnModel().getColumn(i);
            tc.setCellRenderer(null);
            ++i;
        }
    }

    public static TableCellRendererDecorator tableColorsRenderer(DefaultTableCellRenderer renderer) {
        if (renderer == null) {
            throw new NullPointerException();
        }
        return new TableCellRendererDecorator(renderer){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component comp = this.getRenderer(table, column).getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (table.getDropLocation() == null && !isSelected) {
                    TableCellRendererUtils.setColors(comp, table, isSelected);
                }
                return comp;
            }
        };
    }

    public TableCellRendererDecorator() {
        this(null);
    }

    public TableCellRendererDecorator(TableCellRenderer renderer) {
        this.renderer = renderer;
    }

    protected final TableCellRenderer getRenderer(JTable table, int column) {
        return this.renderer == null ? table.getDefaultRenderer(table.getColumnClass(column)) : this.renderer;
    }

    protected final void setRenderer(TableCellRenderer renderer) {
        this.renderer = renderer;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " on <" + this.renderer + ">";
    }

    public static class TableCellRendererDecoratorUtils<T extends TableCellRendererDecorator> {
        private final Class<T> clazz;
        private final ITransformer<TableCellRenderer, T> transf;
        private final T nullRenderer;

        protected TableCellRendererDecoratorUtils(Class<T> clazz) {
            this(clazz, TableCellRendererDecorator.getTransf(clazz));
        }

        protected TableCellRendererDecoratorUtils(Class<T> clazz, ITransformer<TableCellRenderer, T> transf) {
            this.clazz = clazz;
            this.transf = transf;
            this.nullRenderer = (TableCellRendererDecorator)transf.transformChecked(null);
        }

        protected final T getDecoratedRenderer(TableCellRenderer currentRenderer) {
            T res;
            Object object = res = currentRenderer == null ? this.nullRenderer : (TableCellRendererDecorator)this.transf.transformChecked(currentRenderer);
            assert (res != null);
            return res;
        }

        public final void setAllColumns(JTable jTable) {
            int i = 0;
            while (i < jTable.getColumnModel().getColumnCount()) {
                this.setRenderer(jTable.getColumnModel().getColumn(i));
                ++i;
            }
        }

        public final void setRenderer(TableColumn col) {
            TableCellRenderer newR;
            TableCellRenderer currentRenderer = col.getCellRenderer();
            if (currentRenderer != (newR = this.getRenderer(currentRenderer))) {
                col.setCellRenderer(newR);
            }
        }

        public final TableCellRenderer getRenderer(TableCellRenderer currentRenderer) {
            return this.getRenderer(currentRenderer, (IPredicate<TableCellRenderer>)new IPredicate<TableCellRenderer>(){

                @Override
                public boolean evaluateChecked(TableCellRenderer input) {
                    return this.replaces(input);
                }
            });
        }

        public final boolean alreadyDecorates(TableCellRenderer currentRenderer) {
            TableCellRenderer r = currentRenderer;
            boolean decorates = false;
            while (!decorates && r != null) {
                if (this.doesTheSame(r)) {
                    decorates = true;
                }
                TableCellRenderer tableCellRenderer = r = r instanceof TableCellRendererDecorator ? ((TableCellRendererDecorator)r).renderer : null;
            }
            return decorates;
        }

        private final TableCellRenderer getRenderer(TableCellRenderer currentRenderer, IPredicate<? super TableCellRenderer> toReplace) {
            TableCellRenderer res = currentRenderer;
            TableCellRenderer r = currentRenderer;
            TableCellRendererDecorator previousR = null;
            boolean needToCreate = true;
            while (needToCreate && r != null) {
                TableCellRenderer next;
                TableCellRendererDecorator decorator = r instanceof TableCellRendererDecorator ? (TableCellRendererDecorator)r : null;
                TableCellRenderer tableCellRenderer = next = decorator != null ? decorator.renderer : null;
                if (this.doesTheSame(r)) {
                    needToCreate = false;
                } else if (toReplace.evaluateChecked(r)) {
                    T created = this.getDecoratedRenderer(next);
                    if (previousR == null) {
                        res = created;
                    } else {
                        previousR.setRenderer((TableCellRenderer)created);
                    }
                    needToCreate = false;
                }
                previousR = decorator;
                r = next;
            }
            return needToCreate ? this.getDecoratedRenderer(res) : res;
        }

        protected boolean doesTheSame(TableCellRenderer r) {
            return r.getClass() == this.clazz;
        }

        protected boolean replaces(TableCellRenderer r) {
            return false;
        }
    }
}

