/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.table;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.Arrays;
import javax.swing.JPanel;

public class RowMatcherPanel
extends JPanel {
    private int[] leftIndexes = new int[0];
    private int[] rightIndexes = new int[0];
    private int offsetLeft;
    private int rowHeightLeft = 20;
    private int offsetRight;
    private int rowHeightRight = 20;
    private Color color = BLUE_COLOR;
    public static final Color BLUE_COLOR = Color.decode("#1E88E5");
    public static final Color GREEN_COLOR = Color.decode("#00C853");

    public RowMatcherPanel(int rowHeightLeft, int rowHeightRight) {
        this.rowHeightLeft = rowHeightLeft;
        this.rowHeightRight = rowHeightRight;
    }

    public void setColor(Color color) {
        if (!this.color.equals(color)) {
            this.color = color;
            this.repaint();
        }
    }

    @Override
    public void paint(Graphics g) {
        int y;
        int x;
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(this.color);
        int ovalRadius = 5;
        int minY = Integer.MAX_VALUE;
        int maxY = 0;
        boolean multi = this.leftIndexes.length + this.rightIndexes.length > 1;
        int i = 0;
        while (i < this.leftIndexes.length) {
            x = 7;
            y = this.offsetLeft + this.rowHeightLeft * this.leftIndexes[i] + this.rowHeightLeft / 2;
            g.fillOval(x - 5, y - 5, 10, 10);
            if (multi) {
                g.fillRect(x, y - 2, this.getWidth() / 2 - x, 4);
            }
            if (y < minY) {
                minY = y;
            }
            if (y > maxY) {
                maxY = y;
            }
            ++i;
        }
        i = 0;
        while (i < this.rightIndexes.length) {
            x = this.getWidth() - 5 - 2;
            y = this.offsetRight + this.rowHeightRight * this.rightIndexes[i] + this.rowHeightRight / 2;
            g.fillOval(x - 5, y - 5, 10, 10);
            if (multi) {
                g.fillRect(this.getWidth() / 2, y - 2, x - this.getWidth() / 2, 4);
            }
            if (y < minY) {
                minY = y;
            }
            if (y > maxY) {
                maxY = y;
            }
            ++i;
        }
        if (multi) {
            g.fillRect(this.getWidth() / 2 - 2, minY - 2, 4, maxY - minY + 4);
        }
    }

    public void setLeftIndex(int[] is) {
        if (!Arrays.equals(is, this.leftIndexes)) {
            this.leftIndexes = is;
            this.repaint();
        }
    }

    public void setRightIndex(int[] is) {
        if (!Arrays.equals(is, this.rightIndexes)) {
            this.rightIndexes = is;
            this.repaint();
        }
    }

    public void setLeftOffset(int offset) {
        if (offset != this.offsetLeft) {
            this.offsetLeft = offset;
            this.repaint();
        }
    }

    public void setRightOffset(int offset) {
        if (offset != this.offsetRight) {
            this.offsetRight = offset;
            this.repaint();
        }
    }
}

