/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.list;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JLabel;

public class HighLightableJLabel
extends JLabel {
    public static final Color DEFAULT_COLOR = new Color(252, 252, 180);
    private List<String> texts = new ArrayList<String>(1);
    private Color highLightColor = DEFAULT_COLOR;
    private boolean ignoreCase = true;

    public HighLightableJLabel() {
    }

    public HighLightableJLabel(String label) {
        super(label);
    }

    public void setHightlight(List<String> parts) {
        this.texts.clear();
        this.texts.addAll(parts);
    }

    public void setHightlight(String text) {
        this.texts.clear();
        this.texts.add(text);
    }

    public void setHighLightColor(Color highLightColor) {
        this.highLightColor = highLightColor;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    @Override
    public void paint(Graphics g) {
        if (this.texts != null && this.highLightColor != null && !this.texts.isEmpty()) {
            String currentText = this.getText();
            if (this.ignoreCase) {
                currentText = currentText.toLowerCase();
            }
            Iterator<String> iterator = this.texts.iterator();
            while (iterator.hasNext()) {
                String text;
                String textToSearch = text = iterator.next();
                if (this.ignoreCase) {
                    textToSearch = textToSearch.toLowerCase();
                }
                int currentIndex = 0;
                int offset = currentText.indexOf(textToSearch, currentIndex);
                while (offset >= 0) {
                    FontMetrics metrics = g.getFontMetrics();
                    String start = this.getText().substring(0, offset);
                    int startX = metrics.stringWidth(start);
                    int length = metrics.stringWidth(text);
                    int height = metrics.getHeight();
                    g.setColor(this.highLightColor);
                    g.fillRect(startX, 0, length, height);
                    currentIndex = offset + textToSearch.length();
                    offset = currentText.indexOf(textToSearch, currentIndex);
                }
            }
        }
        super.paint(g);
    }
}

