/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.light;

import java.util.ArrayList;
import java.util.List;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONAware;
import net.minidev.json.JSONObject;
import org.openconcerto.ui.light.UserSearchItem;
import org.openconcerto.utils.io.JSONConverter;
import org.openconcerto.utils.io.Transferable;

public class UserSearch
implements Transferable,
JSONAware {
    private String tableId;
    private List<UserSearchItem> content = new ArrayList<UserSearchItem>();

    public UserSearch() {
    }

    public UserSearch(String tableId) {
        this.tableId = tableId;
    }

    public UserSearch(JSONObject json) {
        this.fromJSON(json);
    }

    public final String getTableId() {
        return this.tableId;
    }

    public final List<UserSearchItem> getContent() {
        return this.content;
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = new JSONObject();
        json.put("table-id", this.tableId);
        json.put("content", JSONConverter.getJSON(this.content));
        return json;
    }

    @Override
    public void fromJSON(JSONObject json) {
        this.tableId = JSONConverter.getParameterFromJSON(json, "table-id", String.class);
        JSONArray jsonContent = JSONConverter.getParameterFromJSON(json, "content", JSONArray.class);
        if (jsonContent != null) {
            this.content = new ArrayList<UserSearchItem>();
            for (Object o : jsonContent) {
                this.content.add(new UserSearchItem(JSONConverter.getObjectFromJSON(o, JSONObject.class)));
            }
        }
    }

    @Override
    public String toJSONString() {
        return this.toJSON().toJSONString();
    }

    public String toString() {
        return "UserSearch on " + this.tableId + " " + this.content.size() + " items";
    }
}

