/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.light;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import org.jdom2.Document;
import org.jdom2.Element;
import org.openconcerto.ui.light.ColumnSpec;
import org.openconcerto.ui.light.ColumnsSpec;
import org.openconcerto.ui.light.LightUIContainer;
import org.openconcerto.ui.light.LightUIElement;
import org.openconcerto.ui.light.LightUserControl;
import org.openconcerto.ui.light.LightUserControlContainer;
import org.openconcerto.ui.light.Row;
import org.openconcerto.ui.light.RowSelectionSpec;
import org.openconcerto.ui.light.TableContent;
import org.openconcerto.ui.light.TableSpec;
import org.openconcerto.utils.NumberUtils;
import org.openconcerto.utils.io.JSONConverter;

public class LightUITable
extends LightUserControlContainer {
    public static final int DEFAULT_LINE_HEIGHT = 40;
    private static final String LINE_PER_ROW = "line-per-row";
    private static final String TABLE_SPEC = "table-spec";
    private static final String ALLOW_SELECTION = "allow-selection";
    private static final String ALLOW_MULTI_SELECTION = "allow-multi-selection";
    private static final String DYNAMIC_LOAD = "dynamic-load";
    private static final String AUTO_SELECT_FIRST_LINE = "auto-select-first-line";
    private Boolean dynamicLoad = false;
    private Boolean allowSelection = false;
    private Boolean allowMultiSelection = false;
    private Boolean autoSelectFirstLine = true;
    private TableSpec tableSpec = null;
    private transient List<ActionListener> selectionListeners = new ArrayList<ActionListener>();
    private int linePerRow = 1;
    private int lineHeight = 40;

    public LightUITable() {
    }

    public LightUITable(JSONObject json) {
        super(json);
    }

    public LightUITable(LightUITable tableElement) {
        super(tableElement);
        this.tableSpec = tableElement.tableSpec;
        this.allowSelection = tableElement.allowSelection;
    }

    public LightUITable(String id) {
        super(id);
        this.setType(4);
        this.setWeightX(1);
        this.setFillWidth(true);
        RowSelectionSpec selection = new RowSelectionSpec(this.getId());
        ColumnsSpec columnsSpec = new ColumnsSpec(this.getId(), new ArrayList<ColumnSpec>(), new ArrayList<String>(), new ArrayList<String>());
        this.tableSpec = new TableSpec(this.getId(), selection, columnsSpec);
        this.tableSpec.setContent(new TableContent(this.getId()));
    }

    @Override
    public void setId(String id) {
        super.setId(id);
        if (this.tableSpec != null) {
            this.tableSpec.setId(id);
            if (this.tableSpec.getSelection() != null) {
                this.tableSpec.getSelection().setTableId(id);
            }
            if (this.tableSpec.getContent() != null) {
                this.tableSpec.getContent().setTableId(id);
            }
        }
    }

    public final void setLinePerRow(int linePerRow) {
        this.linePerRow = linePerRow;
    }

    public final int getLinePerRow() {
        return this.linePerRow;
    }

    public final void setLineHeight(int lineHeight) {
        this.lineHeight = lineHeight;
    }

    public final int getLineHeight() {
        return this.lineHeight;
    }

    public final TableSpec getTableSpec() {
        return this.tableSpec;
    }

    public final void setTableSpec(TableSpec tableSpec) {
        this.tableSpec = tableSpec;
    }

    public final Boolean isAllowSelection() {
        return this.allowSelection;
    }

    public final void setAllowSelection(boolean allowSelection) {
        this.allowSelection = allowSelection;
    }

    public final Boolean isAllowMultiSelection() {
        return this.allowMultiSelection;
    }

    public final void setAllowMultiSelection(boolean allowMultiSelection) {
        this.allowMultiSelection = allowMultiSelection;
    }

    public final Boolean isDynamicLoad() {
        return this.dynamicLoad;
    }

    public final void setDynamicLoad(boolean dynamicLoad) {
        this.dynamicLoad = dynamicLoad;
    }

    public final Boolean isAutoSelectFirstLine() {
        return this.autoSelectFirstLine;
    }

    public final void setAutoSelectFirstLine(boolean autoSelectFirstLine) {
        this.autoSelectFirstLine = autoSelectFirstLine;
    }

    public final Row removeRow(int index) {
        return this.tableSpec.getContent().removeRow(index);
    }

    public final boolean removeRow(Row row) {
        TableContent content = this.getTableSpec().getContent();
        return content.removeRow(row);
    }

    public final boolean hasRow() {
        return this.tableSpec != null && this.tableSpec.getContent() != null && this.tableSpec.getContent().getRowsCount() > 0;
    }

    public final Row getRow(int index) {
        return this.getTableSpec().getContent().getRow(index);
    }

    public Row getRowById(Number rowId) {
        int size = this.getTableSpec().getContent().getRowsCount();
        int i = 0;
        while (i < size) {
            Row row = this.getRow(i);
            if (NumberUtils.areNumericallyEqual(row.getId(), rowId)) {
                return row;
            }
            ++i;
        }
        return null;
    }

    public final Row setRow(int index, Row row) {
        return this.getTableSpec().getContent().setRow(index, row);
    }

    public final void insertRow(int index, Row row) {
        this.getTableSpec().getContent().insertRow(index, row);
    }

    public final boolean addRow(Row row) {
        return this.getTableSpec().getContent().addRow(row);
    }

    public final int getRowsCount() {
        return this.getTableSpec().getContent().getRowsCount();
    }

    public final void clearRows() {
        this.getTableSpec().getContent().clearRows();
    }

    public final List<Number> getSelectedIds() {
        return this.getTableSpec().getSelection().getIds();
    }

    public final Number getFirstSelectedId() {
        List<Number> selectedIds = this.getTableSpec().getSelection().getIds();
        if (selectedIds.isEmpty()) {
            return null;
        }
        return selectedIds.get(0);
    }

    public final void setSelectedIds(List<Number> selectedIds, boolean fire) {
        this.getTableSpec().getSelection().setIds(selectedIds);
        if (fire) {
            this.fireSelectionChange();
        }
    }

    public final void clearSelection(boolean fire) {
        this.getTableSpec().getSelection().clear();
        if (fire) {
            this.fireSelectionChange();
        }
    }

    public final List<Row> getSelectedRows() {
        ArrayList<Row> selectedRows = new ArrayList<Row>();
        if (this.getTableSpec().getSelection() != null) {
            List<Number> selectedIds = this.getSelectedIds();
            for (Number selectedId : selectedIds) {
                Row selectedRow = this.getRowById(selectedId);
                if (selectedRow == null) continue;
                selectedRows.add(selectedRow);
            }
        }
        return selectedRows;
    }

    @Override
    public final boolean replaceChild(LightUIElement pChild) {
        pChild.setReadOnly(this.isReadOnly());
        int i = 0;
        while (i < this.getRowsCount()) {
            Row tableRow = this.getTableSpec().getContent().getRow(i);
            List<Object> tableRowValues = tableRow.getValues();
            int tableRowValuesCount = tableRowValues.size();
            int j = 0;
            while (j < tableRowValuesCount) {
                Object tableRowValue = tableRowValues.get(j);
                if (tableRowValue instanceof LightUIElement) {
                    LightUIElement child = (LightUIElement)tableRowValue;
                    if (child.getId().equals(pChild.getId())) {
                        tableRowValues.set(i, pChild);
                        child.setParent(this);
                        return true;
                    }
                    if (child instanceof LightUIContainer && ((LightUIContainer)child).replaceChild(pChild)) {
                        return true;
                    }
                    if (child instanceof LightUITable && ((LightUITable)child).replaceChild(pChild)) {
                        return true;
                    }
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public final <T extends LightUIElement> T findElementByID(String searchParam, Class<T> objectClass) {
        if (this.hasRow()) {
            int i = 0;
            while (i < this.getRowsCount()) {
                Row row = this.getRow(i);
                List<Object> rowValues = row.getValues();
                for (Object value : rowValues) {
                    T resultElement;
                    if (value instanceof LightUIContainer) {
                        LightUIContainer panel = (LightUIContainer)value;
                        T element = panel.findChildByID(searchParam, objectClass);
                        if (element == null) continue;
                        return element;
                    }
                    if (!(value instanceof LightUIElement)) continue;
                    LightUIElement element = (LightUIElement)value;
                    if (element.getId().equals(searchParam)) {
                        if (objectClass.isAssignableFrom(element.getClass())) {
                            return (T)((LightUIElement)objectClass.cast(element));
                        }
                        throw new IllegalArgumentException("Element found at is not an instance of " + objectClass.getName() + ", element class: " + element.getClass().getName() + " element ID: " + element.getId());
                    }
                    if (!(element instanceof LightUITable) || (resultElement = ((LightUITable)element).findElementByID(searchParam, objectClass)) == null) continue;
                    return resultElement;
                }
                ++i;
            }
        } else {
            System.out.println("LightUITable.findElementByID() - No rows for table: " + this.getId());
        }
        return null;
    }

    public final <T extends LightUIElement> T findElementByUUID(String searchParam, Class<T> objectClass) {
        if (this.hasRow()) {
            int i = 0;
            while (i < this.getRowsCount()) {
                Row row = this.getRow(i);
                List<Object> rowValues = row.getValues();
                for (Object value : rowValues) {
                    T resultElement;
                    if (value instanceof LightUIContainer) {
                        LightUIContainer panel = (LightUIContainer)value;
                        T element = panel.findChildByUUID(searchParam, objectClass);
                        if (element == null) continue;
                        return element;
                    }
                    if (!(value instanceof LightUIElement)) continue;
                    LightUIElement element = (LightUIElement)value;
                    if (element.getUUID().equals(searchParam)) {
                        if (objectClass.isAssignableFrom(element.getClass())) {
                            return (T)((LightUIElement)objectClass.cast(element));
                        }
                        throw new IllegalArgumentException("Element found at is not an instance of " + objectClass.getName() + ", element class: " + element.getClass().getName() + " element ID: " + element.getId());
                    }
                    if (!(element instanceof LightUITable) || (resultElement = ((LightUITable)element).findElementByUUID(searchParam, objectClass)) == null) continue;
                    return resultElement;
                }
                ++i;
            }
        } else {
            System.out.println("LightUITable.findElementByUUID() - No rows for table: " + this.getId());
        }
        return null;
    }

    @Override
    public <T extends LightUIElement> List<T> findChildren(Class<T> expectedClass, boolean recursively) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (this.hasRow()) {
            int size = this.getRowsCount();
            int i = 0;
            while (i < size) {
                Row row = this.getRow(i);
                List<Object> rowValues = row.getValues();
                for (Object value : rowValues) {
                    if (value == null) continue;
                    if (recursively) {
                        if (value instanceof LightUIContainer) {
                            result.addAll(((LightUIContainer)value).findChildren(expectedClass, recursively));
                        } else if (value instanceof LightUITable) {
                            result.addAll(((LightUITable)value).findChildren(expectedClass, recursively));
                        }
                    }
                    if (!expectedClass.isAssignableFrom(value.getClass())) continue;
                    result.add((LightUIElement)expectedClass.cast(value));
                }
                ++i;
            }
        } else {
            System.out.println("LightUITable.getElementById() - No rows for table: " + this.getId());
        }
        return result;
    }

    public final void addSelectionListener(ActionListener selectionListener) {
        this.setAllowSelection(true);
        this.selectionListeners.add(selectionListener);
    }

    public final void removeSelectionListeners() {
        this.selectionListeners.clear();
    }

    public final void fireSelectionChange() {
        for (ActionListener listener : this.selectionListeners) {
            listener.actionPerformed(new ActionEvent(this, 1, "selection"));
        }
    }

    public final Document createXmlPreferences(Document userPrefs, ColumnsSpec columnsSpec) throws ParserConfigurationException {
        Element rootElement = new Element("list");
        Document xmlConf = new Document();
        int columnSpecCount = columnsSpec.getColumnCount();
        ArrayList<String> visibleIds = new ArrayList<String>();
        int i = 0;
        while (i < columnSpecCount) {
            ColumnSpec columnSpec = columnsSpec.getColumn(i);
            Element xmlColumn = this.createXmlColumn(columnSpec.getId(), columnSpec.getMaxWidth(), columnSpec.getMinWidth(), columnSpec.getWidth());
            rootElement.addContent(xmlColumn);
            visibleIds.add(columnSpec.getId());
            ++i;
        }
        Element rootUserPrefs = userPrefs.getRootElement();
        List<Element> xmlColumns = rootUserPrefs.getChildren();
        int columnsSize = xmlColumns.size();
        int i2 = 0;
        while (i2 < columnsSize) {
            Element xmlColumn = xmlColumns.get(i2);
            String columnId = xmlColumn.getAttribute("id").getValue();
            if (!visibleIds.contains(columnId)) {
                int maxWidth = Integer.parseInt(xmlColumn.getAttribute("max-width").getValue());
                int minWidth = Integer.parseInt(xmlColumn.getAttribute("min-width").getValue());
                int width = Integer.parseInt(xmlColumn.getAttribute("width").getValue());
                Element newXmlColumn = this.createXmlColumn(columnId, maxWidth, minWidth, width);
                rootElement.addContent(newXmlColumn);
            }
            ++i2;
        }
        xmlConf.setRootElement(rootElement);
        return xmlConf;
    }

    public Document createDefaultXmlPreferences() {
        Element rootElement = new Element("list");
        if (this.getTableSpec() != null && this.getTableSpec().getColumns() != null) {
            int sqlColumnsCount = this.getTableSpec().getColumns().getColumnCount();
            int i = 0;
            while (i < sqlColumnsCount) {
                ColumnSpec column = this.getTableSpec().getColumns().getColumn(i);
                String columnId = column.getId();
                Element columnElement = this.createXmlColumn(columnId, column.getMaxWidth(), column.getMinWidth(), column.getWidth());
                rootElement.addContent(columnElement);
                ++i;
            }
        }
        Document xmlConf = new Document(rootElement);
        return xmlConf;
    }

    protected final Element createXmlColumn(String columnId, double maxWidth, double minWidth, double width) {
        Element columnElement = new Element("column");
        columnElement.setAttribute("id", columnId);
        columnElement.setAttribute("max-width", String.valueOf(maxWidth));
        columnElement.setAttribute("min-width", String.valueOf(minWidth));
        columnElement.setAttribute("width", String.valueOf(width));
        return columnElement;
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
        if (this.hasRow()) {
            int size = this.getRowsCount();
            int i = 0;
            while (i < size) {
                Row row = this.getRow(i);
                List<Object> values = row.getValues();
                for (Object value : values) {
                    if (!(value instanceof LightUIElement)) continue;
                    ((LightUIElement)value).setReadOnly(readOnly);
                }
                ++i;
            }
        }
    }

    @Override
    public void _setValueFromContext(Object value) {
        if (value != null) {
            JSONArray jsonContext = JSONConverter.getObjectFromJSON(value, JSONArray.class);
            ColumnsSpec columnsSpec = this.getTableSpec().getColumns();
            int columnsCount = columnsSpec.getColumnCount();
            ArrayList<Integer> editorsIndex = new ArrayList<Integer>();
            int i = 0;
            while (i < columnsCount) {
                ColumnSpec columnSpec = columnsSpec.getColumn(i);
                if (columnSpec.getEditor() != null) {
                    editorsIndex.add(i);
                }
                ++i;
            }
            if (this.hasRow()) {
                int size = this.getRowsCount();
                if (jsonContext.size() != size) {
                    throw new IllegalStateException("LightUITable.setValueFromContext() - Incorrect line count in JSON, row count:" + size + " context:" + jsonContext.size() + " (" + value + ")");
                }
                int i2 = 0;
                while (i2 < size) {
                    Row row = this.getRow(i2);
                    JSONObject jsonLineContext = JSONConverter.getObjectFromJSON(jsonContext.get(i2), JSONObject.class);
                    Number rowId = JSONConverter.getParameterFromJSON(jsonLineContext, "row.id", Number.class);
                    String rowExtendId = JSONConverter.getParameterFromJSON(jsonLineContext, "row.extend.id", String.class);
                    if (NumberUtils.areNumericallyEqual(rowId, row.getId()) && (row.getExtendId() == null || row.getExtendId() != null && rowExtendId.equals(row.getExtendId()))) {
                        if (row.isFillWidth().booleanValue()) {
                            LightUIElement element;
                            if (!row.getValues().isEmpty() && row.getValues().get(0) instanceof LightUserControl && (element = (LightUIElement)row.getValues().get(0)) instanceof LightUserControl) {
                                if (jsonLineContext.containsKey(element.getUUID())) {
                                    ((LightUserControl)element)._setValueFromContext(jsonLineContext.get(element.getUUID()));
                                } else {
                                    System.out.println("LightUITable.setValueFromContext() - Unable to find element : id - " + element.getId() + " uuid - " + element.getUUID());
                                    System.out.println("LightUITable.setValueFromContext() - In JSON                : " + jsonLineContext.toJSONString());
                                }
                            }
                        } else {
                            int k = 0;
                            while (k < editorsIndex.size()) {
                                Object objEditor = row.getValues().get((Integer)editorsIndex.get(k));
                                if (!(objEditor instanceof LightUserControl)) {
                                    throw new IllegalArgumentException("Impossible to find editor for row: " + rowId.toString() + " at position: " + String.valueOf(k));
                                }
                                LightUIElement editor = (LightUIElement)objEditor;
                                if (!(editor instanceof LightUserControl) || !jsonLineContext.containsKey(editor.getUUID())) {
                                    throw new IllegalArgumentException("Impossible to find value for editor: " + editor.getId() + " for row: " + rowId.toString() + " at position: " + String.valueOf(k));
                                }
                                ((LightUserControl)editor)._setValueFromContext(jsonLineContext.get(editor.getUUID()));
                                ++k;
                            }
                        }
                    } else {
                        ArrayList<Number> ids = new ArrayList<Number>(size);
                        int j = 0;
                        while (j < size) {
                            ids.add(this.getRow(j).getId());
                            ++j;
                        }
                        throw new IllegalArgumentException("Impossible to find row: " + rowId.toString() + " known table row ids :" + ids);
                    }
                    ++i2;
                }
            }
        }
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = super.toJSON();
        if (this.allowSelection.booleanValue()) {
            json.put(ALLOW_SELECTION, true);
        }
        if (this.allowMultiSelection.booleanValue()) {
            json.put(ALLOW_MULTI_SELECTION, true);
        }
        if (this.dynamicLoad.booleanValue()) {
            json.put(DYNAMIC_LOAD, true);
        }
        if (!this.autoSelectFirstLine.booleanValue()) {
            json.put(AUTO_SELECT_FIRST_LINE, false);
        }
        if (this.tableSpec != null) {
            json.put(TABLE_SPEC, this.tableSpec.toJSON());
        }
        json.put(LINE_PER_ROW, this.linePerRow);
        return json;
    }

    @Override
    public void fromJSON(JSONObject json) {
        super.fromJSON(json);
        this.allowSelection = JSONConverter.getParameterFromJSON(json, ALLOW_SELECTION, Boolean.class, Boolean.valueOf(false));
        this.allowSelection = JSONConverter.getParameterFromJSON(json, ALLOW_MULTI_SELECTION, Boolean.class, Boolean.valueOf(false));
        this.dynamicLoad = JSONConverter.getParameterFromJSON(json, DYNAMIC_LOAD, Boolean.class, Boolean.valueOf(false));
        this.autoSelectFirstLine = JSONConverter.getParameterFromJSON(json, AUTO_SELECT_FIRST_LINE, Boolean.class, Boolean.valueOf(true));
        this.linePerRow = JSONConverter.getParameterFromJSON(json, LINE_PER_ROW, Integer.class);
        JSONObject jsonRawContent = JSONConverter.getParameterFromJSON(json, TABLE_SPEC, JSONObject.class);
        if (jsonRawContent != null) {
            this.tableSpec = new TableSpec(jsonRawContent);
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        this.selectionListeners.clear();
    }
}

