/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.light;

import net.minidev.json.JSONObject;
import org.openconcerto.ui.light.LightUILabel;
import org.openconcerto.ui.light.LightUILine;
import org.openconcerto.ui.light.LightUIList;
import org.openconcerto.ui.light.LightUIPanel;
import org.openconcerto.utils.io.JSONConverter;

public class LightUIListRow
extends LightUIPanel {
    private Number rowId;

    public LightUIListRow(JSONObject json) {
        super(json);
    }

    public LightUIListRow(LightUIListRow listItem) {
        super(listItem);
        this.rowId = listItem.rowId;
    }

    public LightUIListRow(LightUIList parent, Number rowId) {
        super(String.valueOf(parent.getId()) + ".item.panel." + rowId.toString());
        this.rowId = rowId;
        this.setType(29);
        this.setFillHeight(false);
    }

    public LightUIListRow(LightUIList parent, Number id, String label) {
        this(parent, id);
        LightUILine line = new LightUILine();
        line.addChild(new LightUILabel(String.valueOf(this.getId()) + ".label", label));
        this.addChild(line);
    }

    public Number getRowId() {
        return this.rowId;
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = super.toJSON();
        json.put("row-id", this.getRowId());
        return json;
    }

    @Override
    public void fromJSON(JSONObject json) {
        super.fromJSON(json);
        this.rowId = JSONConverter.getParameterFromJSON(json, "row-id", Number.class);
    }
}

