/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.light;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import org.openconcerto.ui.light.InvalidClassException;
import org.openconcerto.ui.light.JSONToLightUIConvertorManager;
import org.openconcerto.ui.light.LightUIElement;
import org.openconcerto.ui.light.LightUITable;
import org.openconcerto.utils.io.JSONConverter;

public class LightUIContainer
extends LightUIElement {
    private List<LightUIElement> children = new ArrayList<LightUIElement>(1);

    public LightUIContainer() {
    }

    public LightUIContainer(String id) {
        super(id);
    }

    public LightUIContainer(JSONObject json) {
        super(json);
    }

    public LightUIContainer(LightUIContainer container) {
        super(container);
    }

    public void addChild(LightUIElement child) {
        if (child == null) {
            throw new IllegalArgumentException("Attempt to put a null child in container, id:" + this.getId());
        }
        child.setReadOnly(this.isReadOnly());
        child.setParent(this);
        this.children.add(child);
    }

    public void addChildren(List<LightUIElement> children) {
        if (children == null) {
            throw new IllegalArgumentException("List null, id:" + this.getId());
        }
        for (LightUIElement child : children) {
            this.addChild(child);
        }
    }

    public void insertChild(int index, LightUIElement child) {
        if (child == null) {
            throw new IllegalArgumentException("Attempt to put null child in container, id:" + this.getId());
        }
        child.setReadOnly(this.isReadOnly());
        child.setParent(this);
        this.children.add(index, child);
    }

    public void removeChild(LightUIElement child) {
        this.children.remove(child);
    }

    public void removeChild(int index) {
        this.children.remove(index);
    }

    public LightUIElement getChild(int index) {
        return this.getChild(index, LightUIElement.class);
    }

    public <T extends LightUIElement> T getChild(int index, Class<T> expectedClass) {
        return (T)((LightUIElement)expectedClass.cast(this.children.get(index)));
    }

    public <T extends LightUIElement> T getFirstChild(Class<T> expectedClass) {
        if (this.getChildrenCount() > 0) {
            return (T)((LightUIElement)expectedClass.cast(this.children.get(0)));
        }
        return null;
    }

    public int getChildrenCount() {
        return this.children.size();
    }

    public void clear() {
        this.children.clear();
    }

    public boolean replaceChild(LightUIElement pChild) {
        int childCount = this.getChildrenCount();
        pChild.setReadOnly(this.isReadOnly());
        int i = 0;
        while (i < childCount) {
            LightUIElement child = this.children.get(i);
            if (child.getId().equals(pChild.getId())) {
                this.children.set(i, pChild);
                pChild.setParent(this);
                return true;
            }
            if (child instanceof LightUIContainer && ((LightUIContainer)child).replaceChild(pChild)) {
                return true;
            }
            if (child instanceof LightUITable && ((LightUITable)child).replaceChild(pChild)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public <T extends LightUIElement> T findChildByID(String id, Class<T> expectedClass) {
        int childCount = this.getChildrenCount();
        Object result = null;
        int i = 0;
        while (i < childCount) {
            LightUIElement child = this.getChild(i);
            if (child.getId().equals(id)) {
                result = child;
                break;
            }
            if (child instanceof LightUIContainer && (result = ((LightUIContainer)child).findChildByID(id, expectedClass)) != null || child instanceof LightUITable && (result = ((LightUITable)child).findElementByID(id, expectedClass)) != null) break;
            ++i;
        }
        if (result != null) {
            if (expectedClass.isAssignableFrom(result.getClass())) {
                return (T)((LightUIElement)expectedClass.cast(result));
            }
            throw new InvalidClassException(expectedClass.getName(), result.getClass().getName(), ((LightUIElement)result).getId());
        }
        return null;
    }

    public <T extends LightUIElement> T findChildByUUID(String uuid, Class<T> expectedClass) {
        int childCount = this.getChildrenCount();
        Object result = null;
        int i = 0;
        while (i < childCount) {
            LightUIElement child = this.getChild(i);
            if (child.getUUID().equals(uuid)) {
                result = child;
                break;
            }
            if (child instanceof LightUIContainer && (result = ((LightUIContainer)child).findChildByUUID(uuid, expectedClass)) != null || child instanceof LightUITable && (result = ((LightUITable)child).findElementByUUID(uuid, expectedClass)) != null) break;
            ++i;
        }
        if (result != null) {
            if (expectedClass.isAssignableFrom(result.getClass())) {
                return (T)((LightUIElement)expectedClass.cast(result));
            }
            throw new InvalidClassException(expectedClass.getName(), result.getClass().getName(), ((LightUIElement)result).getId());
        }
        return null;
    }

    public <T extends LightUIElement> List<T> findChildren(Class<T> expectedClass, boolean recursively) {
        ArrayList<Object> result = new ArrayList<Object>();
        int childCount = this.getChildrenCount();
        int i = 0;
        while (i < childCount) {
            LightUIElement child = this.getChild(i);
            if (recursively) {
                if (child instanceof LightUIContainer) {
                    result.addAll(((LightUIContainer)child).findChildren(expectedClass, true));
                }
                if (child instanceof LightUITable) {
                    result.addAll(((LightUITable)child).findChildren(expectedClass, true));
                }
            }
            if (expectedClass.isAssignableFrom(child.getClass())) {
                result.add((LightUIElement)expectedClass.cast(child));
            }
            ++i;
        }
        return result;
    }

    @Override
    protected void copy(LightUIElement element) {
        super.copy(element);
        if (!(element instanceof LightUIContainer)) {
            throw new InvalidClassException(LightUIContainer.class.getName(), element.getClassName(), element.getId());
        }
        this.clear();
        LightUIContainer container = (LightUIContainer)element;
        System.err.println("LightUIContainer.copy() warning children not copied");
        this.children.addAll(container.children);
        for (LightUIElement child : this.children) {
            child.setParent(this);
        }
    }

    @Override
    public void dump(PrintStream out, int depth) {
        super.dump(out, depth);
        for (LightUIElement child : this.children) {
            child.dump(out, depth + 1);
        }
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
        int childCount = this.getChildrenCount();
        int i = 0;
        while (i < childCount) {
            LightUIElement child = this.getChild(i);
            child.setReadOnly(readOnly);
            ++i;
        }
    }

    @Override
    public JSONObject toJSON() {
        JSONObject result = super.toJSON();
        if (!this.children.isEmpty()) {
            result.put("childs", JSONConverter.getJSON(this.children));
        }
        return result;
    }

    @Override
    public void fromJSON(JSONObject json) {
        super.fromJSON(json);
        this.clear();
        JSONArray jsonElements = JSONConverter.getParameterFromJSON(json, "childs", JSONArray.class);
        if (jsonElements != null) {
            for (Object o : jsonElements) {
                JSONObject jsonElement = JSONConverter.getObjectFromJSON(o, JSONObject.class);
                if (jsonElement == null) {
                    throw new IllegalArgumentException("null element in json parameter");
                }
                LightUIElement lightElement = JSONToLightUIConvertorManager.getInstance().createUIElementFromJSON(jsonElement);
                this.addChild(lightElement);
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this.children.size());
        for (LightUIElement e : this.children) {
            out.writeObject(e);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        int n = in.readInt();
        this.children.clear();
        int i = 0;
        while (i < n) {
            LightUIElement e = (LightUIElement)in.readObject();
            this.children.add(e);
            ++i;
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        for (LightUIElement child : this.children) {
            child.destroy();
        }
    }
}

