/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.light;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minidev.json.JSONObject;
import org.openconcerto.ui.light.InvalidClassException;
import org.openconcerto.ui.light.LightUIElement;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.io.JSONConverter;

public class LightUIButtonLink
extends LightUIElement {
    private static final String OPEN_NEW_FRAME_KEY = "open-new-frame";
    private static final String URL_PARAMETER_KEY = "url-parameter";
    private Boolean openNewFrame = false;
    private Map<String, String> urlParameters = new HashMap<String, String>();

    public LightUIButtonLink() {
    }

    public LightUIButtonLink(String id, String filePath, boolean openNewFrame) {
        super(id);
        this.setType(25);
        this.setValue(filePath);
        this.setOpenNewFrame(openNewFrame);
    }

    public LightUIButtonLink(JSONObject json) {
        super(json);
    }

    public LightUIButtonLink(LightUIButtonLink button) {
        super(button);
    }

    @Override
    public void destroy() {
        super.destroy();
        this.urlParameters = null;
    }

    public Boolean isOpenNewFrame() {
        return this.openNewFrame;
    }

    public void setOpenNewFrame(Boolean openNewFrame) {
        this.openNewFrame = openNewFrame;
    }

    public void addUrlParameter(String key, String value) {
        this.urlParameters.put(key, value);
    }

    public void removeUrlParameter(String key) {
        this.urlParameters.remove(key);
    }

    public void clearUrlParameter() {
        this.urlParameters.clear();
    }

    public Map<String, String> getUrlParameters() {
        return Collections.unmodifiableMap(this.urlParameters);
    }

    @Override
    protected void copy(LightUIElement element) {
        super.copy(element);
        if (!(element instanceof LightUIButtonLink)) {
            throw new InvalidClassException(LightUIButtonLink.class.getName(), element.getClassName(), element.getId());
        }
        LightUIButtonLink button = (LightUIButtonLink)element;
        this.openNewFrame = button.openNewFrame;
        this.urlParameters = button.urlParameters;
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = super.toJSON();
        if (this.openNewFrame.booleanValue()) {
            json.put(OPEN_NEW_FRAME_KEY, true);
        }
        if (!this.urlParameters.isEmpty()) {
            json.put(URL_PARAMETER_KEY, this.urlParameters);
        }
        return json;
    }

    @Override
    public void fromJSON(JSONObject json) {
        super.fromJSON(json);
        this.openNewFrame = JSONConverter.getParameterFromJSON(json, OPEN_NEW_FRAME_KEY, Boolean.class, Boolean.valueOf(false));
        this.urlParameters = CollectionUtils.castMap(JSONConverter.getParameterFromJSON(json, URL_PARAMETER_KEY, Map.class), String.class, String.class);
    }
}

