/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.light;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minidev.json.JSONObject;
import org.openconcerto.ui.light.LightUIComboBox;
import org.openconcerto.ui.light.LightUIComboBoxElement;
import org.openconcerto.ui.light.LightUIComboRequest;
import org.openconcerto.utils.io.JSONConverter;

public class LightUIAutoCompleteComboBox
extends LightUIComboBox {
    private static final String FILTER = "filter";
    private String filter;
    private LightUIComboRequest request;
    private List<LightUIComboBoxElement> cacheValues = new ArrayList<LightUIComboBoxElement>();

    public LightUIAutoCompleteComboBox() {
    }

    public LightUIAutoCompleteComboBox(String id) {
        super(id);
        this.setType(31);
    }

    public void setComboRequest(LightUIComboRequest request) {
        this.request = request;
        this.setFilter("");
        this.setAlreadyFilled(true);
    }

    public LightUIComboRequest getComboRequest() {
        return this.request;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
        this.applyFilter();
    }

    @Override
    public void addValue(LightUIComboBoxElement values) {
        this.cacheValues.add(values);
    }

    @Override
    public void addValues(List<LightUIComboBoxElement> values) {
        this.cacheValues.addAll(values);
    }

    private void applyFilter() {
        Integer selectedId = null;
        if (this.hasSelectedValue()) {
            selectedId = this.getSelectedValue().getId();
        }
        this.clearValues();
        if (this.hasNotSpecifedLine()) {
            this.addValue(LightUIComboBox.getDefaultValue());
        }
        Optional<LightUIComboBoxElement> sel = Optional.ofNullable(this.hasSelectedValue() ? this.getSelectedValue() : null);
        if (this.request != null) {
            List<LightUIComboBoxElement> items = this.request.getItems(this.filter, sel);
            for (LightUIComboBoxElement item : items) {
                super.addValue(item);
            }
        } else if (this.filter.trim().length() > 2) {
            String txt = this.filter.toLowerCase();
            for (LightUIComboBoxElement item : this.cacheValues) {
                if ((item.getValue1() == null || !item.getValue1().toLowerCase().contains(txt)) && (item.getValue2() == null || !item.getValue2().toLowerCase().contains(txt))) continue;
                super.addValue(item);
            }
        }
        this.setSelectedId(selectedId);
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = super.toJSON();
        json.put(FILTER, this.filter);
        return json;
    }

    @Override
    public void fromJSON(JSONObject json) {
        super.fromJSON(json);
        this.filter = JSONConverter.getParameterFromJSON(json, FILTER, String.class);
    }
}

