/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.grid;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openconcerto.ui.VFlowLayout;
import org.openconcerto.ui.grid.GridItem;
import org.openconcerto.ui.grid.GridListener;
import org.openconcerto.ui.grid.GridPanel;
import org.openconcerto.ui.grid.TwoYearsHeaderPanel;

public class DecoratedGridPanel
extends JPanel {
    private GridPanel grid;
    final JScrollPane scroll;

    public DecoratedGridPanel(JComponent header, int columnCount, int rowHeight, List<JComponent> rowHeader) {
        this.setBackground(Color.WHITE);
        this.setLayout(new GridLayout(1, 1));
        JPanel topLeft = new JPanel();
        topLeft.setMinimumSize(new Dimension(0, 0));
        this.grid = new GridPanel(columnCount, rowHeader.size(), rowHeight);
        header.setPreferredSize(new Dimension(this.grid.getPreferredSize().width, header.getMinimumSize().height));
        header.setMaximumSize(new Dimension(this.grid.getPreferredSize().width, header.getMinimumSize().height));
        header.setMinimumSize(new Dimension(this.grid.getPreferredSize().width, header.getMinimumSize().height));
        JComponent left = this.createLeft(rowHeader, this.grid.getCellHeight());
        this.scroll = new JScrollPane(this.grid);
        this.scroll.setVerticalScrollBarPolicy(22);
        this.scroll.setHorizontalScrollBarPolicy(32);
        this.scroll.setBorder(null);
        this.add(this.scroll);
        this.scroll.setRowHeaderView(left);
        this.scroll.setColumnHeaderView(header);
        this.scroll.getRowHeader().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JViewport viewport = (JViewport)e.getSource();
                DecoratedGridPanel.this.scroll.getVerticalScrollBar().setValue(viewport.getViewPosition().y);
            }
        });
    }

    public int getYScrollLocation() {
        return this.scroll.getVerticalScrollBar().getValue();
    }

    public void setYScrollLocation(int location) {
        this.scroll.getVerticalScrollBar().setValue(location);
    }

    private JComponent createLeft(List<JComponent> rowHeader, int h) {
        JPanel p = new JPanel();
        p.setLayout(new VFlowLayout(0, 1, 1, true));
        for (JComponent c : rowHeader) {
            c.setMinimumSize(new Dimension(c.getMinimumSize().width, h));
            c.setPreferredSize(new Dimension(c.getPreferredSize().width, h));
            p.add(c);
        }
        return p;
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException exception) {
                    // empty catch block
                }
                JFrame f = new JFrame();
                f.setDefaultCloseOperation(3);
                TwoYearsHeaderPanel b = new TwoYearsHeaderPanel(2018);
                ArrayList<JComponent> panels = new ArrayList<JComponent>();
                int i = 0;
                while (i < 8) {
                    panels.add(new JButton("line " + i));
                    ++i;
                }
                DecoratedGridPanel contentPane = new DecoratedGridPanel(b, 24, 40, panels);
                contentPane.add(new GridItem(0, 0, 1, 1));
                contentPane.add(new GridItem(4, 0, 3, 1));
                contentPane.add(new GridItem(1, 1, 2, 1));
                f.setContentPane(contentPane);
                f.pack();
                f.setSize(400, 286);
                f.setLocationRelativeTo(null);
                f.setVisible(true);
            }
        });
    }

    public void add(GridItem gridItem) {
        this.grid.add(gridItem);
    }

    public void setEnableEditMode(boolean enable) {
        this.grid.setEnableEditMode(enable);
    }

    public void setGridListener(GridListener gridListener) {
        this.grid.setGridListener(gridListener);
    }
}

