/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.effect;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class Spots
extends JComponent
implements Runnable {
    public static final String START_SLEEPING_PROP_NAME = String.valueOf(Spots.class.getSimpleName()) + ".startSleeping";
    static final boolean START_SLEEPING = Boolean.getBoolean(START_SLEEPING_PROP_NAME);
    static int width = 256;
    static int height = 48;
    private int x;
    private int y;
    private int K;
    private double P;
    private double Q;
    private double R;
    private double S;
    private double U;
    private double V;
    private double W;
    private double X;
    private Thread updateThread;
    private MediaTracker mediaTracker;
    private Image imagePalette;
    private Image imageSpot;
    private boolean initDone;
    private boolean ga;
    private int ha;
    private int ka;
    private float ma;
    private int offset;
    private int pa;
    private int[] pixles;
    private int[] ua;
    private int[] va;
    private Image onScreenImage;
    private MemoryImageSource imageSource;
    private long sleeptime;
    private static final int DEFAULT_SLEEPTIME = 20;
    private static final int STOP_SLEEPTIME = 3600000;

    public static void main(String[] args) {
        JFrame f = new JFrame();
        Spots blob1 = new Spots();
        blob1.setPreferredSize(new Dimension(width, height));
        f.setContentPane(blob1);
        f.pack();
        f.setVisible(true);
    }

    public Spots() {
        this(START_SLEEPING, true);
    }

    public Spots(boolean startSleeping, boolean addMouseListener) {
        this.sleeptime = startSleeping ? 3600000 : 20;
        this.ga = true;
        this.pixles = new int[width * height];
        this.ua = new int[65792];
        this.va = new int[4146];
        this.setPreferredSize(new Dimension(width, height));
        this.setMinimumSize(new Dimension(width, height));
        this.setMaximumSize(new Dimension(width, height));
        if (addMouseListener) {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (Spots.this.sleeptime == 20L) {
                        Spots.this.sleeptime = 3600000L;
                    } else {
                        Spots.this.sleeptime = 20L;
                        Spots.this.updateThread.interrupt();
                    }
                }
            });
        }
    }

    public void init() {
        this.setBackground(Color.black);
        DirectColorModel colorModel = new DirectColorModel(32, 0xFF0000, 65280, 255, 0);
        this.imageSource = new MemoryImageSource(width, height, (ColorModel)colorModel, this.pixles, 0, width);
        this.imageSource.setAnimated(true);
        this.imageSource.setFullBufferUpdates(true);
        this.onScreenImage = this.createImage(this.imageSource);
        this.mediaTracker = new MediaTracker(this);
        this.imagePalette = new ImageIcon(Spots.class.getResource("pal3.gif")).getImage();
        this.mediaTracker.addImage(this.imagePalette, 0);
        this.imageSpot = new ImageIcon(Spots.class.getResource("blob.gif")).getImage();
        this.mediaTracker.addImage(this.imageSpot, 1);
        this.initDone = false;
        int i = 0;
        while (i < width * height) {
            this.pixles[i] = 156565;
            ++i;
        }
        int j = 0;
        while (j < 65536) {
            this.ua[j + 256] = -1;
            ++j;
        }
        this.P = 0.0;
        this.Q = 1.0;
        this.R = 2.0;
        this.S = 3.0;
    }

    public void rotatePaletteAt(int i, int j) {
        this.offset = i + j * width;
        this.pa = 0;
        int k = 0;
        while (k < 64) {
            int l = 0;
            while (l < 64) {
                if (this.offset >= 0 && this.offset < this.pixles.length) {
                    int n = this.offset;
                    this.pixles[n] = this.pixles[n] + this.va[this.pa];
                }
                ++this.pa;
                ++this.offset;
                ++l;
            }
            this.offset += width - 64;
            ++k;
        }
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void paint(Graphics g) {
        this.start();
        if (this.initDone) {
            ++this.ha;
            this.P += 0.04 * (double)this.ma;
            this.Q += 0.054 * (double)this.ma;
            this.R += 0.06 * (double)this.ma;
            this.S += 0.034 * (double)this.ma;
            int i = 0;
            while (i < width * height) {
                this.pixles[i] = 0;
                ++i;
            }
            float centerX = (float)(width - 64) / 2.0f;
            float centerY = (float)(height - 64) / 2.0f;
            this.U = this.P;
            this.V = this.Q;
            this.W = this.R;
            this.X = this.S;
            int j = 0;
            while (j < 6) {
                this.x = (int)(80.0 + 30.0 * Math.cos(this.U));
                this.y = (int)((double)centerY + 18.0 * Math.sin(this.U));
                this.rotatePaletteAt(this.x, this.y);
                this.x = (int)((double)centerX + 50.0 + (double)(centerX / 2.0f) * Math.cos(-this.W));
                this.y = (int)((double)centerY + (double)(centerY - 10.0f) * Math.sin(-this.W));
                this.rotatePaletteAt(this.x, this.y);
                this.x = (int)((double)(width + 20) + 18.0 * Math.cos(this.W + 1.0));
                this.y = (int)((double)centerY + 18.0 * Math.sin(this.W));
                this.rotatePaletteAt(this.x, this.y);
                this.U += (double)0.11f;
                this.V += (double)0.34f;
                this.W += (double)2.44f;
                this.X += (double)9.44f;
                ++j;
            }
            int k = 0;
            while (k < width * height) {
                int value;
                this.pixles[k] = this.ua[this.pixles[k]] & 0xFFFFFF;
                this.pixles[k] = -this.pixles[k] + 0xFFFFFF;
                int b = this.pixles[k] & 0xFF;
                float bf = 255 - b;
                int red = b + (int)(bf * 0.24313726f);
                int green = b + (int)(bf * 0.019607844f);
                int blue = b + (int)(bf * 0.5529412f);
                if (red > 255) {
                    red = 255;
                }
                if (green > 255) {
                    green = 255;
                }
                if (blue > 255) {
                    blue = 255;
                }
                this.pixles[k] = value = 0xFF000000 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | (blue & 0xFF) << 0;
                ++k;
            }
            if (this.imageSource != null) {
                this.imageSource.newPixels();
            }
            g.drawImage(this.onScreenImage, 0, 0, null);
            this.getToolkit().sync();
        }
    }

    private void b() {
        if (this.ga) {
            while (!this.mediaTracker.checkAll(true)) {
                try {
                    Thread.sleep(20L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        PixelGrabber pixelgrabberPalette = new PixelGrabber(this.imagePalette, 0, 0, 256, 1, this.ua, 0, 256);
        try {
            pixelgrabberPalette.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        PixelGrabber pixelgrabberSpot = new PixelGrabber(this.imageSpot, 0, 0, 64, 64, this.va, 0, 64);
        try {
            pixelgrabberSpot.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.offset = 0;
        int i = 0;
        while (i < 64) {
            int j = 0;
            while (j < 64) {
                this.va[this.offset] = this.K = this.va[this.offset] & 0xFF;
                ++this.offset;
                ++j;
            }
            ++i;
        }
        this.initDone = true;
    }

    public void start() {
        if (this.updateThread == null) {
            this.init();
            this.b();
            this.updateThread = new Thread((Runnable)this, this.getClass().getName());
            this.updateThread.setDaemon(true);
            this.updateThread.start();
        }
    }

    public void stop() {
        this.updateThread = null;
    }

    @Override
    public void run() {
        long lastCurrentTimeMillis = System.currentTimeMillis() - 250L;
        this.ha = 0;
        this.ma = 2.0E-4f;
        while (Thread.currentThread() == this.updateThread) {
            this.repaint();
            long currentTimeMillis = System.currentTimeMillis();
            if (currentTimeMillis - lastCurrentTimeMillis > 500L) {
                this.ka = this.ha;
                lastCurrentTimeMillis = currentTimeMillis;
                this.ha = 0;
                this.ma = this.ma * 0.35f + 0.65f * (50.0f / (float)(this.ka * 2));
                if (this.ma < 2.0E-5f) {
                    this.ma = 2.0E-5f;
                }
                if (this.ma > 40.0f) {
                    this.ma = 40.0f;
                }
            }
            try {
                Thread.sleep(this.sleeptime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

