/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.component.combo;

import java.util.List;
import org.openconcerto.ui.component.combo.ISearchableComboCompletionThread;

public interface SearchMode {
    public ComboMatcher matcher(String var1);

    public static abstract class ComboMatcher {
        private final String search;

        public ComboMatcher(String s) {
            this.search = s;
        }

        public final String getSearch() {
            return this.search;
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + " for " + this.getSearch();
        }

        public abstract boolean match(String var1);
    }

    public static final class DefaultSearchMode
    implements SearchMode {
        private final boolean contains;

        DefaultSearchMode(boolean contains) {
            this.contains = contains;
        }

        @Override
        public ComboMatcher matcher(String s) {
            final List<String> values = ISearchableComboCompletionThread.cut(s);
            final int stop = values.size();
            return new ComboMatcher(s){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public boolean match(String item) {
                    boolean ok = false;
                    int j = 0;
                    while (j < stop) {
                        String lowerCaseValue = (String)values.get(j);
                        if (contains) {
                            if (item.indexOf(lowerCaseValue) < 0) return false;
                            ok = true;
                        } else {
                            if (!item.startsWith(lowerCaseValue)) return false;
                            ok = true;
                        }
                        ++j;
                    }
                    return ok;
                }
            };
        }
    }
}

