/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.component;

import java.text.ParseException;
import javax.swing.text.MaskFormatter;

public class AllowBlankMaskFormatter
extends MaskFormatter {
    private boolean allowBlankField = true;
    private String blankRepresentation;

    public AllowBlankMaskFormatter() {
    }

    public AllowBlankMaskFormatter(String mask) throws ParseException {
        super(mask);
    }

    public void setAllowBlankField(boolean allowBlankField) {
        this.allowBlankField = allowBlankField;
    }

    public boolean isAllowBlankField() {
        return this.allowBlankField;
    }

    @Override
    public void setMask(String mask) throws ParseException {
        super.setMask(mask);
        this.updateBlankRepresentation();
    }

    @Override
    public void setPlaceholderCharacter(char placeholder) {
        super.setPlaceholderCharacter(placeholder);
        this.updateBlankRepresentation();
    }

    @Override
    public Object stringToValue(String value) throws ParseException {
        Object result = value;
        result = this.isAllowBlankField() && this.blankRepresentation != null && this.blankRepresentation.equals(value) ? null : super.stringToValue(value);
        return result;
    }

    private void updateBlankRepresentation() {
        try {
            this.blankRepresentation = this.valueToString(null);
        }
        catch (ParseException e) {
            this.blankRepresentation = null;
        }
    }
}

