/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui;

import java.awt.FlowLayout;
import java.util.Calendar;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TimeSpinField
extends JPanel {
    private JSpinner spinHour;
    private JSpinner spinMinute;

    public TimeSpinField() {
        this.init(0, 0);
    }

    public TimeSpinField(boolean fillWithCurrentTime) {
        if (fillWithCurrentTime) {
            Calendar c = Calendar.getInstance();
            this.init(c.get(11), c.get(12));
        } else {
            this.init(0, 0);
        }
    }

    public TimeSpinField(int hour, int minute) {
        this.init(hour, minute);
    }

    private void init(int hour, int minute) {
        this.setLayout(new FlowLayout());
        this.setOpaque(false);
        this.spinHour = new JSpinner(new SpinnerNumberModel(hour, 0, 23, 1));
        this.spinMinute = new JSpinner(new SpinnerNumberModel(minute, 0, 59, 1));
        this.setTime(hour, minute);
        this.spinHour.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                TimeSpinField.this.firePropertyChange("value", null, null);
            }
        });
        this.spinMinute.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                TimeSpinField.this.firePropertyChange("value", null, null);
            }
        });
        this.add(this.spinHour);
        this.add(new JLabel(" : "));
        this.add(this.spinMinute);
    }

    public void setTime(int hour, int minute) {
        if (hour < 0 || hour > 23) {
            throw new IllegalArgumentException("Hour must be betwen 0 and 23 but is " + hour);
        }
        if (minute < 0 || minute > 59) {
            throw new IllegalArgumentException("Minute must be betwen 0 and 59 but is " + minute);
        }
        this.spinHour.setValue(hour);
        this.spinMinute.setValue(minute);
    }

    public int getHours() {
        return ((Number)this.spinHour.getValue()).intValue();
    }

    public int getMinutes() {
        return ((Number)this.spinMinute.getValue()).intValue();
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        TimeSpinField time = new TimeSpinField(true);
        time.setTime(10, 59);
        f.setContentPane(time);
        f.pack();
        f.setLocationRelativeTo(null);
        f.setDefaultCloseOperation(3);
        f.setVisible(true);
    }
}

