/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ColorField
extends JPanel {
    private Color color = Color.WHITE;
    private JPanel colorPanel = new JPanel();

    public ColorField(final String chooserTitle) {
        this.setLayout(new FlowLayout(0, 0, 0));
        int h = new JTextField((String)"O").getPreferredSize().height;
        this.colorPanel.setPreferredSize(new Dimension(h * 2, h));
        this.colorPanel.setMinimumSize(new Dimension(h, h));
        this.colorPanel.setMaximumSize(new Dimension(h * 2, h));
        this.colorPanel.setBackground(this.color);
        this.colorPanel.setOpaque(true);
        this.colorPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.colorPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                Color c = JColorChooser.showDialog(ColorField.this.colorPanel, chooserTitle, ColorField.this.getColor());
                Color oldValue = ColorField.this.getColor();
                ColorField.this.setColor(c);
                ColorField.this.firePropertyChange("value", oldValue, c);
            }
        });
        this.add(this.colorPanel);
    }

    public void setColor(Color c) {
        this.color = c;
        this.colorPanel.setBackground(c);
    }

    public Color getColor() {
        return this.color;
    }
}

