/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.task.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.ListModel;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.users.User;
import org.openconcerto.sql.users.UserManager;
import org.openconcerto.task.UserTaskRight;
import org.openconcerto.task.ui.UserListModel;
import org.openconcerto.task.ui.UserTaskRightListCellRenderer;
import org.openconcerto.ui.DisplayabilityListener;
import org.openconcerto.utils.ExceptionHandler;

public class UserRightPanelDetail
extends JPanel {
    JLabel labelDocumentation1 = new JLabel("");
    JLabel labelDocumentation2 = new JLabel("");
    private final UserListModel model;
    private final SQLTable tableTacheRights;
    UserTaskRightListCellRenderer cellRenderer1 = new UserTaskRightListCellRenderer(0);
    UserTaskRightListCellRenderer cellRenderer2 = new UserTaskRightListCellRenderer(1);
    UserTaskRightListCellRenderer cellRenderer3 = new UserTaskRightListCellRenderer(2);
    UserTaskRightListCellRenderer cellRenderer4 = new UserTaskRightListCellRenderer(3);
    private User selectedUser;
    private JList list1;
    private JList list2;
    private JList list3;
    private JList list4;

    UserRightPanelDetail(UserManager uMngr, DBRoot root) {
        int YTOP;
        this.model = new UserListModel(uMngr);
        this.tableTacheRights = root.getTable("TACHE_RIGHTS");
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(4, 10, 2, 2);
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 4;
        this.labelDocumentation1.setFont(this.labelDocumentation1.getFont().deriveFont(1));
        this.add((Component)this.labelDocumentation1, c);
        ++c.gridy;
        c.insets = new Insets(0, 10, 10, 2);
        this.add((Component)this.labelDocumentation2, c);
        ++c.gridy;
        c.insets = new Insets(0, 0, 0, 0);
        this.add((Component)new JSeparator(0), c);
        c.fill = 1;
        c.insets = new Insets(2, 10, 2, 10);
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.gridy = YTOP = c.gridy + 1;
        c.weighty = 0.0;
        JLabel label1 = new JLabel("Voir les t\u00e2ches assign\u00e9es \u00e0:");
        this.add((Component)label1, c);
        ++c.gridy;
        this.list1 = new JList<User>(this.model);
        this.list1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                UserRightPanelDetail.this.swapOnDoubleClick(UserRightPanelDetail.this.list1, e, "READ");
            }
        });
        this.list1.setCellRenderer(this.cellRenderer1);
        c.weighty = 1.0;
        this.add((Component)new JScrollPane(this.list1), c);
        ++c.gridx;
        c.gridy = YTOP;
        c.weighty = 0.0;
        JLabel label2 = new JLabel("Modifier les t\u00e2ches cr\u00e9\u00e9es par:");
        this.add((Component)label2, c);
        ++c.gridy;
        this.list2 = new JList<User>(this.model);
        this.list2.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                UserRightPanelDetail.this.swapOnDoubleClick(UserRightPanelDetail.this.list2, e, "MODIFY");
            }
        });
        this.list2.setCellRenderer(this.cellRenderer2);
        c.weighty = 1.0;
        this.add((Component)new JScrollPane(this.list2), c);
        ++c.gridx;
        c.gridy = YTOP;
        c.weighty = 0.0;
        JLabel label3 = new JLabel("Assigner des t\u00e2ches \u00e0:");
        this.add((Component)label3, c);
        ++c.gridy;
        this.list3 = new JList<User>(this.model);
        this.list3.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                UserRightPanelDetail.this.swapOnDoubleClick(UserRightPanelDetail.this.list3, e, "ADD");
            }
        });
        this.list3.setCellRenderer(this.cellRenderer3);
        c.weighty = 1.0;
        this.add((Component)new JScrollPane(this.list3), c);
        ++c.gridx;
        c.gridy = YTOP;
        c.weighty = 0.0;
        JLabel label4 = new JLabel("Valider les t\u00e2ches de:");
        this.add((Component)label4, c);
        ++c.gridy;
        this.list4 = new JList<User>(this.model);
        this.list4.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                UserRightPanelDetail.this.swapOnDoubleClick(UserRightPanelDetail.this.list4, e, "VALIDATE");
            }
        });
        this.list4.setCellRenderer(this.cellRenderer4);
        c.weighty = 1.0;
        this.add((Component)new JScrollPane(this.list4), c);
        c.weighty = 0.0;
        ++c.gridy;
        c.fill = 2;
        c.gridx = 0;
        c.gridwidth = 4;
        JLabel labelHelp = new JLabel("Une autorisation d\u00e9sactiv\u00e9e apparait en gris clair");
        labelHelp.setIcon(new ImageIcon(UserRightPanelDetail.class.getResource("toc_open.gif")));
        this.add((Component)labelHelp, c);
        this.addHierarchyListener(new DisplayabilityListener(){

            @Override
            protected void displayabilityChanged(Component c) {
                if (c.isDisplayable()) {
                    UserRightPanelDetail.this.model.start();
                } else {
                    UserRightPanelDetail.this.model.stop();
                }
            }
        });
        this.setUser(null);
    }

    private void swapOnDoubleClick(JList list, MouseEvent e, String field) {
        int index;
        if (e.getClickCount() == 2 && (index = list.locationToIndex(e.getPoint())) >= 0) {
            ListModel dlm = list.getModel();
            Object item = dlm.getElementAt(index);
            list.ensureIndexIsVisible(index);
            User toUser = (User)item;
            this.swapState(this.selectedUser, toUser, field);
        }
    }

    protected void swapState(User user, User toUser, String field) {
        SQLRowValues rowV;
        SQLSelect sel = new SQLSelect();
        sel.addSelectStar(this.tableTacheRights);
        Where where = new Where((FieldRef)this.tableTacheRights.getField("ID_USER_COMMON"), "=", user.getId());
        where = where.and(new Where((FieldRef)this.tableTacheRights.getField("ID_USER_COMMON_TO"), "=", toUser.getId()));
        sel.setWhere(where);
        List<SQLRow> rows = SQLRowListRSH.execute(sel);
        if (rows.size() == 0) {
            rowV = new SQLRowValues(this.tableTacheRights);
            rowV.put("ID_USER_COMMON", user.getId());
            rowV.put("ID_USER_COMMON_TO", toUser.getId());
            rowV.put(field, Boolean.TRUE);
        } else if (rows.size() == 1) {
            SQLRow row = rows.get(0);
            rowV = row.createEmptyUpdateRow();
            rowV.put(field, row.getBoolean(field) == false);
        } else {
            throw new IllegalStateException("More than one row : " + rows);
        }
        try {
            rowV.commit();
            this.setUser(this.selectedUser);
        }
        catch (SQLException e1) {
            ExceptionHandler.handle(this, "Impossible de changer la valeur", e1);
        }
    }

    public void setUser(User selectedUser) {
        if (selectedUser == null) {
            this.labelDocumentation1.setText(" Veuillez s\u00e9lectionner un utilisateur");
            this.labelDocumentation2.setText(" Pour cela, cliquez sur un nom de la liste de gauche");
            this.list1.setEnabled(false);
            this.list2.setEnabled(false);
            this.list3.setEnabled(false);
            this.list4.setEnabled(false);
            return;
        }
        this.selectedUser = selectedUser;
        this.labelDocumentation1.setText(" Autorisations de l'utilisateur " + selectedUser.getFirstName() + " " + selectedUser.getName());
        this.labelDocumentation2.setText(" Double cliquez sur un nom d'une des colonnes suivantes pour activer/d\u00e9sactiver le droit correspondant.");
        List<UserTaskRight> l = UserTaskRight.getUserTaskRight(selectedUser);
        this.cellRenderer1.setUserTaskRight(l);
        this.cellRenderer2.setUserTaskRight(l);
        this.cellRenderer3.setUserTaskRight(l);
        this.cellRenderer4.setUserTaskRight(l);
        this.model.clearAndReload();
        this.list1.setEnabled(true);
        this.list2.setEnabled(true);
        this.list3.setEnabled(true);
        this.list4.setEnabled(true);
    }
}

