/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view.list;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.openconcerto.sql.view.list.ITableModel;
import org.openconcerto.ui.list.selection.BaseListStateModel;
import org.openconcerto.utils.TableSorter;

public final class TableListStateModel
extends BaseListStateModel {
    private static final String UPDATING = "updating";
    private final TableSorter sorter;

    public TableListStateModel(TableSorter sorter) {
        this.sorter = sorter;
        this.sorter.addPropertyChangeListener("sorting", this.getUpdateL());
        this.sorter.addPropertyChangeListener("tableModel", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                TableListStateModel.this.updateListener((ITableModel)evt.getOldValue(), (ITableModel)evt.getNewValue());
            }
        });
        this.updateListener(null, this.getTableModel());
    }

    private void updateListener(ITableModel oldTableModel, ITableModel newTableModel) {
        if (oldTableModel != null) {
            oldTableModel.rmPropertyChangeListener(UPDATING, this.getUpdateL());
        }
        if (newTableModel != null) {
            newTableModel.addPropertyChangeListener(UPDATING, this.getUpdateL());
        }
    }

    private ITableModel getTableModel() {
        return (ITableModel)this.sorter.getTableModel();
    }

    @Override
    public int idFromIndex(int rowIndex) {
        try {
            int modelIndex = this.sorter.modelIndex(rowIndex);
            return this.getTableModel().idFromIndex(modelIndex);
        }
        catch (IndexOutOfBoundsException e) {
            return -1;
        }
    }

    @Override
    public int indexFromID(int id) {
        int modelIndex = this.getTableModel().indexFromID(id);
        if (modelIndex == -1) {
            return -1;
        }
        return this.sorter.viewIndex(modelIndex);
    }
}

