/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view.list;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import net.jcip.annotations.NotThreadSafe;
import org.openconcerto.sql.model.ConnectionHandlerNoSetup;
import org.openconcerto.sql.model.OrderComparator;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.utils.SQLUtils;
import org.openconcerto.sql.view.list.ITableModel;
import org.openconcerto.sql.view.list.ListSQLLine;
import org.openconcerto.sql.view.list.MoveQueue;
import org.openconcerto.sql.view.list.SQLTableModelLinesSource;
import org.openconcerto.sql.view.list.SQLTableModelSourceOffline;
import org.openconcerto.utils.CompareUtils;
import org.openconcerto.utils.SetMap;
import org.openconcerto.utils.Value;
import org.openconcerto.utils.cc.IClosure;
import org.openconcerto.utils.cc.ITransformerExn;

public class SQLTableModelLinesSourceOffline
extends SQLTableModelLinesSource {
    private final SQLTableModelSourceOffline parent;
    private final List<Row> lines = new LinkedList<Row>();
    private int freeID = -10;
    private final Map<Integer, Row> id2line = new HashMap<Integer, Row>();
    private final SQLRowValues modifiableVals;
    private final Map<Row, SQLRowValues> dbVals;
    private final Set<Number> deleted;
    private boolean dbOrder = true;

    public SQLTableModelLinesSourceOffline(SQLTableModelSourceOffline parent, ITableModel model) {
        super(model);
        this.parent = parent;
        this.modifiableVals = this.getParent().getElem().getPrivateGraph().toImmutable();
        this.dbVals = new HashMap<Row, SQLRowValues>();
        this.deleted = new HashSet<Number>();
    }

    @Override
    public final SQLTableModelSourceOffline getParent() {
        return this.parent;
    }

    private boolean isUpdateThread() {
        return this.getModel().getUpdateQ().currentlyInQueue();
    }

    private void checkUpdateThread() {
        if (!this.isUpdateThread()) {
            throw new IllegalStateException("Not in the update thread");
        }
    }

    private final Row getRow(Integer id) {
        return this.getRow(id, false);
    }

    private final Row getRow(Integer id, boolean required) {
        return this.getRow(id, required, null);
    }

    private final Row getRow(Integer id, boolean required, Object idSource) {
        Row res = this.id2line.get(id);
        if (required && res == null) {
            throw new IllegalArgumentException("Not in the list : " + (idSource == null ? id : idSource));
        }
        return res;
    }

    public final Row getRowNow(Integer id, boolean required) {
        this.checkUpdateThread();
        return this.getRow(id, required);
    }

    public final List<Row> getRowsNow() {
        this.checkUpdateThread();
        return Collections.unmodifiableList(this.lines);
    }

    protected final int getSize() {
        return this.lines.size();
    }

    private final int indexOf(Row r) {
        return this.lines.indexOf(r);
    }

    protected final List<ListSQLLine> getLines() {
        ArrayList<ListSQLLine> res = new ArrayList<ListSQLLine>();
        for (Row r : this.lines) {
            ListSQLLine l = this.createLine(r);
            if (l == null) continue;
            res.add(l);
        }
        return res;
    }

    private final boolean isDBOrder() {
        return this.dbOrder;
    }

    private final boolean setDBOrder(boolean dbOrder) {
        assert (this.isUpdateThread());
        if (this.dbOrder != dbOrder) {
            this.dbOrder = dbOrder;
            return true;
        }
        return false;
    }

    private final Number getOrder(Row r) {
        if (this.isDBOrder()) {
            return null;
        }
        return this.indexOf(r);
    }

    private final ListSQLLine createLine(Row r) {
        if (r == null) {
            return null;
        }
        ListSQLLine res = this.createLine(r.vals, r.id);
        if (res != null) {
            res.setOrder(this.getOrder(r));
        }
        return res;
    }

    protected final List<SQLRowValues> fetch() {
        return this.getUpdateQueueReq().getValues();
    }

    @Override
    public List<ListSQLLine> get(Collection<? extends Number> ids) {
        assert (this.isUpdateThread());
        if (ids != null) {
            throw new UnsupportedOperationException("Refreshing a subset of rows is not yet supported");
        }
        List<SQLRowValues> dbRows = this.fetch();
        if (this.lines.isEmpty()) {
            for (SQLRowValues dbRow : dbRows) {
                this._add(dbRow, false, false);
            }
        } else {
            HashSet<Integer> dbIDs = new HashSet<Integer>();
            for (SQLRowValues dbRow : dbRows) {
                dbIDs.add(dbRow.getIDNumber(true).intValue());
            }
            HashSet<Integer> deletedIDs = new HashSet<Integer>(this.id2line.keySet());
            deletedIDs.removeAll(dbIDs);
            for (Integer id : deletedIDs) {
                if (id < 0) continue;
                Value<ListSQLLine> val = this.updateRow(id, (SQLRowValues)null);
                assert (val.getValue() == null);
            }
            for (SQLRowValues dbRow : dbRows) {
                this.updateRow(dbRow.getID(), dbRow);
            }
        }
        return this.getLines();
    }

    private final Value<ListSQLLine> updateRow(int id, SQLRowValues row) {
        Row newRow;
        Row existingLine = this.getRow(id);
        if (row != null && existingLine != null && this.dbVals.containsKey(existingLine)) {
            return Value.getNone();
        }
        if (row == null) {
            this._rm(existingLine);
            newRow = null;
        } else if (existingLine != null) {
            existingLine.setRow(row);
            newRow = existingLine;
        } else {
            newRow = this._add(row, false, false);
        }
        return Value.getSome(this.createLine(newRow));
    }

    @Override
    public Value<ListSQLLine> get(int id) {
        assert (this.isUpdateThread());
        return this.updateRow(id, this.getUpdateQueueReq().getValues(id));
    }

    private final <T> Future<T> execInUpdateQ(OfflineCallable<T> call) {
        return this.getModel().getUpdateQ().add(new FutureTask<T>(call));
    }

    public final Future<Number> add(SQLRowValues vals) {
        final SQLRowValues copy = vals.deepCopy();
        return this.execInUpdateQ(new OfflineCallable<Number>(){

            @Override
            public Number call() throws Exception {
                return SQLTableModelLinesSourceOffline.this.addNow(copy, true);
            }
        });
    }

    public final Integer addNow(SQLRowValues vals) {
        return this.addNow(vals, false);
    }

    private final Integer addNow(SQLRowValues vals, boolean safe) {
        if (!safe) {
            this.checkUpdateThread();
        }
        SQLRowValues copy = safe ? vals : vals.deepCopy();
        copy.clearPrimaryKeys();
        return this._add(copy, true, true).getID();
    }

    protected Row _add(SQLRowValues vals, boolean grow, boolean fireAdd) {
        List<Integer> order;
        int n;
        boolean fromDB;
        assert (this.isUpdateThread());
        if (grow) {
            vals.grow(this.getUpdateQueueReq().getGraphToFetch(), false);
        }
        vals.getGraph().freeze();
        boolean bl = fromDB = vals.hasID() && vals.getID() >= 0;
        if (fromDB) {
            n = vals.getID();
        } else {
            int n2 = this.freeID;
            n = n2;
            this.freeID = n2 - 1;
        }
        Row r = new Row(n, vals);
        this.id2line.put(r.getID(), r);
        this.lines.add(r);
        if (!fromDB && this.setDBOrder(false)) {
            order = this.getIDsOrder();
            assert (order != null);
        } else {
            order = null;
        }
        if (order != null) {
            this.getModel().getUpdateQ().reorder(order);
        }
        if (fireAdd) {
            ListSQLLine line = this.createLine(r);
            this.getModel().getUpdateQ().replaceLine(r.getID(), line);
        }
        return r;
    }

    public final Future<SQLRowValues> remove(final Number id) {
        return this.execInUpdateQ(new OfflineCallable<SQLRowValues>(){

            @Override
            public SQLRowValues call() throws Exception {
                Row r = SQLTableModelLinesSourceOffline.this.getRow(id.intValue());
                return SQLTableModelLinesSourceOffline.this.rm(r);
            }
        });
    }

    public final SQLRowValues removeNow(Row r) {
        this.checkUpdateThread();
        return this.rm(r);
    }

    private SQLRowValues rm(Row r) {
        if (r != null) {
            this._rm(r);
            if (r.vals.hasID()) {
                this.deleted.add(r.vals.getIDNumber());
            }
            this.getModel().getUpdateQ().replaceLine(r.getID(), null);
            return r.vals;
        }
        return null;
    }

    private void _rm(Row l) {
        assert (this.isUpdateThread());
        if (l != null) {
            this.lines.remove(l);
            this.id2line.remove(l.id);
            this.dbVals.remove(l);
        }
    }

    @Override
    public void commit(final ListSQLLine l, final Path path, final SQLRowValues vals) {
        this.checkCanModif(path);
        if (!vals.isFrozen()) {
            throw new IllegalArgumentException("Not frozen");
        }
        this.execInUpdateQ(new OfflineRunnable(){

            @Override
            public void run() {
                SQLTableModelLinesSourceOffline.this.getModel().getUpdateQ().updateLine(l, path, vals.getID(), vals);
                SQLTableModelLinesSourceOffline.this.recordOriginal(l);
            }
        });
    }

    public Future<?> replaceRow(Number id, SQLRowValues vals) {
        this.checkCanModif(Path.get(vals.getTable()));
        final SQLRowValues copy = vals.deepCopy();
        return this.updateRow(id, new IClosure<SQLRowValues>(){

            @Override
            public void executeChecked(SQLRowValues newVals) {
                Set<String> contentFields = newVals.getTable().getFieldsNames(SQLTable.VirtualFields.CONTENT);
                newVals.clearReferents().removeAll(contentFields);
                newVals.load(copy, contentFields);
                if (copy.hasReferents()) {
                    for (Map.Entry e : new SetMap(copy.getReferentsMap()).entrySet()) {
                        for (SQLRowValues ref : (Set)e.getValue()) {
                            ref.put(((SQLField)e.getKey()).getName(), (Object)newVals);
                        }
                    }
                }
                if (!$assertionsDisabled && copy.getGraphSize() != 1) {
                    throw new AssertionError();
                }
            }
        }, false);
    }

    public Future<?> updateRow(Number id, SQLRowValues vals) {
        this.checkCanModif(Path.get(vals.getTable()));
        if (vals.getGraphSize() > 1) {
            throw new IllegalArgumentException("This method doesn't merge graphs");
        }
        final SQLRowValues copy = vals.deepCopy();
        return this.updateRow(id, new IClosure<SQLRowValues>(){

            @Override
            public void executeChecked(SQLRowValues newVals) {
                Set<String> contentFields = newVals.getTable().getFieldsNames(SQLTable.VirtualFields.CONTENT);
                newVals.load(copy, contentFields);
            }
        }, false);
    }

    public Future<SQLRowValues> updateRow(Number id, IClosure<SQLRowValues> valsClosure) {
        return this.updateRow(id, valsClosure, true);
    }

    private Future<SQLRowValues> updateRow(final Number id, final IClosure<SQLRowValues> valsClosure, final boolean mdCanChange) {
        return this.execInUpdateQ(new OfflineCallable<SQLRowValues>(){

            @Override
            public SQLRowValues call() throws Exception {
                return SQLTableModelLinesSourceOffline.this._updateRow(SQLTableModelLinesSourceOffline.this.getRow(id.intValue(), true), valsClosure, mdCanChange).vals;
            }
        });
    }

    public final SQLRowValues updateRowNow(Row r, IClosure<SQLRowValues> valsClosure) {
        this.checkUpdateThread();
        return this._updateRow(r, valsClosure, true).vals;
    }

    protected Row _updateRow(Row r, IClosure<SQLRowValues> valsClosure, boolean mdCanChange) {
        assert (this.isUpdateThread());
        SQLRowValues newVals = r.getRow().deepCopy();
        valsClosure.executeChecked(newVals);
        if (mdCanChange) {
            Set<String> notContent = newVals.getTable().getFieldsNames(SQLTable.VirtualFields.CONTENT.complement());
            newVals.removeAll(notContent);
            newVals.putAll(r.getRow().getValues(notContent, false));
        }
        assert (CompareUtils.equals(r.getRow().getIDNumber(), newVals.getIDNumber()));
        newVals.grow(this.getUpdateQueueReq().getGraphToFetch(), false);
        newVals.getGraph().freeze();
        this.setRow(r, newVals);
        this.getModel().getUpdateQ().replaceLine(r.getID(), this.createLine(r));
        return r;
    }

    private void checkCanModif(Path path) {
        if (this.modifiableVals.followPath(path) == null) {
            throw new IllegalArgumentException("can only modify " + this.modifiableVals);
        }
    }

    private void recordOriginal(ListSQLLine l) {
        this.setRow(this.getRow(l.getID(), true), l.getRow());
    }

    private void setRow(Row r, SQLRowValues newVals) {
        if (r.getRow().hasID() && !this.dbVals.containsKey(r)) {
            this.dbVals.put(r, r.getRow());
        }
        r.setRow(newVals);
    }

    public final <T> Future<T> useRow(final Number id, final ITransformerExn<SQLRowValues, T, ?> valsTransf) {
        return this.execInUpdateQ(new OfflineCallable<T>(){

            @Override
            public T call() throws Exception {
                SQLRowValues vals = SQLTableModelLinesSourceOffline.this.getRow(id.intValue(), true).vals;
                if (!$assertionsDisabled && !vals.isFrozen()) {
                    throw new AssertionError();
                }
                return valsTransf.transformChecked(vals);
            }
        });
    }

    public final <T> Future<T> useRows(final ITransformerExn<SQLTableModelLinesSourceOffline, T, ?> rowsTransf) {
        return this.execInUpdateQ(new OfflineCallable<T>(){

            @Override
            public T call() throws Exception {
                return rowsTransf.transformChecked(SQLTableModelLinesSourceOffline.this);
            }
        });
    }

    @Override
    public Future<?> moveBy(List<? extends SQLRowAccessor> list, final int inc) {
        if (inc == 0 || list.size() == 0) {
            return null;
        }
        final CopyOnWriteArrayList<? extends SQLRowAccessor> copy = new CopyOnWriteArrayList<SQLRowAccessor>(list);
        return this.execInUpdateQ(new OfflineRunnable(){

            @Override
            public void run() {
                SQLTableModelLinesSourceOffline.this._moveBy(copy, inc);
            }
        });
    }

    protected void _moveBy(List<? extends SQLRowAccessor> list, int inc) {
        assert (this.isUpdateThread());
        int count = this.lines.size();
        boolean after = inc > 0;
        int outerIndex = -1;
        ArrayList<Row> ourLines = new ArrayList<Row>(list.size());
        for (SQLRowAccessor sQLRowAccessor : list) {
            Row ourLine = this.getRow(sQLRowAccessor.getID(), true, sQLRowAccessor);
            int index = this.indexOf(ourLine);
            ourLines.add(ourLine);
            if (outerIndex >= 0 && (!after || index <= outerIndex) && (after || index >= outerIndex)) continue;
            outerIndex = index;
        }
        assert (outerIndex >= 0 && ourLines.size() == list.size());
        this.lines.removeAll(ourLines);
        assert (this.lines.size() == count - ourLines.size());
        int n = after ? outerIndex + inc - list.size() + 1 : outerIndex + inc;
        this.lines.addAll(n, ourLines);
        assert (this.lines.size() == count) : "Move has changed the number of rows from " + count + " to " + this.lines.size();
        this.setDBOrder(false);
        List<Integer> order = this.getIDsOrder();
        this.getModel().getUpdateQ().reorder(order);
    }

    private List<Integer> getIDsOrder() {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (Row r : this.lines) {
            ids.add(r.getID());
        }
        return ids;
    }

    @Override
    public Future<?> moveTo(final List<? extends Number> ids, final int index) {
        return this.execInUpdateQ(new OfflineRunnable(){

            @Override
            public void run() {
                SQLTableModelLinesSourceOffline.this._moveTo(ids, index);
            }
        });
    }

    protected void _moveTo(List<?> ids, int index) {
        assert (this.isUpdateThread());
        int count = this.lines.size();
        ArrayList<Row> list = new ArrayList<Row>(ids.size());
        for (Object o : ids) {
            Integer id = o instanceof SQLRowAccessor ? ((SQLRowAccessor)o).getID() : ((Number)o).intValue();
            list.add(this.getRow(id, true, o));
        }
        if (index <= 0) {
            this.lines.removeAll(list);
            this.lines.addAll(0, list);
        } else if (index >= this.lines.size()) {
            this.lines.removeAll(list);
            this.lines.addAll(list);
        } else {
            Row destLine = null;
            int i = index;
            boolean contains = true;
            while (i < this.lines.size() && contains) {
                destLine = this.lines.get(i);
                contains = list.contains(destLine);
                if (!contains) continue;
                ++i;
            }
            if (contains) {
                this.lines.removeAll(list);
                this.lines.addAll(list);
            } else {
                this.lines.removeAll(list);
                int newIndex = this.indexOf(destLine);
                this.lines.addAll(newIndex, list);
            }
        }
        assert (this.lines.size() == count) : "Move has changed the number of rows from " + count + " to " + this.lines.size();
        this.setDBOrder(false);
        List<Integer> order = this.getIDsOrder();
        this.getModel().getUpdateQ().reorder(order);
    }

    public final Future<Boolean> hasModifications() {
        return this.execInUpdateQ(new OfflineCallable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return SQLTableModelLinesSourceOffline.this.hasModificationsNow();
            }
        });
    }

    public final boolean hasModificationsNow() {
        this.checkUpdateThread();
        return !this.dbVals.isEmpty() || !this.deleted.isEmpty() || !this.dbOrder;
    }

    public final Future<?> reset() {
        return this.execInUpdateQ(new OfflineRunnable(){

            @Override
            public void run() {
                SQLTableModelLinesSourceOffline.this._reset();
            }
        });
    }

    protected void _reset() {
        assert (this.isUpdateThread());
        this.lines.clear();
        this.id2line.clear();
        this.dbVals.clear();
        this.deleted.clear();
        this.setDBOrder(true);
        for (SQLRowValues r : this.fetch()) {
            this._add(r, false, false);
        }
        this.getModel().getUpdateQ().setFullList(this.getLines(), null);
    }

    public final Future<?> commit() {
        return this.execInUpdateQ(new OfflineCallable<Object>(){

            @Override
            public Object call() throws Exception {
                SQLTableModelLinesSourceOffline.this._commit();
                return null;
            }
        });
    }

    public final void commitNow() throws SQLException {
        this.checkUpdateThread();
        this._commit();
    }

    protected final void _commit() throws SQLException {
        assert (this.isUpdateThread());
        this.getModel().getUpdateQ().rmTableListener();
        try {
            SQLUtils.executeAtomic(this.getParent().getPrimaryTable().getDBSystemRoot().getDataSource(), new ConnectionHandlerNoSetup<Object, SQLException>(){

                @Override
                public Object handle(SQLDataSource ds) throws SQLException {
                    SQLTableModelLinesSourceOffline.this.coreCommit();
                    return null;
                }
            });
        }
        finally {
            this.getModel().getUpdateQ().addTableListener();
        }
        this._reset();
    }

    protected void coreCommit() throws SQLException {
        this.getParent().getElem().archiveIDs(this.deleted);
        this.deleted.clear();
        LinkedHashMap<Row, SQLRow> newRows = new LinkedHashMap<Row, SQLRow>();
        for (Row row : this.lines) {
            SQLRow newRow = !row.getRow().hasID() ? row.getRow().prune(this.modifiableVals).commit() : row.getRow().asRow();
            newRows.put(row, newRow);
        }
        for (Map.Entry entry : this.dbVals.entrySet()) {
            Row l = (Row)entry.getKey();
            assert (newRows.containsKey(l));
            newRows.put(l, this.getParent().getElem().update((SQLRowValues)entry.getValue(), l.getRow()).exec());
        }
        this.dbVals.clear();
        if (this.getParent().getPrimaryTable().isOrdered()) {
            ArrayList arrayList = new ArrayList(newRows.values());
            ArrayList dbOrder = new ArrayList(newRows.values());
            Collections.sort(dbOrder, OrderComparator.INSTANCE);
            if (!arrayList.equals(dbOrder)) {
                MoveQueue.moveAtOnce(arrayList.subList(1, arrayList.size()), true, (SQLRow)arrayList.get(0));
            }
        }
    }

    private static abstract class OfflineCallable<V>
    implements Callable<V> {
        private OfflineCallable() {
        }
    }

    private static abstract class OfflineRunnable
    extends OfflineCallable<Object>
    implements Runnable {
        private OfflineRunnable() {
        }

        @Override
        public final Object call() throws Exception {
            this.run();
            return null;
        }
    }

    @NotThreadSafe
    public static final class Row {
        private final Integer id;
        private SQLRowValues vals;

        private Row(Integer id, SQLRowValues vals) {
            this.id = id;
            this.setRow(vals);
        }

        public final Integer getID() {
            return this.id;
        }

        public final SQLRowValues getRow() {
            return this.vals;
        }

        final void setRow(SQLRowValues newVals) {
            if (!newVals.isFrozen()) {
                throw new IllegalArgumentException("Not frozen : " + newVals);
            }
            this.vals = newVals;
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + " of " + this.getID();
        }
    }
}

