/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view.list;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.Constraint;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLInsert;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesCluster;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLSyntax;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.SQLUpdate;
import org.openconcerto.sql.model.UndefinedRowValuesCache;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.utils.AlterTable;
import org.openconcerto.sql.view.list.SQLTableElement;
import org.openconcerto.utils.CompareUtils;
import org.openconcerto.utils.ListMap;
import org.openconcerto.utils.OrderedSet;

public class RowValuesTableModel
extends AbstractTableModel {
    private List<SQLRowValues> rowValues = new ArrayList<SQLRowValues>();
    private final boolean debug = false;
    private OrderedSet<TableModelListener> tableModelListeners = new OrderedSet();
    protected SQLElement element;
    private int nbColumn;
    private List<SQLTableElement> list;
    private Map<String, Integer> mapColumnField = new HashMap<String, Integer>();
    private List<SQLField> requiredFields;
    private SQLField requiredField;
    private SQLField validationField;
    private SQLRowValues defautRow;
    private List<SQLRowValues> rowValuesDeleted = new ArrayList<SQLRowValues>();
    private boolean editable = true;
    private Where fillWhere;
    private boolean gestionReferentActive = false;

    public RowValuesTableModel() {
    }

    public RowValuesTableModel(SQLElement e, List<SQLTableElement> list, SQLField validField) {
        this(e, list, validField, true);
    }

    public RowValuesTableModel(SQLElement e, List<SQLTableElement> list, SQLField validField, boolean addDefault, SQLRowValues rowParDefaut) {
        this(e, list, validField, addDefault, rowParDefaut, null);
    }

    public RowValuesTableModel(SQLElement e, List<SQLTableElement> list, SQLField validField, boolean addDefault, SQLRowValues rowParDefaut, SQLField validationField) {
        this.init(e, list, validField, addDefault, rowParDefaut, validationField);
    }

    public RowValuesTableModel(SQLElement e, List<SQLTableElement> list, SQLField validField, boolean addDefault) {
        this(e, list, validField, addDefault, null);
    }

    protected void init(SQLElement e, List<SQLTableElement> list, SQLField validField, boolean addDefault, SQLRowValues rowParDefaut) {
        this.init(e, list, validField, addDefault, rowParDefaut, null);
    }

    protected void init(SQLElement e, List<SQLTableElement> list, SQLField validField, boolean addDefault, SQLRowValues rowParDefaut, SQLField validationField) {
        this.element = e;
        this.requiredField = validField;
        this.requiredFields = new ArrayList<SQLField>();
        this.requiredFields.add(validField);
        this.validationField = validationField;
        this.list = list;
        this.nbColumn = list.size();
        this.defautRow = rowParDefaut != null ? rowParDefaut : new SQLRowValues(UndefinedRowValuesCache.getInstance().getDefaultRowValues(e.getTable()));
        if (addDefault) {
            SQLRowValues row = new SQLRowValues(this.defautRow);
            BigDecimal maxOrder = this.element.getTable().getMaxOrder();
            row.put(this.element.getTable().getOrderField().getName(), maxOrder.add(BigDecimal.ONE));
            this.rowValues.add(row);
        }
    }

    public void setFillWhere(Where fillWhere) {
        this.fillWhere = fillWhere;
    }

    public void addRequiredField(SQLField f) {
        this.requiredFields.add(f);
    }

    public SQLField getValidationField() {
        return this.validationField;
    }

    public SQLRowValues getDefaultRowValues() {
        return this.defautRow;
    }

    public void setGestionReferentActive(boolean gestionReferent) {
        this.gestionReferentActive = gestionReferent;
    }

    public synchronized void addColumn(SQLTableElement e) {
        ++this.nbColumn;
        this.list.add(e);
    }

    public void setValidationField(SQLField validationField) {
        this.validationField = validationField;
    }

    @Override
    public synchronized int getColumnCount() {
        return this.nbColumn;
    }

    @Override
    public int getRowCount() {
        this.checkEDT();
        return this.rowValues.size();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (!this.editable) {
            return false;
        }
        SQLTableElement elt = this.list.get(columnIndex);
        boolean validate = false;
        boolean fieldValidate = false;
        if (this.validationField != null && this.validationField.getTable().getName().equals(this.getSQLElement().getTable().getName())) {
            fieldValidate = elt.getField().getName().equalsIgnoreCase(this.validationField.getName());
            validate = this.getRowValuesAt(rowIndex).getBoolean(this.validationField.getName());
        }
        if (validate && fieldValidate) {
            return this.list.get(columnIndex).isCellEditable(this.getRowValuesAt(rowIndex), rowIndex, columnIndex);
        }
        return !validate && this.list.get(columnIndex).isCellEditable(this.getRowValuesAt(rowIndex), rowIndex, columnIndex);
    }

    @Override
    public synchronized Class<?> getColumnClass(int columnIndex) {
        return this.list.get(columnIndex).getElementClass();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object result;
        this.checkEDT();
        if (rowIndex >= this.rowValues.size()) {
            System.err.println("RowValuesTableModel: get(" + rowIndex + "," + columnIndex + ") rowIndex>" + this.rowValues.size());
            Thread.dumpStack();
            result = new Integer(0);
        } else {
            SQLRowValues val = this.rowValues.get(rowIndex);
            SQLTableElement sqlTableElem = this.list.get(columnIndex);
            Object storedObject = val.getObject(sqlTableElem.getRowField());
            result = sqlTableElem.getValueFrom(val);
            Object resultToCheck = sqlTableElem.getElementClass() != null && Number.class.isAssignableFrom(sqlTableElem.getElementClass()) && result != null && SQLRowAccessor.class.isAssignableFrom(result.getClass()) && storedObject != null && Number.class.isAssignableFrom(storedObject.getClass()) ? ((SQLRowAccessor)result).getIDNumber() : result;
            if (sqlTableElem.getElementClass() != null && Number.class.isAssignableFrom(sqlTableElem.getElementClass()) && !CompareUtils.equals(resultToCheck, storedObject)) {
                this.fireTableDataChanged();
            }
        }
        return result;
    }

    private void checkEDT() {
        if (!SwingUtilities.isEventDispatchThread()) {
            Thread.dumpStack();
        }
    }

    public void putValue(Object value, int rowIndex, String fieldName) {
        this.putValue(value, rowIndex, fieldName, false);
    }

    public void putValue(Object value, int rowIndex, String fieldName, boolean forcedFire) {
        this.checkEDT();
        SQLRowValues rowVal = this.rowValues.get(rowIndex);
        Object oldValue = rowVal.getObject(fieldName);
        if (!forcedFire) {
            if (oldValue == value) {
                return;
            }
            if (oldValue != null && oldValue.equals(value)) {
                return;
            }
        }
        rowVal.put(fieldName, value);
        for (SQLTableElement sqlTableElem : this.list) {
            if (!sqlTableElem.getField().getName().equals(fieldName)) continue;
            sqlTableElem.fireModification(rowVal);
        }
        this.fireTableModelModified(rowIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.checkEDT();
        if (!this.editable) {
            return;
        }
        if (this.list.size() <= columnIndex) {
            return;
        }
        Object oldValue = this.getValueAt(rowIndex, columnIndex);
        if (aValue == oldValue) {
            return;
        }
        if (oldValue != null && oldValue.equals(aValue)) {
            return;
        }
        try {
            SQLTableElement sqlTableElem = this.list.get(columnIndex);
            SQLRowValues rowVal = this.rowValues.get(rowIndex);
            Object realVal = sqlTableElem.convertEditorValueToModel(aValue, rowVal);
            if (realVal == null || realVal.getClass() == this.getColumnClass(columnIndex)) {
                sqlTableElem.setValueFrom(rowVal, realVal);
                this.fireTableChanged(new TableModelEvent(this, rowIndex, rowIndex, columnIndex));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void dumpValues() {
        int i = 0;
        while (i < this.rowValues.size()) {
            SQLRowValues val = this.rowValues.get(i);
            System.out.println("Item" + i + ":" + val);
            ++i;
        }
    }

    @Override
    public String getColumnName(int columnIndex) {
        SQLTableElement sqlTableElem = this.list.get(columnIndex);
        return sqlTableElem.getColumnName();
    }

    public void commitData() throws SQLException {
        this.commitData(false);
    }

    public void commitData(boolean useMultipleInsertUpdate) throws SQLException {
        this.checkEDT();
        ArrayList<SQLRowValues> rowsToCommmit = new ArrayList<SQLRowValues>();
        rowsToCommmit.addAll(this.rowValues);
        SQLTable table = this.getDefaultRowValues().getTable();
        Constraint constraint = table.getConstraint(SQLSyntax.ConstraintType.UNIQUE, Arrays.asList(table.getOrderField().getName()));
        if (constraint != null) {
            String req = new AlterTable(table).dropConstraint(constraint.getName()).asString();
            table.getDBSystemRoot().getDataSource().execute(req);
            table.fetchFields();
            table.getSchema().updateVersion();
        }
        BigDecimal o = table.getMaxOrder(Boolean.FALSE);
        int size = rowsToCommmit.size();
        if (useMultipleInsertUpdate) {
            ArrayList<SQLUpdate> updates = new ArrayList<SQLUpdate>();
            ListMap<List<SQLField>, SQLInsert> mapInsertByFields = new ListMap<List<SQLField>, SQLInsert>();
            ListMap<List<SQLField>, Object> mapInsertRowValues = new ListMap<List<SQLField>, Object>();
            int i = 0;
            while (i < size) {
                SQLRowValues r = (SQLRowValues)rowsToCommmit.get(i);
                r.put(r.getTable().getOrderField().getFieldName(), o.add(new BigDecimal(i + 1)));
                if (r.hasID()) {
                    SQLUpdate up = new SQLUpdate(new Where((FieldRef)table.getKey(), "=", r.getID()));
                    up.importValuesFrom(r);
                    updates.add(up);
                } else {
                    SQLInsert insert = new SQLInsert();
                    insert.importValuesFrom(r);
                    List<SQLField> fields = insert.getFields();
                    mapInsertByFields.add(fields, insert);
                    mapInsertRowValues.add(fields, r);
                }
                ++i;
            }
            if (!mapInsertByFields.isEmpty()) {
                for (List fieldSize : mapInsertByFields.keySet()) {
                    List<Number> ids = SQLInsert.executeSimilarInserts(table.getDBSystemRoot(), (List)mapInsertByFields.get(fieldSize), true);
                    List insertsRowValues = (List)mapInsertRowValues.get(fieldSize);
                    if (ids.size() != insertsRowValues.size()) continue;
                    int i2 = 0;
                    while (i2 < ids.size()) {
                        SQLRowValues r = (SQLRowValues)insertsRowValues.get(i2);
                        r.setID(ids.get(i2));
                        ++i2;
                    }
                }
            }
            if (!updates.isEmpty()) {
                SQLUpdate.executeMultipleWithBatch(table.getDBSystemRoot(), updates);
            }
            if (this.gestionReferentActive) {
                ArrayList<SQLInsert> insertsRefs = new ArrayList<SQLInsert>();
                ArrayList<SQLUpdate> updatesRefs = new ArrayList<SQLUpdate>();
                for (SQLRowValues rowVals : rowsToCommmit) {
                    Collection<SQLRowValues> referentRows = rowVals.getReferentRows();
                    System.err.println(String.valueOf(referentRows.size()) + " ref Rows pour RowValues " + rowVals);
                    for (SQLRowValues refRow : referentRows) {
                        System.err.println("\t" + refRow);
                        if (refRow.hasID()) {
                            SQLUpdate update = new SQLUpdate(new Where((FieldRef)refRow.getTable().getKey(), "=", refRow.getID()));
                            update.importValuesFrom(refRow);
                            updatesRefs.add(update);
                            continue;
                        }
                        SQLInsert insert = new SQLInsert();
                        insert.importValuesFrom(refRow);
                        System.err.println("\t\t" + insert.asString());
                        insertsRefs.add(insert);
                    }
                }
                if (!insertsRefs.isEmpty()) {
                    SQLInsert.executeMultiple(table.getDBSystemRoot(), insertsRefs);
                }
                if (!updatesRefs.isEmpty()) {
                    SQLUpdate.executeMultipleWithBatch(table.getDBSystemRoot(), updatesRefs);
                }
            }
            table.fireTableModified(-1);
        } else {
            int i = 0;
            while (i < size) {
                SQLRowValues r = (SQLRowValues)rowsToCommmit.get(i);
                r.put(r.getTable().getOrderField().getFieldName(), o.add(new BigDecimal(i + 1)));
                SQLRowValuesCluster.StoreResult store = r.getGraph().store(SQLRowValuesCluster.StoreMode.COMMIT, false);
                SQLRow row = store.getStoredRow(r);
                r.setID(row.getIDNumber());
                ++i;
            }
        }
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.tableModelListeners.add(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.tableModelListeners.remove(l);
    }

    public void fireTableModelModified(int line) {
        this.checkEDT();
        this.fireTableRowsUpdated(line, line);
    }

    public int getColumnForField(String to) {
        if (this.mapColumnField.get(to) == null) {
            int columnIndex = 0;
            while (columnIndex < this.list.size()) {
                SQLTableElement sqlTableElem = this.list.get(columnIndex);
                if (sqlTableElem.getField() != null && sqlTableElem.getField().getName().equalsIgnoreCase(to)) {
                    this.mapColumnField.put(to, columnIndex);
                    return columnIndex;
                }
                ++columnIndex;
            }
            this.mapColumnField.put(to, -1);
            return -1;
        }
        return this.mapColumnField.get(to);
    }

    public void addNewRowAt(int index) {
        this.checkEDT();
        if (index > this.getRowCount()) {
            throw new IllegalArgumentException(String.valueOf(index) + " > row count: " + this.getRowCount());
        }
        if (index < 0) {
            throw new IllegalArgumentException(String.valueOf(index) + " <0");
        }
        SQLRowValues newRowParDefaut = new SQLRowValues(this.defautRow);
        if (index > 0 && index < this.getRowCount() && newRowParDefaut.getTable().contains("NIVEAU")) {
            newRowParDefaut.put("NIVEAU", this.rowValues.get(index - 1).getObject("NIVEAU"));
        }
        this.rowValues.add(index, newRowParDefaut);
        int size = this.tableModelListeners.size();
        int i = 0;
        while (i < size) {
            TableModelListener l = (TableModelListener)this.tableModelListeners.get(i);
            l.tableChanged(new TableModelEvent(this, index, index, -1, 1));
            ++i;
        }
    }

    public void addRowAt(int index, SQLRowValues rowVals) {
        this.checkEDT();
        if (index > this.getRowCount()) {
            throw new IllegalArgumentException(String.valueOf(index) + " > row count: " + this.getRowCount());
        }
        if (index < 0) {
            throw new IllegalArgumentException(String.valueOf(index) + " <0");
        }
        this.rowValues.add(index, rowVals);
        int size = this.tableModelListeners.size();
        int i = 0;
        while (i < size) {
            TableModelListener l = (TableModelListener)this.tableModelListeners.get(i);
            l.tableChanged(new TableModelEvent(this, index, index, -1, 1));
            ++i;
        }
    }

    public void removeRowAt(int index) {
        this.checkEDT();
        if (index < 0) {
            return;
        }
        SQLRowValues removedLine = this.rowValues.remove(index);
        this.rowValuesDeleted.add(removedLine);
        this.fireTableRowsDeleted(index, index);
    }

    public void removeRowsAt(int[] index) {
        this.checkEDT();
        if (index.length <= 0) {
            return;
        }
        ArrayList<SQLRowValues> rowVals = new ArrayList<SQLRowValues>(index.length);
        int[] nArray = index;
        int n = index.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            SQLRowValues rowValues2 = this.rowValues.get(i);
            rowVals.add(rowValues2);
            this.rowValuesDeleted.add(rowValues2);
            ++n2;
        }
        block1: for (SQLRowValues sqlRowValues2Remove : rowVals) {
            int i = 0;
            while (i < this.getRowCount()) {
                SQLRowValues rowValsList = this.rowValues.get(i);
                if (rowValsList == sqlRowValues2Remove) {
                    this.rowValues.remove(i);
                    continue block1;
                }
                ++i;
            }
        }
        this.fireTableDataChanged();
    }

    public void addNewRow() {
        this.addNewRowAt(this.getRowCount());
    }

    public boolean isLastRowValid() {
        return this.isRowValid(this.rowValues.size() - 1);
    }

    public boolean isRowValid(int index) {
        this.checkEDT();
        if (this.rowValues.size() == 0) {
            return true;
        }
        if (index < 0 || index >= this.rowValues.size()) {
            return false;
        }
        SQLRowValues row = this.rowValues.get(index);
        boolean valid = true;
        for (SQLField f : this.requiredFields) {
            Object object;
            valid = f.isKey() ? (valid &= !row.isForeignEmpty(f.getName())) : (valid &= (object = row.getObject(f.getName())) != null && object.toString().trim().length() > 0);
            if (!valid) break;
        }
        return valid;
    }

    public boolean isValidated() {
        boolean b = true;
        int i = 0;
        while (i < this.getRowCount()) {
            b &= this.isRowValid(i);
            ++i;
        }
        return b;
    }

    public final List<SQLTableElement> getList() {
        return this.list;
    }

    public void updateField(String field, SQLRowValues rowVals, String fieldCondition) throws SQLException {
        this.checkEDT();
        if (rowVals != null) {
            int stop = this.rowValues.size();
            int id = rowVals.getID();
            int i = 0;
            while (i < stop) {
                SQLRowValues r = this.rowValues.get(i);
                if (fieldCondition != null) {
                    Object o = r.getObject(fieldCondition);
                    if (o != null && ((Boolean)o).booleanValue()) {
                        if (id != -1) {
                            r.put(field, id);
                        } else {
                            r.put(field, (Object)rowVals);
                        }
                    } else {
                        r.put(field, 1);
                    }
                } else if (id != -1) {
                    r.put(field, id);
                } else {
                    r.put(field, (Object)rowVals);
                }
                ++i;
            }
            ArrayList<SQLRowValues> l = new ArrayList<SQLRowValues>(this.rowValuesDeleted);
            HashSet<SQLRowValues> toArchive = new HashSet<SQLRowValues>();
            int i2 = 0;
            while (i2 < l.size()) {
                SQLRowValues rowVals2 = (SQLRowValues)l.get(i2);
                int idRow = rowVals2.getID();
                if (idRow != -1) {
                    toArchive.add(rowVals2);
                } else {
                    rowVals2.putEmptyLink(field);
                }
                ++i2;
            }
            this.rowValuesDeleted.clear();
            this.element.archive(toArchive);
            if (id != -1) {
                this.commitData();
            }
        }
    }

    public void updateField(String field, SQLRowValues rowVals) throws SQLException {
        this.updateField(field, rowVals, null);
    }

    public void updateField(String field, int id) throws SQLException {
        this.updateField(field, id, null);
    }

    public void updateField(String field, int id, String fieldCondition) throws SQLException {
        if (id > 0) {
            this.updateField(field, this.element.getTable().getForeignTable(field).getRow(id).createUpdateRow(), fieldCondition);
        }
    }

    public void insertFrom(String field, int id) {
        this.insertFrom(field, id, -1);
    }

    public void insertFrom(String field, int id, int exceptID) {
        this.checkEDT();
        if (id > 0) {
            SQLSelect sel = new SQLSelect();
            SQLTable table = this.element.getTable();
            sel.addSelectStar(table);
            Where w = new Where((FieldRef)table.getField(field), "=", id);
            w = w.and(new Where((FieldRef)table.getKey(), "!=", exceptID));
            if (this.fillWhere != null) {
                w = w.and(this.fillWhere);
            }
            sel.setWhere(w);
            sel.addFieldOrder(table.getOrderField());
            List<SQLRow> listOfRows = SQLRowListRSH.execute(sel);
            this.rowValues.clear();
            int size = listOfRows.size();
            int i = 0;
            while (i < size) {
                SQLRow sqlRow = listOfRows.get(i);
                SQLRowValues row = sqlRow.createUpdateRow();
                this.rowValues.add(row);
                ++i;
            }
            this.fireTableModelModified(this.rowValues.size());
        }
    }

    public void insertFrom(SQLRowAccessor rowVals) {
        this.insertFrom(rowVals, null);
    }

    public void insertFrom(SQLRowAccessor rowVals, SQLField referentField) {
        this.insertFrom(rowVals, referentField, null, null);
    }

    public void insertFrom(SQLRowAccessor rowVals, SQLField referentField, SQLField fieldWhere, Object value) {
        if (!SwingUtilities.isEventDispatchThread()) {
            Thread.dumpStack();
        }
        if (rowVals != null) {
            ArrayList<SQLRowValues> newRows = new ArrayList<SQLRowValues>();
            SQLTable table = this.element.getTable();
            if (rowVals.hasID() && !rowVals.isUndefined() && rowVals.getID() != -1) {
                newRows.addAll(this.fetchDataFromDB(rowVals, referentField, fieldWhere, value));
            } else {
                Collection<? extends SQLRowAccessor> colRows = referentField == null ? rowVals.getReferentRows(table) : rowVals.getReferentRows(referentField);
                for (SQLRowAccessor sQLRowAccessor : colRows) {
                    if (fieldWhere != null && !CompareUtils.equals(sQLRowAccessor.getObject(fieldWhere.getName()), value)) continue;
                    newRows.add(sQLRowAccessor.asRowValues());
                }
            }
            this.rowValues.clear();
            this.rowValues.addAll(newRows);
            this.fireTableModelModified(this.rowValues.size());
        }
    }

    public List<SQLRowValues> fetchDataFromDB(SQLRowAccessor rowVals, SQLField referentField, SQLField fieldWhere, Object value) {
        ArrayList<SQLRowValues> newRows = new ArrayList<SQLRowValues>();
        SQLTable table = this.getSQLElement().getTable();
        SQLRow row = rowVals.getTable().getRow(rowVals.getID());
        Collection rowSet = referentField == null ? row.getReferentRows(table) : row.getReferentRows(referentField);
        for (SQLRow row2 : rowSet) {
            if (fieldWhere != null && !CompareUtils.equals(row2.getObject(fieldWhere.getName()), value)) continue;
            SQLRowValues rowVals2 = new SQLRowValues(table);
            rowVals2.loadAbsolutelyAll(row2);
            newRows.add(rowVals2);
        }
        return newRows;
    }

    public void addRow(SQLRowValues row) {
        this.checkEDT();
        this.addRow(row, true);
    }

    public void addRow(SQLRowValues row, boolean fireModified) {
        this.checkEDT();
        ArrayList<SQLRowValues> rows = new ArrayList<SQLRowValues>(1);
        rows.add(row);
        this.addRows(rows, fireModified);
    }

    public void submit(Runnable r) {
        this.checkEDT();
        r.run();
    }

    public void addRows(List<SQLRowValues> rows, boolean fireModified) {
        this.checkEDT();
        if (rows.isEmpty()) {
            return;
        }
        this.addRowsSync(rows, fireModified);
    }

    public void clearRows() {
        this.checkEDT();
        int size = this.rowValues.size();
        if (size > 0) {
            this.rowValues.clear();
            this.fireTableRowsDeleted(0, size - 1);
        }
    }

    public synchronized SQLTableElement getSQLTableElementAt(int columnIndex) {
        this.checkEDT();
        if (columnIndex >= 0 && columnIndex < this.list.size()) {
            return this.list.get(columnIndex);
        }
        return null;
    }

    public synchronized int getColumnIndexForElement(SQLTableElement e) {
        this.checkEDT();
        int columnIndex = 0;
        while (columnIndex < this.list.size()) {
            SQLTableElement sqlTableElem = this.list.get(columnIndex);
            if (sqlTableElem.equals(e)) {
                return columnIndex;
            }
            ++columnIndex;
        }
        return -1;
    }

    public SQLRowValues getRowValuesAt(int rowIndex) {
        this.checkEDT();
        return this.rowValues.get(rowIndex);
    }

    public final int id2index(int id) {
        this.checkEDT();
        int i = 0;
        while (i < this.getRowCount()) {
            if (this.getRowValuesAt(i).getID() == id) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public final int row2index(SQLRowAccessor row) {
        this.checkEDT();
        return this.rowValues.indexOf(row);
    }

    @Override
    public void fireTableChanged(TableModelEvent event) {
        this.checkEDT();
        int i = 0;
        while (i < this.tableModelListeners.size()) {
            TableModelListener l = (TableModelListener)this.tableModelListeners.get(i);
            l.tableChanged(event);
            ++i;
        }
    }

    @Override
    public void fireTableDataChanged() {
        this.fireTableChanged(new TableModelEvent(this));
    }

    @Override
    public void fireTableStructureChanged() {
        this.fireTableChanged(new TableModelEvent(this, -1));
    }

    @Override
    public void fireTableRowsInserted(int firstRow, int lastRow) {
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, -1, 1));
    }

    @Override
    public void fireTableRowsUpdated(int firstRow, int lastRow) {
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, -1, 0));
    }

    @Override
    public void fireTableRowsDeleted(int firstRow, int lastRow) {
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, -1, -1));
    }

    @Override
    public void fireTableCellUpdated(int row, int column) {
        this.fireTableChanged(new TableModelEvent(this, row, row, column));
    }

    public int moveBy(int rowIndex, int inc) {
        this.checkEDT();
        int destIndex = rowIndex + inc;
        if (rowIndex >= 0 && destIndex >= 0 && rowIndex < this.rowValues.size() && destIndex < this.rowValues.size()) {
            SQLRowValues rowValues1 = this.rowValues.get(rowIndex);
            SQLRowValues rowValues2 = this.rowValues.get(destIndex);
            this.rowValues.set(rowIndex, rowValues2);
            this.rowValues.set(destIndex, rowValues1);
            this.fireTableRowsUpdated(rowIndex, destIndex);
            this.fireTableDataChanged();
        }
        return destIndex;
    }

    public List<SQLRowValues> getCopyOfValues() {
        this.checkEDT();
        ArrayList<SQLRowValues> vals = new ArrayList<SQLRowValues>(this.rowValues.size());
        for (SQLRowValues sqlRowValues : this.rowValues) {
            vals.add(sqlRowValues.asRowValues());
        }
        return vals;
    }

    public void setEditable(boolean b, int column) {
        this.checkEDT();
        this.list.get(column).setEditable(b);
    }

    public void setEditable(boolean b) {
        this.editable = b;
    }

    public SQLElement getSQLElement() {
        return this.element;
    }

    public SQLField getRequiredField() {
        return this.requiredField;
    }

    public List<SQLField> getRequiredsField() {
        return this.requiredFields;
    }

    public void addRowsSync(List<SQLRowValues> rows, boolean fireModified) {
        this.checkEDT();
        if (rows.isEmpty()) {
            return;
        }
        this.rowValues.addAll(rows);
        if (fireModified) {
            for (SQLRowValues row : rows) {
                for (SQLTableElement sqlTableElem : this.list) {
                    sqlTableElem.fireModification(row);
                }
            }
            this.fireTableRowsInserted(this.rowValues.size() - rows.size(), this.rowValues.size() - 1);
        }
    }
}

