/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view.list;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.IListeAction;
import org.openconcerto.sql.view.list.action.ListEvent;
import org.openconcerto.utils.cc.IClosure;
import org.openconcerto.utils.cc.IPredicate;
import org.openconcerto.utils.i18n.TranslationManager;

public abstract class RowAction
implements IListeAction {
    private final Action action;
    private final boolean header;
    private final boolean popupMenu;
    private List<String> path;
    private final String id;

    public static Action createAction(String name, Icon icon, final IClosure<List<? extends SQLRowAccessor>> action) {
        return new AbstractAction(name, icon){

            @Override
            public void actionPerformed(ActionEvent e) {
                action.executeChecked(IListe.get(e).getSelectedRows());
            }
        };
    }

    public RowAction(Action action, boolean header) {
        this(action, header, true);
    }

    public RowAction(Action action, boolean header, boolean popupMenu) {
        this(action, header, popupMenu, null);
    }

    public RowAction(Action action, boolean header, String id) {
        this(action, header, true, id);
    }

    public RowAction(Action action, boolean header, boolean popupMenu, String id) {
        this.action = action;
        this.header = header;
        this.popupMenu = popupMenu;
        this.setGroup(null);
        this.id = id;
        if (id != null && action.getValue("Name") == null) {
            action.putValue("Name", TranslationManager.getInstance().getTranslationForAction(id));
        }
    }

    public final String getID() {
        return this.id;
    }

    public final Action getAction() {
        return this.action;
    }

    public final boolean inHeader() {
        return this.header;
    }

    public final boolean inPopupMenu() {
        return this.popupMenu;
    }

    public final RowAction setGroup(String groupName) {
        this.path = Arrays.asList(groupName);
        return this;
    }

    public final RowAction setPath(List<String> path) {
        this.path = Collections.unmodifiableList(new ArrayList<String>(path));
        return this;
    }

    public final List<String> getPath() {
        return this.path;
    }

    public boolean enabledFor(List<SQLRowValues> selection) {
        throw new UnsupportedOperationException("Should overload this method or enabledFor(IListeEvent) on : " + this);
    }

    public boolean enabledFor(ListEvent evt) {
        return this.enabledFor(evt.getSelectedRows());
    }

    @Override
    public IListeAction.ButtonsBuilder getHeaderButtons() {
        return !this.inHeader() ? IListeAction.ButtonsBuilder.emptyInstance() : new IListeAction.ButtonsBuilder().add(new JButton(this.getAction()), new IPredicate<IListeAction.IListeEvent>(){

            @Override
            public boolean evaluateChecked(IListeAction.IListeEvent evt) {
                return RowAction.this.enabledFor(evt);
            }
        });
    }

    @Override
    public Action getDefaultAction(ListEvent evt) {
        return this.enabledFor(evt) ? this.getAction() : null;
    }

    @Override
    public IListeAction.PopupBuilder getPopupContent(IListeAction.PopupEvent evt) {
        if (this.inPopupMenu() && evt.isClickOnRows()) {
            JMenuItem mi = new JMenuItem(this.getAction());
            mi.setEnabled(this.enabledFor(evt));
            IListeAction.PopupBuilder res = new IListeAction.PopupBuilder();
            res.getMenu().addItem(mi, this.getPath());
            return res;
        }
        return IListeAction.PopupBuilder.emptyInstance();
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + (this.getID() == null ? "" : " ID '" + this.getID()) + "' with action '" + this.getAction().getValue("Name") + "'";
    }

    public static class PredicateRowAction
    extends RowAction {
        private IPredicate<? super ListEvent> pred = null;

        public PredicateRowAction(Action action, boolean header) {
            super(action, header);
        }

        public PredicateRowAction(Action action, boolean header, boolean popupMenu) {
            super(action, header, popupMenu);
        }

        public PredicateRowAction(Action action, boolean header, String id) {
            super(action, header, id);
        }

        public PredicateRowAction(Action action, boolean header, boolean popupMenu, String id) {
            super(action, header, popupMenu, id);
        }

        public final PredicateRowAction setPredicate(IPredicate<? super ListEvent> pred) {
            if (pred == null) {
                throw new IllegalArgumentException("null predicate");
            }
            this.pred = pred;
            return this;
        }

        public final IPredicate<? super IListeAction.IListeEvent> getPredicate() {
            return this.pred;
        }

        @Override
        public boolean enabledFor(ListEvent evt) {
            if (this.pred == null) {
                throw new IllegalStateException("No predicate for " + this);
            }
            return this.pred.evaluateChecked(evt);
        }
    }
}

