/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view.list;

import java.awt.Dimension;
import java.util.Vector;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import org.openconcerto.sql.view.list.RowValuesTable;

public class MaskTableModel
extends AbstractTableModel {
    private Vector<Integer> showColumnList;
    private AbstractTableModel model;
    RowValuesTable table;

    public MaskTableModel(AbstractTableModel model, RowValuesTable table) {
        this.model = model;
        this.table = table;
        this.showColumnList = new Vector(this.model.getColumnCount());
        int i = 0;
        while (i < model.getColumnCount()) {
            this.showColumnList.add(i);
            ++i;
        }
    }

    public Vector<Integer> getShowColumnList() {
        return this.showColumnList;
    }

    @Override
    public int getColumnCount() {
        return this.showColumnList.size();
    }

    @Override
    public int getRowCount() {
        return this.model.getRowCount();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.model.getValueAt(rowIndex, this.showColumnList.get(columnIndex));
    }

    @Override
    public String getColumnName(int column) {
        return this.model.getColumnName(this.showColumnList.get(column));
    }

    public void hideColumn(int index) throws IllegalArgumentException {
        int r = this.getIndexFor(index);
        if (r >= 0) {
            this.showColumnList.remove(r);
            this.fireTableStructureChanged();
            this.model.fireTableStructureChanged();
            this.table.setEditorAndRendererDone(false);
            this.table.createDefaultColumnsFromModel();
            int width = this.table.getSize().width;
            int height = this.table.getTableHeader().getSize().height;
            this.table.getTableHeader().setSize(new Dimension(width, height));
            System.err.println("Table Width = " + this.table.getSize().width + " Header Width = " + this.table.getTableHeader().getSize().width);
            this.table.getTableHeader().invalidate();
            this.table.getTableHeader().resizeAndRepaint();
            this.table.invalidate();
            this.table.resizeAndRepaint();
        }
    }

    public void showColumn(int index) throws IllegalArgumentException {
        if (index >= 0) {
            Vector<Integer> v = new Vector<Integer>();
            int i = 0;
            while (i < this.model.getColumnCount()) {
                if (this.showColumnList.contains(i)) {
                    v.add(i);
                } else if (i == index) {
                    v.add(index);
                }
                ++i;
            }
            this.showColumnList = v;
            this.fireTableStructureChanged();
            this.model.fireTableStructureChanged();
            this.table.createDefaultColumnsFromModel();
            this.table.setEditorAndRendererDone(false);
            int width = this.table.getSize().width;
            int height = this.table.getTableHeader().getSize().height;
            this.table.getTableHeader().setSize(new Dimension(width, height));
            System.err.println("Table Width = " + this.table.getSize().width + " Header Width = " + this.table.getTableHeader().getSize().width);
            this.table.getTableHeader().invalidate();
            this.table.getTableHeader().resizeAndRepaint();
            this.table.invalidate();
            this.table.resizeAndRepaint();
        }
    }

    public int getIndexFor(int index) {
        int i = 0;
        while (i < this.showColumnList.size()) {
            int val = this.showColumnList.get(i);
            if (val == index) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.model.setValueAt(aValue, rowIndex, this.showColumnList.get(columnIndex));
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.model.isCellEditable(rowIndex, this.showColumnList.get(columnIndex));
    }

    @Override
    public synchronized Class<?> getColumnClass(int columnIndex) {
        return this.model.getColumnClass(this.showColumnList.get(columnIndex));
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.model.addTableModelListener(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.model.removeTableModelListener(l);
    }
}

