/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view.list;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeListenerProxy;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.sql.Clob;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.Format;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.function.BiFunction;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DropMode;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import net.jcip.annotations.GuardedBy;
import org.openconcerto.openoffice.XMLFormatVersion;
import org.openconcerto.openoffice.spreadsheet.SpreadSheet;
import org.openconcerto.sql.Log;
import org.openconcerto.sql.TM;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.model.RowRef;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.request.ComboSQLRequest;
import org.openconcerto.sql.request.ListSQLRequest;
import org.openconcerto.sql.request.UpdateBuilder;
import org.openconcerto.sql.users.User;
import org.openconcerto.sql.users.UserManager;
import org.openconcerto.sql.users.rights.TableAllRights;
import org.openconcerto.sql.view.FileTransfertHandler;
import org.openconcerto.sql.view.IListener;
import org.openconcerto.sql.view.RowMetadata;
import org.openconcerto.sql.view.RowMetadataCache;
import org.openconcerto.sql.view.list.IListeAction;
import org.openconcerto.sql.view.list.IListeTransferHandler;
import org.openconcerto.sql.view.list.ITableModel;
import org.openconcerto.sql.view.list.ListSQLLine;
import org.openconcerto.sql.view.list.RowAction;
import org.openconcerto.sql.view.list.SQLTableModelColumn;
import org.openconcerto.sql.view.list.SQLTableModelSource;
import org.openconcerto.sql.view.list.SQLTableModelSourceOnline;
import org.openconcerto.sql.view.list.TableListStateModel;
import org.openconcerto.sql.view.list.VirtualMenu;
import org.openconcerto.sql.view.list.action.ListEvent;
import org.openconcerto.sql.view.list.action.SQLRowValuesAction;
import org.openconcerto.ui.FontUtils;
import org.openconcerto.ui.FormatEditor;
import org.openconcerto.ui.MenuUtils;
import org.openconcerto.ui.PopupMouseListener;
import org.openconcerto.ui.SwingThreadUtils;
import org.openconcerto.ui.WrapLayout;
import org.openconcerto.ui.list.selection.ListSelection;
import org.openconcerto.ui.list.selection.ListSelectionState;
import org.openconcerto.ui.state.JTableStateManager;
import org.openconcerto.ui.table.AlternateTableCellRenderer;
import org.openconcerto.ui.table.ColumnSizeAdjustor;
import org.openconcerto.ui.table.TableColumnModelAdapter;
import org.openconcerto.ui.table.TablePopupMouseListener;
import org.openconcerto.ui.table.ViewTableModel;
import org.openconcerto.ui.table.XTableColumnModel;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.CompareUtils;
import org.openconcerto.utils.FormatGroup;
import org.openconcerto.utils.StringUtils;
import org.openconcerto.utils.TableModelSelectionAdapter;
import org.openconcerto.utils.TableSorter;
import org.openconcerto.utils.TimeUtils;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.cc.IPredicate;
import org.openconcerto.utils.cc.ITransformer;
import org.openconcerto.utils.convertor.StringClobConvertor;
import org.openconcerto.utils.text.BooleanFormat;

public final class IListe
extends JPanel {
    private static LockAction LOCK_ACTION;
    private static LockAction UNLOCK_ACTION;
    private static final int MD_BATCH_SIZE = 100;
    private static final RowMetadataCache MD_CACHE;
    public static final String STATELESS_TABLE_PROP = "org.openconcerto.sql.list.statelessTable";
    private static final String SELECTION_DATA_PROPNAME = "selectionData";
    private static boolean FORCE_ALT_CELL_RENDERER;
    static final String SEP = " \u25ba ";
    @GuardedBy(value="IListe.class")
    private static FormatStyle DATE_FORMAT_STYLE;
    @GuardedBy(value="IListe.class")
    private static FormatStyle TIME_FORMAT_STYLE;
    private static final Map<Class<?>, FormatGroup> FORMATS;
    private final JTable jTable;
    private final JTextField filter;
    private boolean debugFilter;
    @GuardedBy(value="this")
    private FilterWorker filterWorker;
    private final JPopupMenu popup;
    private final TableSorter sorter;
    @GuardedBy(value="this")
    private SQLTableModelSource src;
    private boolean adjustVisible;
    private ColumnSizeAdjustor tcsa;
    private final Map<IListeAction, IListeAction.ButtonsBuilder> rowActions;
    private IListeAction defaultRowAction;
    private final JPanel btnPanel;
    private final Map<Class<?>, FormatGroup> searchFormats;
    private final List<IListener> listeners;
    private final List<IListener> naListeners;
    private final PropertyChangeSupport supp;
    private final ListSelectionListener selectionListener;
    private final TableModelListener selectionDataListener;
    private final PropertyChangeListener filterListener;
    private final List<PropertyChangeListener> modelPCListeners;
    private final ListSelectionState state;
    private final JTableStateManager tableStateManager;
    private int retainCount = 0;
    private boolean cellModificationAllowed = ITableModel.isDefaultCellsEditable();
    private boolean orderModificationAllowed = ITableModel.isDefaultOrderEditable();

    static {
        MD_CACHE = new RowMetadataCache(120, 5000, IListe.class.getName());
        FORCE_ALT_CELL_RENDERER = false;
        DATE_FORMAT_STYLE = FormatStyle.MEDIUM;
        TIME_FORMAT_STYLE = FormatStyle.SHORT;
        FORMATS = new HashMap();
        FORMATS.put(Date.class, new FormatGroup(DateFormat.getDateInstance(3), DateFormat.getDateInstance(2), DateFormat.getDateInstance(1)));
        FORMATS.put(Time.class, new FormatGroup(DateFormat.getTimeInstance(2), DateFormat.getTimeInstance(3)));
        FORMATS.put(Timestamp.class, new FormatGroup(DateFormat.getDateTimeInstance(3, 2), DateFormat.getDateTimeInstance(3, 3), DateFormat.getDateTimeInstance(1, 2), DateFormat.getDateTimeInstance(1, 3)));
    }

    private static final LockAction getLockAction() {
        assert (SwingUtilities.isEventDispatchThread());
        if (LOCK_ACTION == null) {
            LOCK_ACTION = new LockAction(true);
        }
        return LOCK_ACTION;
    }

    private static final LockAction getUnlockAction() {
        assert (SwingUtilities.isEventDispatchThread());
        if (UNLOCK_ACTION == null) {
            UNLOCK_ACTION = new LockAction(false);
        }
        return UNLOCK_ACTION;
    }

    public static final synchronized FormatStyle getDateFormatStyle() {
        return DATE_FORMAT_STYLE;
    }

    public static final int getDateFormatStyleInt() {
        return TimeUtils.toDateFormatStyle(IListe.getDateFormatStyle());
    }

    public static final synchronized void setDateFormatStyleInt(FormatStyle s) {
        DATE_FORMAT_STYLE = s;
    }

    public static final synchronized FormatStyle getTimeFormatStyle() {
        return TIME_FORMAT_STYLE;
    }

    public static final int getTimeFormatStyleInt() {
        return TimeUtils.toDateFormatStyle(IListe.getTimeFormatStyle());
    }

    public static final synchronized void setTimeFormatStyle(FormatStyle s) {
        TIME_FORMAT_STYLE = s;
    }

    public static final TableCellRenderer createDateRenderer() {
        return new FormatRenderer(DateFormat.getDateInstance(IListe.getDateFormatStyleInt()));
    }

    public static final TableCellRenderer createTimeRenderer() {
        return new FormatRenderer(DateFormat.getTimeInstance(IListe.getTimeFormatStyleInt()));
    }

    public static final TableCellRenderer createDateTimeRenderer() {
        return new FormatRenderer(DateFormat.getDateTimeInstance(IListe.getDateFormatStyleInt(), IListe.getTimeFormatStyleInt()));
    }

    public static final void remove(InputMap m, KeyStroke key) {
        InputMap current = m;
        while (current != null) {
            current.remove(key);
            current = current.getParent();
        }
    }

    public static void setForceAlternateCellRenderer(boolean force) {
        FORCE_ALT_CELL_RENDERER = force;
    }

    public static final IListe get(EventObject evt) {
        return SwingThreadUtils.getAncestorOrSelf(IListe.class, (Component)evt.getSource());
    }

    public IListe(SQLTableModelSource req) {
        this(req, null);
    }

    public IListe(SQLTableModelSource req, File configFile) {
        if (req == null) {
            throw new NullPointerException("Cr\u00e9ation d'une IListe avec une requete null");
        }
        this.rowActions = new LinkedHashMap<IListeAction, IListeAction.ButtonsBuilder>();
        this.supp = new PropertyChangeSupport(this);
        this.listeners = new ArrayList<IListener>();
        this.naListeners = new ArrayList<IListener>();
        this.modelPCListeners = new ArrayList<PropertyChangeListener>();
        this.sorter = new TableSorter();
        this.jTable = new JTable(this.sorter){
            private final boolean followMouseWorkaround;
            private boolean stateLoaded;
            {
                this.followMouseWorkaround = !Boolean.getBoolean("jtable.tooltip_follow_mouse.disable");
                this.stateLoaded = false;
            }

            @Override
            public String getToolTipText(MouseEvent event) {
                String info;
                String original = super.getToolTipText(event);
                int rowIndex = this.rowAtPoint(event.getPoint());
                if (rowIndex < 0) {
                    return original;
                }
                ArrayList<String> infoL = new ArrayList<String>();
                if (original != null) {
                    String html = "<html>";
                    if (original.startsWith("<html>")) {
                        infoL.add(original.substring("<html>".length(), original.length() - "<html>".length() - 1));
                    } else {
                        infoL.add(original);
                    }
                }
                SQLRowAccessor row = ITableModel.getLine(this.getModel(), rowIndex).getRowAccessor();
                RowRef cacheKey = row.getRowRef();
                RowMetadata md = MD_CACHE.get(cacheKey);
                if (md != null) {
                    String create = this.getLine(true, md);
                    String modif = this.getLine(false, md);
                    if (create == null && modif == null) {
                        infoL.add(TM.tr("ilist.metadata.na", new Object[0]));
                    } else {
                        if (create != null) {
                            infoL.add(create);
                        }
                        if (modif != null) {
                            infoL.add(modif);
                        }
                    }
                } else {
                    int half = 50;
                    int firstIndex = Math.max(0, rowIndex - 50);
                    int lastIndex = Math.min(this.getRowCount(), rowIndex + 50);
                    HashSet<Number> ids = CollectionUtils.newHashSet(100);
                    int i = firstIndex;
                    while (i < lastIndex) {
                        ids.add(ITableModel.getLine(this.getModel(), i).getRowAccessor().getIDNumber());
                        ++i;
                    }
                    MD_CACHE.fetch(cacheKey, ids);
                    infoL.add(TM.tr("ilist.metadata.loading", new Object[0]));
                }
                if (infoL.size() == 0) {
                    info = null;
                } else {
                    StringBuilder sb = new StringBuilder(256);
                    sb.append("<html>");
                    sb.append(CollectionUtils.join(infoL, "<br/>"));
                    sb.append("</html>");
                    if (this.followMouseWorkaround) {
                        sb.append("<!--");
                        sb.append(rowIndex);
                        sb.append("-->");
                    }
                    info = sb.toString();
                }
                return info;
            }

            public String getLine(boolean created, RowMetadata md) {
                String lastName;
                String firstName;
                int userParam;
                Integer userID;
                Date date = created ? md.getCreation() : md.getModification();
                Integer n = userID = created ? md.getUserCreate() : md.getUserModify();
                if (userID == null && date == null) {
                    return null;
                }
                if (userID != null) {
                    userParam = 1;
                    User user = UserManager.getInstance().getUser(userID);
                    firstName = user.getFirstName();
                    lastName = user.getName();
                } else {
                    userParam = 0;
                    firstName = null;
                    lastName = null;
                }
                return TM.tr("ilist.metadata", created ? 1 : 0, userParam, firstName, lastName, date == null ? 0 : 1, date);
            }

            @Override
            protected TableColumnModel createDefaultColumnModel() {
                return new XTableColumnModel();
            }

            @Override
            public void createDefaultColumnsFromModel() {
                boolean stateLoadedByThisMethod;
                XTableColumnModel cm = this.getColumnModel() instanceof XTableColumnModel ? (XTableColumnModel)this.getColumnModel() : null;
                HashSet<Object> invisibleCols = new HashSet<Object>();
                if (cm != null) {
                    while (cm.getColumnCount(false) > 0) {
                        TableColumn col = cm.getColumn(0, false);
                        if (!cm.isColumnVisible(col) && !invisibleCols.add(col.getIdentifier())) {
                            throw new IllegalStateException("Duplicate identifier " + col.getIdentifier());
                        }
                        cm.removeColumn(col);
                    }
                }
                super.createDefaultColumnsFromModel();
                if (this.stateLoaded) {
                    stateLoadedByThisMethod = false;
                } else {
                    this.stateLoaded = stateLoadedByThisMethod = IListe.this.loadTableState();
                }
                if (!stateLoadedByThisMethod && cm != null) {
                    for (TableColumn col : new ArrayList<TableColumn>(cm.getColumns(false))) {
                        cm.setColumnVisible(col, !invisibleCols.contains(col.getIdentifier()));
                    }
                }
            }
        };
        this.adjustVisible = true;
        this.tcsa = null;
        this.filter = new JTextField();
        this.filter.setEditable(false);
        this.debugFilter = false;
        InputMap tm = this.jTable.getInputMap(1);
        IListe.remove(tm, KeyStroke.getKeyStroke("F2"));
        tm.put(KeyStroke.getKeyStroke(' '), "startEditing");
        this.jTable.putClientProperty("JTable.autoStartsEdit", Boolean.FALSE);
        this.jTable.setShowHorizontalLines(false);
        this.jTable.setGridColor(new Color(230, 230, 230));
        this.jTable.setRowHeight(FontUtils.getPreferredRowHeight(this.jTable));
        this.popup = new JPopupMenu();
        TablePopupMouseListener.add(this.jTable, new ITransformer<MouseEvent, JPopupMenu>(){

            @Override
            public JPopupMenu transformChecked(MouseEvent input) {
                return IListe.this.updatePopupMenu(true);
            }
        });
        this.jTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    IListe.this.performDefaultAction(e);
                }
            }
        });
        this.selectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    IListe.this.fireNASelectionId();
                    IListe.this.updateButtons();
                }
            }
        };
        this.selectionDataListener = new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                if (!$assertionsDisabled && !(e.getSource() instanceof ITableModel)) {
                    throw new AssertionError();
                }
                boolean fire = false;
                if (e.getType() == 0 && e.getFirstRow() != -1) {
                    if (e.getLastRow() == Integer.MAX_VALUE) {
                        fire = false;
                    } else {
                        int i = e.getFirstRow();
                        while (!fire && i <= e.getLastRow()) {
                            if (IListe.this.getJTable().getSelectionModel().isSelectedIndex(IListe.this.sorter.viewIndex(i))) {
                                fire = true;
                            }
                            ++i;
                        }
                    }
                }
                if (fire) {
                    IListe.this.supp.firePropertyChange(IListe.SELECTION_DATA_PROPNAME, null, null);
                }
            }
        };
        this.filterListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                IListe.this.updateFilter();
            }
        };
        this.jTable.getColumnModel().addColumnModelListener(new TableColumnModelAdapter(){

            @Override
            public void columnAdded(TableColumnModelEvent e) {
                IListe.this.updateCols(e.getToIndex());
            }
        });
        this.tableStateManager = new JTableStateManager(this.jTable);
        this.setConfigFile(configFile);
        this.setSource(req);
        this.state = ListSelectionState.manage(this.jTable.getSelectionModel(), new TableListStateModel(this.sorter));
        this.state.addPropertyChangeListener("selectedIndex", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Number newValue = (Number)evt.getNewValue();
                if (newValue.intValue() >= 0) {
                    IListe.this.jTable.scrollRectToVisible(IListe.this.jTable.getCellRect(newValue.intValue(), 0, true));
                }
            }
        });
        this.state.addPropertyChangeListener("selectedID", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                IListe.this.fireSelectionId(((Number)evt.getNewValue()).intValue(), IListe.this.jTable.getSelectedColumn());
            }
        });
        this.state.addPropertyChangeListener("selectedIDs", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                IListe.this.supp.firePropertyChange(IListe.SELECTION_DATA_PROPNAME, null, null);
            }
        });
        this.btnPanel = new JPanel(new WrapLayout());
        this.addListenerOnModel(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                boolean doneUpdating;
                boolean bl = doneUpdating = "updating".equals(evt.getPropertyName()) && Boolean.FALSE.equals(evt.getNewValue());
                if (doneUpdating || "cellsEditable".equals(evt.getPropertyName())) {
                    IListe.this.updateButtons();
                }
            }
        });
        this.searchFormats = new HashMap(this.getFormats());
        this.searchFormats.put(Boolean.class, new FormatGroup(new BooleanFormat(), BooleanFormat.getNumberInstance(), BooleanFormat.createYesNo(Locale.getDefault())));
        ArrayList<Format> wAndwoTime = new ArrayList<Format>();
        wAndwoTime.addAll(this.searchFormats.get(Timestamp.class).getFormats());
        wAndwoTime.addAll(this.searchFormats.get(Date.class).getFormats());
        this.searchFormats.put(Timestamp.class, new FormatGroup(wAndwoTime));
        this.uiInit();
    }

    public final Map<Class<?>, FormatGroup> getFormats() {
        return FORMATS;
    }

    public final Map<Class<?>, FormatGroup> getSearchFormats() {
        return this.searchFormats;
    }

    public final RowAction addRowAction(Action action) {
        return this.addRowAction(action, null);
    }

    public final RowAction addRowAction(Action action, String id) {
        RowAction.PredicateRowAction res = new RowAction.PredicateRowAction(action, false, true, id).setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
        this.addIListeAction(res);
        return res;
    }

    public final RowAction addRowValuesAction(final SQLRowValuesAction a) {
        RowAction action = a instanceof ConvertedAction ? ((ConvertedAction)a).getRowAction() : new RowAction(new AbstractAction(a.getName()){

            @Override
            public void actionPerformed(ActionEvent e) {
                a.getAction().accept(IListe.get(e).createListEvent());
            }
        }, a.inHeader(), a.inPopupMenu(), a.getID()){

            @Override
            public boolean enabledFor(ListEvent evt) {
                return a.enabledFor(evt);
            }
        };
        if (this.addIListeAction(action)) {
            return action;
        }
        return null;
    }

    public final Map<SQLRowValuesAction, IListeAction> addRowValuesActions(Collection<? extends SQLRowValuesAction> actions) {
        IdentityHashMap<SQLRowValuesAction, IListeAction> res = new IdentityHashMap<SQLRowValuesAction, IListeAction>();
        for (SQLRowValuesAction sQLRowValuesAction : actions) {
            RowAction action = this.addRowValuesAction(sQLRowValuesAction);
            if (action == null) continue;
            res.put(sQLRowValuesAction, action);
        }
        return res;
    }

    public final void addIListeActions(Collection<? extends IListeAction> actions) {
        for (IListeAction iListeAction : actions) {
            this.addIListeAction(iListeAction);
        }
    }

    private final int findGroupIndex(String groupName) {
        if (groupName != null) {
            Component[] components = this.btnPanel.getComponents();
            int i = components.length - 1;
            while (i >= 0) {
                JComponent comp = (JComponent)components[i];
                if (groupName.equals(comp.getClientProperty("GROUPNAME"))) {
                    return i + 1;
                }
                --i;
            }
        }
        return -1;
    }

    public final boolean addIListeAction(IListeAction action) {
        if (this.rowActions.containsKey(action)) {
            return false;
        }
        IListeAction.ButtonsBuilder headerBtns = action.getHeaderButtons();
        this.rowActions.put(action, headerBtns);
        if (headerBtns.getContent().size() > 0) {
            this.updateButton(headerBtns, this.createListEvent());
            for (JButton headerBtn : headerBtns.getContent().keySet()) {
                headerBtn.setOpaque(false);
                this.btnPanel.add((Component)headerBtn, this.findGroupIndex((String)headerBtn.getClientProperty("GROUPNAME")));
            }
            this.btnPanel.setVisible(true);
        }
        return true;
    }

    public final void removeIListeActions(Collection<? extends IListeAction> actions) {
        for (IListeAction iListeAction : actions) {
            this.removeIListeAction(iListeAction);
        }
    }

    public final void removeIListeAction(IListeAction action) {
        IListeAction.ButtonsBuilder headerBtns = this.rowActions.remove(action);
        if (headerBtns == null) {
            return;
        }
        for (JButton headerBtn : headerBtns.getContent().keySet()) {
            this.btnPanel.remove(headerBtn);
            if (this.btnPanel.getComponentCount() == 0) {
                this.btnPanel.setVisible(false);
            }
            this.btnPanel.revalidate();
        }
        if (action.equals(this.defaultRowAction)) {
            this.setDefaultRowAction(null);
        }
    }

    private void updateButtons() {
        IListeAction.IListeEvent evt = this.createListEvent();
        for (IListeAction.ButtonsBuilder btns : this.rowActions.values()) {
            this.updateButton(btns, evt);
        }
    }

    private void updateButton(IListeAction.ButtonsBuilder btns, IListeAction.IListeEvent evt) {
        for (Map.Entry<JButton, IPredicate<IListeAction.IListeEvent>> e : btns.getContent().entrySet()) {
            e.getKey().setEnabled(e.getValue().evaluateChecked(evt));
        }
    }

    private JPopupMenu updatePopupMenu(boolean onRows) {
        this.popup.removeAll();
        IListeAction.PopupEvent evt = this.createPopupEvent(onRows);
        Action defaultAction = this.defaultRowAction != null ? this.defaultRowAction.getDefaultAction(evt) : null;
        VirtualMenu menu = VirtualMenu.createRoot(null);
        for (IListeAction iListeAction : this.rowActions.keySet()) {
            IListeAction.PopupBuilder popupContent = iListeAction.getPopupContent(evt);
            if (defaultAction != null && iListeAction == this.defaultRowAction) {
                JMenuItem defaultMI = popupContent.getRootMenuItem(defaultAction);
                if (defaultMI == null) {
                    Log.get().info("Default action not found at the root level of popup for " + this);
                } else {
                    defaultMI.setFont(defaultMI.getFont().deriveFont(1));
                }
            }
            menu.merge(popupContent.getMenu());
        }
        for (Map.Entry entry : menu.getContent().entrySet()) {
            MenuUtils.addMenuItem((JMenuItem)entry.getKey(), this.popup, (List<String>)((List)entry.getValue()));
        }
        return this.popup;
    }

    public final void setDefaultRowAction(IListeAction action) {
        this.defaultRowAction = action;
        if (action != null) {
            this.addIListeAction(action);
        }
    }

    public final IListeAction getDefaultRowAction() {
        return this.defaultRowAction;
    }

    private void performDefaultAction(MouseEvent e) {
        Action defaultAction;
        if (this.defaultRowAction != null && (defaultAction = this.defaultRowAction.getDefaultAction(this.createListEvent())) != null) {
            defaultAction.actionPerformed(new ActionEvent(e.getSource(), e.getID(), null, e.getWhen(), e.getModifiers()));
        }
    }

    final IListeAction.IListeEvent createListEvent() {
        return this.createEvent((vals, accessors) -> new IListeAction.IListeEvent(this, (List<SQLRowValues>)vals, (List<? extends SQLRowAccessor>)accessors));
    }

    final IListeAction.PopupEvent createPopupEvent(boolean onRows) {
        return this.createEvent((vals, accessors) -> new IListeAction.PopupEvent(this, (List<SQLRowValues>)vals, (List<? extends SQLRowAccessor>)accessors, onRows));
    }

    private final <E extends ListEvent> E createEvent(BiFunction<List<SQLRowValues>, List<? extends SQLRowAccessor>, E> ctor) {
        List<SQLRowAccessor> accessors;
        List<SQLRowValues> vals;
        if (this.getSource().getKeepMode() == ComboSQLRequest.KeepMode.GRAPH) {
            accessors = vals = this.getSelectedRows();
        } else {
            vals = null;
            accessors = this.getSelectedRowAccessors();
        }
        return (E)((ListEvent)ctor.apply(vals, accessors));
    }

    private void uiInit() {
        this.filter.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.isAltDown()) {
                    IListe.this.invertDebug();
                }
            }
        });
        FontUtils.setFontFor(this.filter, SEP);
        this.setFilter(null);
        this.updateFilter();
        this.jTable.getTableHeader().addMouseListener(new MouseAdapter(){
            private static final String COL_INDEX_KEY = "tableColIndex";
            private final JPopupMenu popupMenu = new JPopupMenu();
            private final Action toggleWidth = new AbstractAction(TM.tr("ilist.setColumnsWidth", new Object[0])){

                @Override
                public void actionPerformed(ActionEvent e) {
                    IListe.this.toggleAutoAdjust();
                }
            };
            private final Action toggleVisibility = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JComponent cb;
                    int columnIndex;
                    TableColumn col;
                    XTableColumnModel colModel = (XTableColumnModel)IListe.this.getJTable().getColumnModel();
                    boolean newValue = !colModel.isColumnVisible(col = colModel.getColumn(columnIndex = ((Number)(cb = (JComponent)e.getSource()).getClientProperty(15.COL_INDEX_KEY)).intValue(), false));
                    IListe.this.jTable.getTableHeader().setDraggedColumn(null);
                    if (newValue || colModel.getColumnCount(true) > 1) {
                        colModel.setColumnVisible(col, newValue);
                    }
                }
            };
            private final Action setAllVisible = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    XTableColumnModel colModel = (XTableColumnModel)IListe.this.getJTable().getColumnModel();
                    colModel.setAllColumnsVisible();
                }
            };

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.isAltDown()) {
                    boolean debug = IListe.this.getModel().isDebug();
                    IListe.this.getModel().setDebug(!debug);
                    IListe.this.setDebug(!debug);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            private void maybeShowPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.popupMenu.removeAll();
                    if (IListe.this.adjustVisible) {
                        JCheckBoxMenuItem cb = new JCheckBoxMenuItem(this.toggleWidth);
                        cb.setSelected(IListe.this.isAutoAdjusting());
                        this.popupMenu.add(cb);
                    }
                    if (IListe.this.getJTable().getColumnModel() instanceof XTableColumnModel) {
                        if (this.popupMenu.getComponentCount() > 0) {
                            this.popupMenu.addSeparator();
                        }
                        this.setAllVisible.putValue("Name", TM.tr("ilist.showAllColumns", new Object[0]));
                        this.popupMenu.add(this.setAllVisible);
                        XTableColumnModel colModel = (XTableColumnModel)IListe.this.getJTable().getColumnModel();
                        int i = 0;
                        boolean disableLastCol = colModel.getColumnCount(true) == 1;
                        for (TableColumn c : colModel.getColumns(false)) {
                            JCheckBoxMenuItem cb = new JCheckBoxMenuItem(this.toggleVisibility);
                            cb.setText(StringUtils.Shortener.Ellipsis.getBoundedLengthString(String.valueOf(c.getHeaderValue()), 200));
                            boolean isVisible = colModel.isColumnVisible(c);
                            cb.setSelected(isVisible);
                            cb.setEnabled(!isVisible || !disableLastCol);
                            if (!cb.isEnabled()) {
                                cb.setToolTipText(TM.tr("ilist.lastCol", new Object[0]));
                            }
                            cb.putClientProperty(COL_INDEX_KEY, i++);
                            this.popupMenu.add(cb);
                        }
                    }
                    if (this.popupMenu.getComponentCount() > 0) {
                        this.popupMenu.show((Component)e.getSource(), e.getX(), e.getY());
                    }
                }
            }
        });
        this.jTable.getTableHeader().setDefaultRenderer(new TableCellRenderer(){
            private final TableCellRenderer orig;
            {
                this.orig = IListe.this.jTable.getTableHeader().getDefaultRenderer();
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component res = this.orig.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (res instanceof JComponent) {
                    SQLTableModelColumn col = IListe.this.getSource().getColumn(table.convertColumnIndexToModel(column));
                    ((JComponent)res).setToolTipText(col.getToolTip());
                }
                return res;
            }
        });
        this.jTable.setDefaultRenderer(Clob.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                return super.getTableCellRendererComponent(table, StringClobConvertor.INSTANCE.unconvert((Clob)value), isSelected, hasFocus, row, column);
            }
        });
        this.jTable.setDefaultRenderer(Date.class, IListe.createDateRenderer());
        this.jTable.setDefaultRenderer(Time.class, IListe.createTimeRenderer());
        this.jTable.setDefaultRenderer(Timestamp.class, IListe.createDateTimeRenderer());
        for (Map.Entry<Class<?>, FormatGroup> e : this.getFormats().entrySet()) {
            this.jTable.setDefaultEditor(e.getKey(), new FormatEditor(e.getValue()));
        }
        this.sorter.setTableHeader(this.jTable.getTableHeader());
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                IListe.this.visibilityChanged();
            }

            @Override
            public void ancestorAdded(AncestorEvent event) {
                IListe.this.visibilityChanged();
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }
        });
        this.jTable.getSelectionModel().addListSelectionListener(this.selectionListener);
        if (this.getSource().getReq().isTableOrder()) {
            this.jTable.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent e) {
                    if (e.getKeyChar() == '+') {
                        IListe.this.deplacerDe(1);
                    } else if (e.getKeyChar() == '-') {
                        IListe.this.deplacerDe(-1);
                    }
                }
            });
            this.jTable.setDragEnabled(true);
            this.jTable.setDropMode(DropMode.INSERT_ROWS);
            this.jTable.setTransferHandler(new IListeTransferHandler());
        }
        JScrollPane scrollPane = new JScrollPane(this.jTable);
        scrollPane.setFocusable(false);
        scrollPane.addMouseListener(new PopupMouseListener(){

            @Override
            protected JPopupMenu createPopup(MouseEvent e) {
                return IListe.this.updatePopupMenu(false);
            }
        });
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0);
        this.add((Component)this.filter, c);
        ++c.gridy;
        this.btnPanel.setVisible(false);
        this.btnPanel.setOpaque(false);
        this.add((Component)this.btnPanel, c);
        c.weighty = 1.0;
        ++c.gridy;
        this.add((Component)scrollPane, c);
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 2L) != 0L) {
                    IListe.this.dispChanged();
                }
            }
        });
        this.setOpaque(false);
        this.setTransferHandler(new FileTransfertHandler(this.getSource().getPrimaryTable()));
        if (this.getSource().getPrimaryTable().getFieldRaw("UI_LOCK") != null) {
            this.addRowValuesAction(IListe.getUnlockAction());
            this.addRowValuesAction(IListe.getLockAction());
        }
    }

    protected final synchronized void invertDebug() {
        this.setDebug(!this.debugFilter);
    }

    protected final synchronized void setDebug(boolean b) {
        this.debugFilter = b;
        this.updateFilter();
    }

    private synchronized void updateFilter() {
        if (this.filterWorker != null) {
            this.filterWorker.cancel(true);
        }
        FilterWorker worker = !this.hasRequest() ? new RowFilterWorker(null) : (this.debugFilter ? new WhereFilterWorker(this.getRequest().getInstanceWhere()) : new RowFilterWorker(this.getRequest().getFilterRows()));
        this.filterWorker = worker;
        this.filterWorker.execute();
    }

    private void setFilter(String text) {
        boolean newVisible;
        boolean currentVisible = this.filter.isVisible();
        boolean bl = newVisible = text != null;
        if (newVisible || currentVisible) {
            this.filter.setText(text == null ? "" : text);
            this.filter.setVisible(newVisible);
            this.revalidate();
        }
    }

    public void selectID(int id) {
        this.selectIDs(Collections.singleton(id));
    }

    public void selectIDs(Collection<Integer> ids) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("not in EDT");
        }
        if (!this.isDead()) {
            this.state.selectIDs(ids);
        }
    }

    public int idFromIndex(int rowIndex) {
        return this.state.idFromIndex(rowIndex);
    }

    public void search(String s, String column) {
        this.search(s, column, null);
    }

    public void search(String s, String column, Runnable r) {
        this.getModel().searchContains(s, this.getModel().getColumnNames().indexOf(column), r);
    }

    public void exporter(File file) throws IOException {
        this.exporter(file, false, XMLFormatVersion.getDefault());
    }

    public File exporter(File file, boolean onlySelection, XMLFormatVersion version) throws IOException {
        return SpreadSheet.export((TableModel)this.getExportModel(onlySelection), (File)file, (XMLFormatVersion)version);
    }

    protected TableModel getExportModel(boolean onlySelection) {
        ViewTableModel res = new ViewTableModel(this.jTable);
        return onlySelection ? new TableModelSelectionAdapter(res, this.jTable.getSelectedRows()) : res;
    }

    public void update() {
        this.getModel().updateAll();
    }

    public int getRowCount() {
        if (this.isDead()) {
            return -1;
        }
        return this.getTableModel().getRowCount();
    }

    public int getTotalRowCount() {
        if (this.isDead()) {
            return -1;
        }
        return this.getModel().getTotalRowCount();
    }

    public final boolean isDead() {
        return this.getTableModel() == null;
    }

    public int getItemCount() {
        int count = -1;
        if (!this.isDead()) {
            int fieldIndex = -1;
            SQLTable t = this.getModel().getTable();
            SQLField qte = t.contains("QUANTITE") ? t.getField("QUANTITE") : t.getFieldRaw("NB_ESSAI_DDR");
            if (qte != null) {
                int i = 0;
                for (SQLTableModelColumn sQLTableModelColumn : this.getModel().getCols()) {
                    if (CollectionUtils.getSole(sQLTableModelColumn.getFields()) == qte) {
                        fieldIndex = i;
                    }
                    ++i;
                }
            }
            if (fieldIndex > 0) {
                count = 0;
                int j = 0;
                while (j < this.getTableModel().getRowCount()) {
                    count += ((Number)this.getTableModel().getValueAt(j, fieldIndex)).intValue();
                    ++j;
                }
            }
        }
        return count;
    }

    public void deplacerDe(int inc) {
        if (this.isSorted()) {
            return;
        }
        this.getModel().moveBy(this.getSelectedRows(), inc, true);
    }

    public int getSelectedId() {
        return this.state.getSelectedID();
    }

    public final boolean hasSelection() {
        return this.jTable.getSelectedRow() >= 0;
    }

    public final ListSelection getSelection() {
        return this.state;
    }

    public final ListSQLLine getLine(int viewIndex) {
        return ITableModel.getLine(this.getJTable().getModel(), viewIndex);
    }

    private <R> R getRow(int index, Class<R> clazz) {
        Object toCast;
        ListSQLLine line = this.getLine(index);
        if (clazz == SQLRowValues.class) {
            toCast = line.getRow().toImmutable();
        } else if (clazz == SQLRow.class) {
            toCast = line.getRowAccessor().asRow();
        } else if (clazz == SQLRowAccessor.class) {
            toCast = line.getRowAccessor();
        } else if (clazz == ListSQLLine.class) {
            toCast = line;
        } else {
            throw new IllegalArgumentException("Not implemented : " + clazz);
        }
        return clazz.cast(toCast);
    }

    private SQLRow fetchRow(int id) {
        if (id < 0) {
            return null;
        }
        return this.getSource().getPrimaryTable().getRow(id);
    }

    public SQLRow fetchSelectedRow() {
        return this.fetchRow(this.getSelectedId());
    }

    public SQLRowValues getSelectedRow() {
        return this.getSelectedRow(SQLRowValues.class);
    }

    public SQLRowAccessor getSelectedRowAccessor() {
        return this.getSelectedRow(SQLRowAccessor.class);
    }

    private final <R extends SQLRowAccessor> R getSelectedRow(Class<R> clazz) {
        int selectedIndex = this.state.getSelectedIndex();
        if (selectedIndex == -1) {
            return null;
        }
        return (R)((SQLRowAccessor)this.getRow(selectedIndex, clazz));
    }

    public final SQLRow getDesiredRow() {
        return this.fetchRow(this.getSelection().getUserSelectedID());
    }

    public final List<SQLRowValues> getSelectedRows() {
        return this.iterateSelectedRows(SQLRowValues.class);
    }

    public final List<ListSQLLine> getSelectedLines() {
        return this.iterateSelectedRows(ListSQLLine.class);
    }

    public final List<SQLRowAccessor> getSelectedRowAccessors() {
        return this.iterateSelectedRows(SQLRowAccessor.class);
    }

    private final <R> List<R> iterateSelectedRows(Class<R> clazz) {
        ListSelectionModel selectionModel = this.getJTable().getSelectionModel();
        if (selectionModel.isSelectionEmpty()) {
            return Collections.emptyList();
        }
        int start = selectionModel.getMinSelectionIndex();
        int stop = selectionModel.getMaxSelectionIndex();
        ArrayList<R> res = new ArrayList<R>();
        int i = start;
        while (i <= stop) {
            if (selectionModel.isSelectedIndex(i)) {
                try {
                    res.add(this.getRow(i, clazz));
                }
                catch (IndexOutOfBoundsException e) {
                    throw new IllegalStateException("The selected row at " + i + " is not in the model : it has been changed before Swing could update the selection. E.g. the DB was changed on mousePressed and Swing updated the selection on mouseReleased.", e);
                }
            }
            ++i;
        }
        return res;
    }

    public final void setAdjustVisible(boolean b) {
        this.adjustVisible = b;
    }

    protected final void toggleAutoAdjust() {
        if (this.tcsa == null) {
            this.tcsa = new ColumnSizeAdjustor(this.jTable);
        } else {
            this.tcsa.setInstalled(!this.tcsa.isInstalled());
        }
    }

    public final boolean isAutoAdjusting() {
        if (this.tcsa == null) {
            return false;
        }
        return this.tcsa.isInstalled();
    }

    public void addIListener(IListener l) {
        this.listeners.add(l);
    }

    public void addNonAdjustingIListener(IListener l) {
        this.naListeners.add(l);
    }

    public void addListener(TableModelListener l) {
        this.sorter.addTableModelListener(l);
    }

    public void removeListener(TableModelListener l) {
        this.sorter.removeTableModelListener(l);
    }

    public void addSortListener(PropertyChangeListener l) {
        this.sorter.addPropertyChangeListener(new PropertyChangeListenerProxy("sorting", l));
    }

    public boolean isSorted() {
        return this.sorter.isSorting();
    }

    public final void setSortingEnabled(boolean b) {
        this.sorter.setSortingEnabled(b);
    }

    public final boolean isSortingEnabled() {
        return this.sorter.isSortingEnabled();
    }

    private void fireSelectionId(int id, int selectedColumn) {
        for (IListener l : this.listeners) {
            l.selectionId(id, selectedColumn);
        }
    }

    protected final void fireNASelectionId() {
        int id = this.getSelectedId();
        for (IListener l : this.naListeners) {
            l.selectionId(id, -1);
        }
    }

    public final void addModelListener(PropertyChangeListener l) {
        this.supp.addPropertyChangeListener("model", l);
    }

    public final void rmModelListener(PropertyChangeListener l) {
        this.supp.removePropertyChangeListener("model", l);
    }

    public final void addListenerOnModel(PropertyChangeListener l) {
        this.modelPCListeners.add(l);
        if (this.getModel() != null) {
            this.getModel().addPropertyChangeListener(l);
        }
    }

    public final void rmListenerOnModel(PropertyChangeListener l) {
        this.modelPCListeners.remove(l);
        if (this.getModel() != null) {
            this.getModel().rmPropertyChangeListener(l);
        }
    }

    public final void addSelectionDataListener(PropertyChangeListener l) {
        this.supp.addPropertyChangeListener(SELECTION_DATA_PROPNAME, l);
    }

    public final void removeSelectionDataListener(PropertyChangeListener l) {
        this.supp.removePropertyChangeListener(SELECTION_DATA_PROPNAME, l);
    }

    protected final void visibilityChanged() {
        if (!this.isDead()) {
            this.getModel().setSleeping(!this.isShowing());
        }
    }

    public ITableModel getModel() {
        return (ITableModel)this.getTableModel();
    }

    public TableModel getTableModel() {
        assert (SwingUtilities.isEventDispatchThread());
        return this.sorter.getTableModel();
    }

    private final void setTableModel(ITableModel t) {
        ITableModel old = this.getModel();
        if (t == old) {
            return;
        }
        if (old != null) {
            for (PropertyChangeListener l : this.modelPCListeners) {
                old.rmPropertyChangeListener(l);
            }
            old.removeTableModelListener(this.selectionDataListener);
            if (this.hasRequest()) {
                this.getRequest().rmWhereListener(this.filterListener);
            }
        }
        this.sorter.setTableModel(t);
        if (t != null) {
            this.updateModelEditable();
            for (PropertyChangeListener l : this.modelPCListeners) {
                t.addPropertyChangeListener(l);
                l.propertyChange(new PropertyChangeEvent(t, null, null, null));
            }
            t.addTableModelListener(this.selectionDataListener, true);
            if (this.hasRequest()) {
                this.getRequest().addWhereListener(this.filterListener);
                this.filterListener.propertyChange(null);
            }
        }
        this.supp.firePropertyChange("model", old, t);
    }

    private void updateCols(int index) {
        TableColumnModel columnModel = this.jTable.getColumnModel();
        int start = index < 0 ? 0 : index;
        int stop = index < 0 ? columnModel.getColumnCount() : index + 1;
        int i = start;
        while (i < stop) {
            TableColumn col = columnModel.getColumn(i);
            SQLTableModelColumn srcCol = this.getSource().getColumn(col.getModelIndex());
            srcCol.install(col);
            col.setIdentifier(srcCol.getIdentifier());
            if (FORCE_ALT_CELL_RENDERER) {
                AlternateTableCellRenderer.setRendererAndListen(col);
            } else {
                AlternateTableCellRenderer.setRenderer(col);
            }
            ++i;
        }
    }

    public final boolean hasRequest() {
        return this.getSource() instanceof SQLTableModelSourceOnline;
    }

    public final ListSQLRequest getRequest() {
        return this.getSource().getReq();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setSource(SQLTableModelSource src) {
        if (src == null) {
            throw new NullPointerException();
        }
        IListe iListe = this;
        synchronized (iListe) {
            if (this.src == src) {
                return;
            }
            this.src = src;
        }
        this.setTableModel(new ITableModel(src));
    }

    public final synchronized SQLTableModelSource getSource() {
        return this.src;
    }

    public final File getConfigFile() {
        return this.tableStateManager == null ? null : this.tableStateManager.getConfigFile();
    }

    public final void setConfigFile(File configFile) {
        File oldFile;
        if (Boolean.getBoolean(STATELESS_TABLE_PROP)) {
            configFile = null;
        }
        if (!CompareUtils.equals(oldFile = this.getConfigFile(), configFile)) {
            if (configFile == null) {
                this.tableStateManager.endAutoSave();
            }
            this.tableStateManager.setConfigFile(configFile);
            if (oldFile == null) {
                this.tableStateManager.beginAutoSave();
            }
            this.loadTableState();
        }
    }

    public final boolean saveTableState() throws IOException {
        boolean hasFile;
        boolean bl = hasFile = this.getConfigFile() != null;
        if (hasFile) {
            this.tableStateManager.saveState();
        }
        return hasFile;
    }

    private boolean loadTableState() {
        if (this.getConfigFile() != null && this.getModel() != null) {
            return this.tableStateManager.loadState();
        }
        return false;
    }

    private final void dispChanged() {
        boolean requiredToLive;
        boolean bl = requiredToLive = this.isDisplayable() || this.retainCount > 0;
        if (!requiredToLive && !this.isDead()) {
            this.setTableModel(null);
        } else if (requiredToLive && this.isDead()) {
            this.setTableModel(new ITableModel(this.getSource()));
        }
    }

    public final void retain() {
        ++this.retainCount;
        this.dispChanged();
    }

    public final void release() {
        if (this.retainCount == 0) {
            throw new IllegalStateException("Unbalanced release");
        }
        --this.retainCount;
        this.dispChanged();
    }

    public JTable getJTable() {
        return this.jTable;
    }

    private void updateModelEditable() {
        ITableModel m = this.getModel();
        if (m != null) {
            m.setCellsEditable(this.isCellModificationAllowed() && !this.getSource().getElem().isPrivate());
            m.setOrderEditable(this.isOrderModificationAllowed() && !this.getSource().getElem().isPrivate());
        }
    }

    public void setModificationAllowed(boolean b) {
        this.setCellModificationAllowed(b);
        this.setOrderModificationAllowed(b);
    }

    public void setCellModificationAllowed(boolean b) {
        this.cellModificationAllowed = b;
        this.updateModelEditable();
    }

    public boolean isCellModificationAllowed() {
        return this.cellModificationAllowed;
    }

    public void setOrderModificationAllowed(boolean b) {
        this.orderModificationAllowed = b;
        this.updateModelEditable();
    }

    public boolean isOrderModificationAllowed() {
        return this.orderModificationAllowed;
    }

    @Override
    public void grabFocus() {
        this.jTable.grabFocus();
    }

    @Deprecated
    public static final class ConvertedAction
    extends SQLRowValuesAction {
        private final RowAction rowAction;

        public ConvertedAction(RowAction a) {
            super(a.inHeader(), a.inPopupMenu(), a.getID(), evt -> a.getAction().actionPerformed(new ActionEvent(evt.getSource(), 1001, null)));
            this.rowAction = a;
            if (a.getAction().getValue("Name") != null) {
                this.setName(String.valueOf(a.getAction().getValue("Name")));
            }
        }

        @Override
        public boolean enabledFor(ListEvent evt) {
            return this.getRowAction().enabledFor(evt);
        }

        public final RowAction getRowAction() {
            return this.rowAction;
        }
    }

    private abstract class FilterWorker
    extends SwingWorker<String, Object> {
        private FilterWorker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected final void done() {
            if (!this.isCancelled()) {
                try {
                    IListe.this.setFilter((String)this.get());
                }
                catch (Exception e) {
                    if (e instanceof ExecutionException && ((ExecutionException)e).getCause() instanceof InterruptedException) {
                        String msg = this.getClass() + " interruped";
                        Log.get().fine(msg);
                        IListe.this.setFilter(msg);
                    }
                    e.printStackTrace();
                    IListe.this.setFilter(e.getLocalizedMessage());
                }
                IListe iListe = IListe.this;
                synchronized (iListe) {
                    if (IListe.this.filterWorker == this) {
                        IListe.this.filterWorker = null;
                    }
                }
            }
        }
    }

    private static final class FormatRenderer
    extends DefaultTableCellRenderer {
        private final Format fmt;

        private FormatRenderer(Format fmt) {
            this.fmt = fmt;
        }

        @Override
        protected void setValue(Object value) {
            this.setText(value == null ? "" : this.fmt.format(value));
        }
    }

    private static final class LockAction
    extends SQLRowValuesAction {
        private final boolean lock;

        public LockAction(boolean lock) {
            super(false, true, (? super ListEvent e) -> {
                List<Number> ids = e.getSelectedIDs();
                SQLTable t = e.getTable();
                UpdateBuilder update = new UpdateBuilder(t);
                update.setObject("UI_LOCK", (Object)(lock ? "ro" : ""));
                User user = UserManager.getUser();
                if (user != null) {
                    update.setObject("ID_USER_UI_LOCK", (Object)user.getId());
                }
                update.setWhere(new Where(t.getKey(), ids));
                t.getDBSystemRoot().getDataSource().execute(update.asString());
                List<Number> fireIDs = ids.size() < 12 ? ids : Collections.singleton(-1);
                for (Number fireID : fireIDs) {
                    t.fireTableModified(fireID.intValue(), update.getFieldsNames());
                }
            });
            this.setName(TM.tr(lock ? "ilist.lockRows" : "ilist.unlockRows", new Object[0]));
            this.lock = lock;
        }

        @Override
        public boolean enabledFor(ListEvent evt) {
            boolean hasRight = TableAllRights.currentUserHasRight(this.lock ? "LIST_UI_LOCK_ROWS" : "LIST_UI_UNLOCK_ROWS", evt.getTable());
            return !evt.getSelectedRowAccessors().isEmpty() && hasRight;
        }
    }

    private final class RowFilterWorker
    extends FilterWorker {
        private final Collection<SQLRow> rows;

        private RowFilterWorker(Collection<SQLRow> r) {
            this.rows = r;
        }

        @Override
        protected String doInBackground() throws InterruptedException {
            if (this.getRows() == null) {
                return null;
            }
            Thread.sleep(60L);
            ArrayList<String> ancestors = new ArrayList<String>();
            SQLElementDirectory dir = IListe.this.getSource().getElem().getDirectory();
            Tuple2<SQLRow, String> parentAndDesc = this.getParent(this.getRows(), dir);
            ancestors.add(parentAndDesc.get1());
            SQLRow current = parentAndDesc.get0();
            while (current != null) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                SQLElement elem = dir.getElement(current.getTable());
                ancestors.add(0, elem.getDescription(current));
                current = elem.getForeignParent(current);
            }
            return CollectionUtils.join(ancestors, IListe.SEP);
        }

        private Tuple2<SQLRow, String> getParent(Collection<SQLRow> rows, SQLElementDirectory dir) throws InterruptedException {
            SQLRow parent = null;
            boolean sameParent = true;
            ArrayList<String> desc = new ArrayList<String>(rows.size());
            for (SQLRow current : rows) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                SQLElement elem = dir.getElement(current.getTable());
                if (parent == null || sameParent) {
                    SQLRow currentParent = elem.getForeignParent(current);
                    if (parent == null) {
                        parent = currentParent;
                    } else if (!parent.equals(currentParent)) {
                        sameParent = false;
                    }
                }
                desc.add(elem.getDescription(current));
            }
            return Tuple2.create(sameParent ? parent : null, CollectionUtils.join(desc, " \u25cf"));
        }

        private final Collection<SQLRow> getRows() {
            return this.rows;
        }

        public String toString() {
            return String.valueOf(super.toString()) + " on " + this.getRows();
        }
    }

    private final class WhereFilterWorker
    extends FilterWorker {
        private final Where w;

        private WhereFilterWorker(Where r) {
            this.w = r;
        }

        @Override
        protected String doInBackground() throws InterruptedException {
            return this.w == null ? "No where" : this.w.getClause();
        }
    }
}

