/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view.list;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.request.ComboSQLRequest;
import org.openconcerto.sql.sqlobject.ITextArticleWithCompletionCellEditor;
import org.openconcerto.sql.sqlobject.ITextWithCompletion;
import org.openconcerto.sql.sqlobject.SelectionListener;
import org.openconcerto.sql.sqlobject.SelectionRowListener;
import org.openconcerto.sql.view.list.RowValuesTable;
import org.openconcerto.sql.view.list.RowValuesTableModel;
import org.openconcerto.sql.view.list.SQLTableElement;
import org.openconcerto.sql.view.list.SQLTextComboTableCellEditor;
import org.openconcerto.sql.view.list.TextTableCellEditorWithCompletion;
import org.openconcerto.sql.view.list.ValidStateChecker;
import org.openconcerto.ui.TextAreaRenderer;
import org.openconcerto.utils.cc.ITransformer;

public class AutoCompletionManager
implements SelectionRowListener,
SelectionListener {
    private SQLTableElement fromTableElement;
    private RowValuesTable table;
    private TextTableCellEditorWithCompletion editor;
    private int lastSelectedComboId = 1;
    protected boolean optOk;
    protected boolean foreign;
    protected boolean disableCompletion;
    private SQLField fillFrom;
    private RowValuesTableModel tableModel;
    ITextWithCompletion t;
    SQLTextComboTableCellEditor textComboCellEdit;
    private ITextArticleWithCompletionCellEditor articleCombo;
    private HashMap<String, String> fillBy = new LinkedHashMap<String, String>();
    private int lastId = -1;
    private int lastEditingRow = -1;

    public AutoCompletionManager(SQLTableElement fromTableElement, SQLField fillFrom, RowValuesTable table, RowValuesTableModel tableModel) {
        this(fromTableElement, fillFrom, table, tableModel, 2, false);
    }

    public AutoCompletionManager(SQLTableElement fromTableElement, SQLField fillFrom, RowValuesTable table, RowValuesTableModel tableModel, ComboSQLRequest req) {
        this(fromTableElement, fillFrom, table, tableModel, 2, false, false, new ValidStateChecker(), req);
    }

    public AutoCompletionManager(SQLTableElement fromTableElement, SQLField fillFrom, RowValuesTable table, RowValuesTableModel tableModel, int modeCompletion, boolean expandWithShowAs, boolean foreign, ValidStateChecker checker) {
        this(fromTableElement, fillFrom, table, tableModel, modeCompletion, expandWithShowAs, foreign, checker, null);
    }

    public AutoCompletionManager(SQLTableElement fromTableElement, SQLField fillFrom, RowValuesTable table, RowValuesTableModel tableModel, int modeCompletion, boolean expandWithShowAs, boolean foreign, ValidStateChecker checker, ComboSQLRequest req) {
        this.foreign = foreign;
        if (req == null) {
            Vector<String> l = new Vector<String>();
            if (expandWithShowAs) {
                List<SQLField> lSQLFields = Configuration.getInstance().getShowAs().getFieldExpand(fillFrom.getTable());
                int i = 0;
                while (i < lSQLFields.size()) {
                    l.add(lSQLFields.get(i).getName());
                    ++i;
                }
            } else {
                l.add(fillFrom.getName());
                if (fillFrom.getName().equals("NOM") && fillFrom.getTable().contains("CODE")) {
                    l.add("CODE");
                }
            }
            req = new ComboSQLRequest(fillFrom.getTable(), l);
        }
        this.init(fromTableElement, fillFrom, table, tableModel, modeCompletion, req, foreign, checker);
    }

    public AutoCompletionManager(SQLTableElement fromTableElement, SQLField fillFrom, RowValuesTable table, RowValuesTableModel tableModel, int modeCompletion, boolean expandWithShowAs) {
        this(fromTableElement, fillFrom, table, tableModel, modeCompletion, expandWithShowAs, false, new ValidStateChecker());
    }

    public AutoCompletionManager(SQLTableElement fromTableElement, SQLField fillFrom, RowValuesTable table, RowValuesTableModel tableModel, int modeCompletion, ComboSQLRequest req) {
        this.init(fromTableElement, fillFrom, table, tableModel, modeCompletion, req, false);
    }

    public void init(SQLTableElement fromTableElement, SQLField fillFrom, RowValuesTable table, RowValuesTableModel tableModel, int modeCompletion, ComboSQLRequest req, boolean foreign) {
        this.init(fromTableElement, fillFrom, table, tableModel, modeCompletion, req, foreign, new ValidStateChecker());
    }

    public void init(final SQLTableElement fromTableElement, final SQLField fillFrom, RowValuesTable table, RowValuesTableModel tableModel, int modeCompletion, ComboSQLRequest req, boolean foreign, ValidStateChecker validStateChecker) {
        this.tableModel = tableModel;
        this.fromTableElement = fromTableElement;
        this.fillFrom = fillFrom;
        this.table = table;
        TableCellEditor cellEdit = this.fromTableElement.getTableCellEditor(table);
        if (foreign) {
            if (cellEdit instanceof SQLTextComboTableCellEditor) {
                this.textComboCellEdit = (SQLTextComboTableCellEditor)cellEdit;
                this.textComboCellEdit.addSelectionListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        int i = AutoCompletionManager.this.textComboCellEdit.getComboSelectedId();
                        if (AutoCompletionManager.this.lastSelectedComboId != i) {
                            if (fromTableElement.getField().getForeignTable().equals(fillFrom.getTable())) {
                                AutoCompletionManager.this.idSelected(i, null);
                            } else {
                                int selectedID = -1;
                                SQLRow selectedRow = AutoCompletionManager.this.textComboCellEdit.getCombo().getSelectedRow();
                                if (selectedRow != null) {
                                    selectedID = selectedRow.getForeignRow("ID_" + fillFrom.getTable().getName()).getID();
                                }
                                AutoCompletionManager.this.idSelected(selectedID, null);
                            }
                        }
                        AutoCompletionManager.this.lastSelectedComboId = i;
                        System.err.println("editing stopped");
                    }
                });
                this.textComboCellEdit.addCellEditorListener(new CellEditorListener(){

                    @Override
                    public void editingCanceled(ChangeEvent e) {
                        AutoCompletionManager.this.lastSelectedComboId = AutoCompletionManager.this.textComboCellEdit.getComboSelectedId();
                    }

                    @Override
                    public void editingStopped(ChangeEvent e) {
                        AutoCompletionManager.this.lastSelectedComboId = AutoCompletionManager.this.textComboCellEdit.getComboSelectedId();
                    }
                });
            }
        } else if (cellEdit instanceof ITextArticleWithCompletionCellEditor) {
            this.articleCombo = (ITextArticleWithCompletionCellEditor)cellEdit;
            this.articleCombo.addSelectionListener(this);
        } else {
            this.t = new ITextWithCompletion(req, true);
            this.t.setModeCompletion(modeCompletion);
            this.editor = new TextTableCellEditorWithCompletion(table, this.t, validStateChecker);
            if (this.fillFrom.getType().getType() == 12) {
                this.t.setLimitedSize(this.fillFrom.getType().getSize());
                this.editor.setLimitedSize(this.fillFrom.getType().getSize());
            }
            this.fromTableElement.setEditor(this.editor);
            this.fromTableElement.setRenderer(new TextAreaRenderer());
            this.t.addSelectionListener(this);
        }
    }

    public void fill(String string, String string2) {
        this.fillBy.put(string, string2);
    }

    @Override
    public void idSelected(int id, Object source) {
        int rowE = this.table.getEditingRow();
        if (rowE < 0) {
            this.lastEditingRow = rowE;
            return;
        }
        if (this.lastEditingRow == rowE && this.lastId == id) {
            return;
        }
        if (id > 1) {
            this.lastId = id;
            this.lastEditingRow = rowE;
            if (this.table.getCellEditor() != null && !this.foreign) {
                this.table.getCellEditor().stopCellEditing();
            }
            this.fillWithSelection(null, id, rowE);
        }
    }

    @Override
    public void rowSelected(SQLRowAccessor row, Object source) {
        int rowE = this.table.getEditingRow();
        if (rowE < 0 || row == null) {
            this.lastEditingRow = rowE;
            return;
        }
        this.lastEditingRow = rowE;
        if (this.table.getCellEditor() != null && !this.foreign) {
            this.table.getCellEditor().stopCellEditing();
        }
        this.fillWithSelection(row, -1, rowE);
    }

    private void fillWithSelection(final SQLRowAccessor r, final int id, final int rowE) {
        final SQLRowValues rowDest = rowE >= 0 && rowE <= this.table.getRowCount() ? this.table.getRowValuesTableModel().getRowValuesAt(rowE) : null;
        new Thread(new Runnable(){

            @Override
            public void run() {
                SQLRowAccessor rowArt;
                final SQLRow rowV = r != null ? r.fetchNewRow(false) : AutoCompletionManager.this.fillFrom.getTable().getRow(id);
                if (AutoCompletionManager.this.fillFrom != null && AutoCompletionManager.this.fillFrom.getTable().getName().equals("ARTICLE") && AutoCompletionManager.this.fillFrom.getName().equals("NOM") && rowDest != null && !rowDest.isUndefined() && (rowArt = rowDest.getForeign("ID_ARTICLE")) != null && !rowArt.isUndefined() && rowArt.getString("NOM") != null && rowArt.getString("NOM").trim().equalsIgnoreCase(rowV.getString("NOM").trim())) {
                    return;
                }
                final Set keys = AutoCompletionManager.this.fillBy.keySet();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        for (String from : keys) {
                            String to = (String)AutoCompletionManager.this.fillBy.get(from);
                            Object fromV = AutoCompletionManager.this.getValueFrom(rowV, from, rowDest);
                            int column = AutoCompletionManager.this.tableModel.getColumnForField(to);
                            if (column >= 0) {
                                if (AutoCompletionManager.this.table.getRowValuesTableModel().getValueAt(rowE, column) != null && AutoCompletionManager.this.table.getRowValuesTableModel().getValueAt(rowE, column).equals(fromV)) continue;
                                AutoCompletionManager.this.table.getRowValuesTableModel().setValueAt(fromV, rowE, column);
                                if ((this).AutoCompletionManager.this.foreign || AutoCompletionManager.this.table.getEditingColumn() != column || AutoCompletionManager.this.table.getEditingRow() != rowE) continue;
                                AutoCompletionManager.this.table.editingCanceled(null);
                                AutoCompletionManager.this.table.setColumnSelectionInterval(column, column);
                                AutoCompletionManager.this.table.setRowSelectionInterval(rowE, rowE);
                                if (!AutoCompletionManager.this.table.editCellAt(rowE, column) || AutoCompletionManager.this.table.getEditorComponent() == null) continue;
                                AutoCompletionManager.this.table.getEditorComponent().requestFocusInWindow();
                                continue;
                            }
                            AutoCompletionManager.this.table.getRowValuesTableModel().putValue(fromV, rowE, to);
                        }
                        AutoCompletionManager.this.table.resizeAndRepaint();
                    }
                });
            }
        }).start();
    }

    public Set<String> getFieldsFrom() {
        return this.fillBy.keySet();
    }

    public String getToField(String fromField) {
        return this.fillBy.get(fromField);
    }

    public void fillRowValues(SQLRowAccessor from, Set<String> fields, SQLRowValues to) {
        for (String fromField : fields) {
            String toField = this.fillBy.get(fromField);
            to.put(toField, this.getValueFrom(from.asRow(), fromField, to));
        }
    }

    protected Object getValueFrom(SQLRow row, String field, SQLRowAccessor rowDest) {
        return row.getObject(field);
    }

    public void setSelectTransformer(ITransformer<SQLSelect, SQLSelect> selTrans) {
        if (this.t != null) {
            this.t.setSelectTransformer(selTrans);
        } else if (this.textComboCellEdit != null) {
            this.textComboCellEdit.setSelectTransformer(selTrans);
        } else if (this.articleCombo != null) {
            this.articleCombo.setSelectTransformer(selTrans);
        }
    }

    public void setWhere(Where w) {
        if (this.t != null) {
            this.t.setWhere(w);
        } else if (this.textComboCellEdit != null) {
            this.textComboCellEdit.setWhere(w);
        } else if (this.articleCombo != null) {
            this.articleCombo.setWhere(w);
        }
    }

    public void setFillWithField(String s) {
        this.t.setFillWithField(s);
    }
}

