/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view.column;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.view.column.Column;
import org.openconcerto.sql.view.column.ColumnFooterRenderer;
import org.openconcerto.sql.view.column.ColumnRowRenderer;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JLabelBold;
import org.openconcerto.ui.VFlowLayout;

public class ColumnView
extends JPanel {
    private Column column;
    private GridBagConstraints c = new DefaultGridBagConstraints();
    private final int width;
    private final ColumnRowRenderer cRenderer;
    private final ColumnFooterRenderer fRenderer;
    private final JPanel spacer = new JPanel();

    ColumnView(Column column, int width, ColumnRowRenderer cRenderer, ColumnFooterRenderer fRenderer) {
        this.column = column;
        this.width = width;
        this.cRenderer = cRenderer;
        this.fRenderer = fRenderer;
        this.setLayout(new GridBagLayout());
        JLabelBold header = new JLabelBold(column.getName());
        this.setMinimumSize(new Dimension(width, header.getMinimumSize().height));
        this.setPreferredSize(new Dimension(width, header.getMinimumSize().height));
        this.c.insets = new Insets(2, 4, 2, 4);
        this.c.fill = 2;
        this.c.anchor = 18;
        this.c.weightx = 1.0;
        this.add((Component)header, this.c);
        this.c.fill = 1;
        ++this.c.gridy;
        this.c.weighty = 1.0;
        this.spacer.setOpaque(false);
        this.add((Component)this.spacer, this.c);
    }

    public void updateContent() {
        this.remove(this.spacer);
        JPanel content = new JPanel();
        content.setLayout(new VFlowLayout(0, 2, 3, true));
        content.setBackground(Color.WHITE);
        List<? extends SQLRowAccessor> rows = this.column.getRows();
        for (SQLRowAccessor sQLRowAccessor : rows) {
            content.add(this.cRenderer.getRenderer(sQLRowAccessor, this.width - 8));
        }
        this.c.fill = 1;
        ++this.c.gridy;
        this.c.weighty = 1.0;
        JScrollPane jScrollPane = new JScrollPane(content);
        jScrollPane.setBorder(null);
        this.add((Component)jScrollPane, this.c);
        ++this.c.gridy;
        this.c.weighty = 0.0;
        this.add((Component)this.fRenderer.getRenderer(rows, this.width), this.c);
    }
}

