/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view;

import java.util.Collections;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import org.openconcerto.sql.Log;
import org.openconcerto.sql.model.RowRef;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.request.SQLCache;
import org.openconcerto.sql.view.RowMetadata;
import org.openconcerto.utils.RTInterruptedException;
import org.openconcerto.utils.ThreadFactory;
import org.openconcerto.utils.cache.CacheResult;

public final class RowMetadataCache {
    private final SQLCache<RowRef, RowMetadata> cache;
    private final ExecutorService exec;

    private static RowMetadata createMD(SQLRowAccessor r, SQLField creation, SQLField userCreate, SQLField modification, SQLField userModify) {
        return new RowMetadata(RowMetadataCache.getDateMD(r, creation), RowMetadataCache.getForeignIntegerMD(r, userCreate), RowMetadataCache.getDateMD(r, modification), RowMetadataCache.getForeignIntegerMD(r, userModify));
    }

    private static Date getDateMD(SQLRowAccessor row, SQLField f) {
        return f == null ? null : row.getObjectAs(f.getName(), Date.class);
    }

    private static Integer getForeignIntegerMD(SQLRowAccessor row, SQLField f) {
        if (f == null) {
            return null;
        }
        Number n = row.getNonEmptyForeignIDNumber(f.getName());
        return n == null ? null : Integer.valueOf(n.intValue());
    }

    public RowMetadataCache(int timeoutInSeconds, int maxCount, String name) {
        this.cache = new SQLCache(timeoutInSeconds, maxCount, "Cache of metadata for " + name);
        this.exec = Executors.newSingleThreadExecutor(new ThreadFactory("Metadata cache thread for " + name, true));
    }

    public final RowMetadata get(RowRef ref) {
        CacheResult cacheRes = this.cache.get(ref);
        if (cacheRes.getState() == CacheResult.State.INTERRUPTED) {
            throw new RTInterruptedException("interrupted while waiting for the cache");
        }
        if (cacheRes.getState() == CacheResult.State.VALID) {
            RowMetadata res = (RowMetadata)cacheRes.getRes();
            assert (res != null) : "Null ambiguity";
            return res;
        }
        return null;
    }

    public final void fetch(RowRef ref, Set<Number> withAdditionalIDs) {
        this.exec.submit(() -> {
            CacheResult cacheResult = this.cache.get(ref);
            if (cacheResult.getState() == CacheResult.State.VALID) {
                return;
            }
            SQLTable table = ref.getTable();
            SQLField creationDateField = table.getCreationDateField();
            SQLField creationUserField = table.getCreationUserField();
            SQLField modifDateField = table.getModifDateField();
            SQLField modifUserField = table.getModifUserField();
            SQLSelect sel = new SQLSelect();
            sel.addAllSelect(table.getPrimaryKeyFields());
            sel.addAllSelect(creationDateField, creationUserField, modifDateField, modifUserField);
            sel.setWhere(Where.inValues(table.getKey(), withAdditionalIDs));
            Set<SQLTable> data = Collections.singleton(table);
            try {
                for (SQLRowAccessor sQLRowAccessor : SQLRowListRSH.execute(sel)) {
                    this.cache.put(sQLRowAccessor.getRowRef(), RowMetadataCache.createMD(sQLRowAccessor, creationDateField, creationUserField, modifDateField, modifUserField), data);
                }
            }
            catch (Exception exception) {
                Log.get().log(Level.WARNING, "Couldn't fetch metadata for " + ref, exception);
            }
        });
    }
}

