/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import org.openconcerto.sql.TM;
import org.openconcerto.sql.element.BaseSQLComponent;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.users.rights.TableAllRights;
import org.openconcerto.sql.users.rights.UserRights;
import org.openconcerto.sql.users.rights.UserRightsManager;
import org.openconcerto.sql.view.EditPanelListener;
import org.openconcerto.sql.view.IListener;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.checks.ValidListener;
import org.openconcerto.utils.checks.ValidObject;
import org.openconcerto.utils.checks.ValidState;
import org.openconcerto.utils.doc.Documented;

public class EditPanel
extends JPanel
implements IListener,
ActionListener,
Documented {
    public static final String ADD_AT_THE_END = "org.openconcerto.sql.editPanel.endAdd";
    public static final String NOBORDER = "org.openconcerto.editpanel.noborder";
    public static final String ADD_SEPARATOR = "org.openconcerto.editpanel.separator";
    public static final EditMode CREATION = EditMode.CREATION;
    public static final EditMode MODIFICATION = EditMode.MODIFICATION;
    public static final EditMode READONLY = EditMode.READONLY;
    private final EditMode mode;
    private JButton jButtonSupprimer;
    private JButton jButtonModifier;
    private JButton jButtonAjouter;
    private JButton jButtonAnnuler;
    private final SQLComponent component;
    private JCheckBox keepOpen = new JCheckBox(TM.tr("editPanel.keepOpen", new Object[0]));
    private final List<EditPanelListener> panelListeners = new Vector<EditPanelListener>();
    private JScrollPane p;
    private final SQLElement element;
    private IListe l = null;
    private ValidState valid = ValidState.getNoReasonInstance(false);

    public EditPanel(SQLElement e) {
        this(e, CREATION);
    }

    public EditPanel(SQLElement e, EditMode mode) {
        this(e.createDefaultComponent(), mode);
    }

    public EditPanel(SQLComponent e, EditMode mode) {
        this(e, mode, Collections.emptyList());
    }

    public EditPanel(SQLElement e, EditMode mode, List<SQLField> hiddenFields) {
        this(e.createDefaultComponent(), mode, hiddenFields);
    }

    public EditPanel(SQLComponent e, EditMode mode, List<SQLField> hiddenFields) {
        this.mode = mode;
        this.element = e.getElement();
        this.component = e;
        try {
            this.component.setMode(mode.getCompMode());
            this.component.setNonExistantEditable(this.getMode() == CREATION);
            if (this.component instanceof BaseSQLComponent) {
                int i = 0;
                while (i < hiddenFields.size()) {
                    SQLField hiddenField = hiddenFields.get(i);
                    ((BaseSQLComponent)this.component).doNotShow(hiddenField);
                    ++i;
                }
            }
            if (this.getMode() != READONLY) {
                this.component.addValidListener(new ValidListener(){

                    @Override
                    public void validChange(ValidObject src, ValidState newValue) {
                        EditPanel.this.valid = newValue;
                        EditPanel.this.updateBtns();
                    }
                });
                PropertyChangeListener updateBtnsListener = new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        EditPanel.this.updateBtns();
                    }
                };
                ((BaseSQLComponent)this.component).addSelectionListener(updateBtnsListener);
                this.getSQLComponent().addPropertyChangeListener("readOnlySelection", updateBtnsListener);
            }
            this.uiInit();
            this.component.uiInit();
            if (Boolean.getBoolean(NOBORDER)) {
                this.setInnerBorder(BorderFactory.createEmptyBorder());
            }
        }
        catch (Exception ex) {
            ExceptionHandler.handle(TM.tr("init.error", new Object[0]), ex);
        }
    }

    public final EditMode getMode() {
        return this.mode;
    }

    private void updateBtns() {
        this.updateBtn(this.jButtonAjouter, true, false, "noRightToAdd", "INSERT_ROW");
        this.updateBtn(this.jButtonModifier, true, true, "noRightToModify", "UPDATE_ROW");
        this.updateBtn(this.jButtonSupprimer, false, true, "noRightToDel", "DELETE_ROW");
    }

    private void updateBtn(JButton b, boolean needValid, boolean needID, String desc, String code) {
        if (b != null) {
            boolean idOK = this.getSQLComponent().getSelectedID() >= 0;
            UserRights rights = UserRightsManager.getCurrentUserRights();
            ValidState res = !TableAllRights.hasRight(rights, code, this.getSQLComponent().getElement().getTable()) ? ValidState.createCached(false, TM.tr(desc, new Object[0])) : (this.getSQLComponent().isSelectionReadOnly() ? ValidState.createCached(false, TM.tr("editPanel.readOnlySelection", new Object[0])) : (needID && !idOK ? ValidState.createCached(false, TM.tr("editPanel.inexistentElement", new Object[0])) : (needValid && !this.valid.isValid() ? this.valid : ValidState.getTrueInstance())));
            EditPanel.updateBtn(b, res);
        }
    }

    private final void uiInit() {
        this.fill();
        this.component.getInputMap(2).put(KeyStroke.getKeyStroke(10, 128), "apply");
        this.component.getActionMap().put("apply", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditPanel.this.apply();
            }
        });
    }

    protected void fill() {
        EditPanel container = this;
        container.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridheight = 1;
        c.gridwidth = 4;
        c.fill = 2;
        c.weighty = 1.0;
        c.weightx = 0.0;
        c.insets = new Insets(2, 2, 1, 2);
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.fill = 1;
        this.p = new JScrollPane(this.component);
        this.p.getVerticalScrollBar().setUnitIncrement(9);
        this.p.setOpaque(false);
        this.p.getViewport().setOpaque(false);
        this.p.setViewportBorder(null);
        this.p.setMinimumSize(new Dimension(60, 60));
        container.add((Component)this.p, c);
        if (Boolean.getBoolean(ADD_SEPARATOR)) {
            ++c.gridy;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.gridwidth = 0;
            c.fill = 1;
            JSeparator comp = new JSeparator();
            comp.setMinimumSize(new Dimension(comp.getPreferredSize()));
            container.add((Component)comp, c);
        }
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.fill = 0;
        this.keepOpen.setOpaque(false);
        if (this.getMode() == CREATION) {
            c.gridx = 1;
            c.fill = 2;
            c.anchor = 13;
            if (!Boolean.getBoolean("org.openconcerto.editpanel.hideKeepOpen")) {
                container.add((Component)this.keepOpen, c);
            }
            c.fill = 0;
            c.gridx = 2;
            c.anchor = 13;
            this.jButtonAjouter = new JButton(TM.tr("add", new Object[0]));
            container.add((Component)this.jButtonAjouter, c);
            this.jButtonAjouter.addActionListener(this);
            this.jButtonAjouter.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    String toolTipText;
                    if (!EditPanel.this.jButtonAjouter.isEnabled() && (toolTipText = EditPanel.this.jButtonAjouter.getToolTipText()) != null && !toolTipText.isEmpty()) {
                        JOptionPane.showMessageDialog(EditPanel.this, toolTipText);
                    }
                }
            });
        } else if (this.getMode() == MODIFICATION) {
            c.gridx = 1;
            c.anchor = 13;
            this.jButtonModifier = new JButton(TM.tr("saveModifications", new Object[0]));
            container.add((Component)this.jButtonModifier, c);
            c.weightx = 0.0;
            c.gridx = 2;
            this.jButtonSupprimer = new JButton(TM.tr("remove", new Object[0]));
            container.add((Component)this.jButtonSupprimer, c);
            this.jButtonModifier.addActionListener(this);
            this.jButtonSupprimer.addActionListener(this);
        }
        c.weightx = 0.0;
        c.gridx = 3;
        c.anchor = 13;
        this.jButtonAnnuler = this.getMode() == READONLY ? new JButton(TM.tr("close", new Object[0])) : new JButton(TM.tr("cancel", new Object[0]));
        container.add((Component)this.jButtonAnnuler, c);
        this.jButtonAnnuler.addActionListener(this);
    }

    public Dimension getViewResizedDimesion(Dimension frameSize) {
        Dimension viewSize = this.p.getViewport().getView().getSize();
        int verticalHidden = viewSize.height - this.p.getVerticalScrollBar().getVisibleAmount();
        int horizontalHidden = viewSize.width - this.p.getHorizontalScrollBar().getVisibleAmount();
        Rectangle bounds = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        int maxV = (int)bounds.getMaxY() - this.getY();
        int maxH = (int)bounds.getMaxX() - this.getX();
        int vertical = Math.min(frameSize.height + verticalHidden, maxV);
        int horizontal = Math.min(frameSize.width + horizontalHidden, maxH);
        return new Dimension(horizontal, vertical);
    }

    public void setInnerBorder(Border b) {
        this.p.setBorder(b);
    }

    @Override
    public void selectionId(int id, int field) {
        if (id < 0) {
            this.component.select(null);
        } else if (this.getMode() == CREATION) {
            this.component.select(this.element.createCopy(id));
        } else {
            this.component.select(id);
        }
    }

    protected final void apply() {
        JButton b = this.getMode() == CREATION ? this.jButtonAjouter : (this.getMode() == MODIFICATION ? this.jButtonModifier : (this.getMode() == READONLY ? this.jButtonAnnuler : null));
        if (b != null) {
            b.doClick();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.jButtonAnnuler) {
            try {
                this.fireCancelled();
            }
            catch (Throwable ex) {
                ExceptionHandler.handle(TM.tr("editPanel.cancelError", new Object[0]), ex);
            }
        } else if (e.getSource() == this.jButtonModifier) {
            try {
                this.modifier();
            }
            catch (Throwable ex) {
                ExceptionHandler.handle(TM.tr("editPanel.modifyError", new Object[0]), ex);
            }
        } else if (e.getSource() == this.jButtonAjouter) {
            try {
                this.ajouter();
            }
            catch (Throwable ex) {
                ExceptionHandler.handle(TM.tr("editPanel.addError", new Object[0]), ex);
            }
        } else if (e.getSource() == this.jButtonSupprimer) {
            try {
                if (this.element.askArchive((Component)this, this.component.getSelectedID())) {
                    this.fireDeleted();
                }
            }
            catch (Throwable ex) {
                ExceptionHandler.handle(TM.tr("editPanel.deleteError", new Object[0]), ex);
            }
        }
    }

    public void modifier() {
        this.component.update();
        this.fireModified();
    }

    public boolean alwaysVisible() {
        return this.keepOpen.isSelected();
    }

    public void setAlwaysVisible(boolean b) {
        this.keepOpen.setSelected(true);
    }

    private void ajouter() {
        if (this.jButtonAjouter.isEnabled()) {
            int id = !Boolean.getBoolean(ADD_AT_THE_END) && this.getIListe() != null && !this.getIListe().isDead() && this.getIListe().getDesiredRow() != null ? this.component.insert(this.getIListe().getDesiredRow()) : this.component.insert();
            if (this.getIListe() != null) {
                this.getIListe().selectID(id);
            }
            if (this.alwaysVisible()) {
                ((BaseSQLComponent)this.getSQLComponent()).partialReset();
            }
            this.fireInserted(id);
        }
    }

    private void fireDeleted() {
        int i = 0;
        while (i < this.panelListeners.size()) {
            EditPanelListener listener = this.panelListeners.get(i);
            listener.deleted();
            ++i;
        }
    }

    private void fireInserted(int id) {
        int i = 0;
        while (i < this.panelListeners.size()) {
            EditPanelListener listener = this.panelListeners.get(i);
            listener.inserted(id);
            ++i;
        }
    }

    private void fireModified() {
        int i = 0;
        while (i < this.panelListeners.size()) {
            EditPanelListener listener = this.panelListeners.get(i);
            listener.modified();
            ++i;
        }
    }

    private void fireCancelled() {
        int i = 0;
        while (i < this.panelListeners.size()) {
            EditPanelListener listener = this.panelListeners.get(i);
            listener.cancelled();
            ++i;
        }
    }

    public void addEditPanelListener(EditPanelListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("null listener");
        }
        if (!this.panelListeners.contains(listener)) {
            this.panelListeners.add(listener);
        }
    }

    public void removeEditPanelListener(EditPanelListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("null listener");
        }
        if (this.panelListeners.contains(listener)) {
            this.panelListeners.remove(listener);
        }
    }

    static void updateBtn(JButton btn, ValidState validState) {
        btn.setEnabled(validState.isValid());
        btn.setToolTipText(EditPanel.computeTooltip(validState));
    }

    static String computeTooltip(ValidState validState) {
        return EditPanel.computeTooltip(validState.isValid(), validState.getValidationText());
    }

    private static String computeTooltip(boolean valid, String cause) {
        String res;
        if (valid) {
            res = null;
        } else {
            String c = cause == null ? "" : cause.trim();
            String validationText = TM.tr("editPanel.invalidContent", new Object[0]);
            validationText = c.length() > 0 ? String.valueOf(validationText) + "\n" + c : String.valueOf(validationText) + TM.tr("editPanel.invalidContent.unknownReason", new Object[0]);
            res = "<html>" + validationText.replace("\n", "<br>") + "</html>";
        }
        return res;
    }

    public void disableCancel() {
        this.jButtonAnnuler.setVisible(false);
    }

    public void disableDelete() {
        if (this.jButtonSupprimer != null) {
            this.jButtonSupprimer.setVisible(false);
        }
    }

    public void resetValue() {
        this.component.resetValue();
    }

    public void addComponentListenerOnViewPort(ComponentListener l) {
        this.p.getViewport().getView().addComponentListener(l);
    }

    public void setModifyLabel(String label) {
        this.jButtonModifier.setText(label);
    }

    public SQLComponent getSQLComponent() {
        return this.component;
    }

    public void setValues(List<SQLRow> sqlRows) {
        SQLTable t = this.component.getElement().getTable();
        SQLRowValues vals = new SQLRowValues(t);
        SQLField parentFF = this.component.getElement().getParentForeignField();
        if (parentFF == null) {
            return;
        }
        SQLTable foreignT = parentFF.getForeignTable();
        int i = 0;
        while (i < sqlRows.size()) {
            SQLRow row = sqlRows.get(i);
            if (row.getTable().equals(foreignT)) {
                vals.put(parentFF.getName(), row.getID());
            }
            ++i;
        }
        this.component.select(vals);
    }

    public final void setIListe(IListe l) {
        this.l = l;
    }

    private final IListe getIListe() {
        return this.l;
    }

    @Override
    public String getDocId() {
        return (Object)((Object)this.getMode()) + "_" + this.element.getTable().getName();
    }

    @Override
    public String getGenericDoc() {
        return "";
    }

    @Override
    public boolean onScreen() {
        return false;
    }

    @Override
    public boolean isDocTransversable() {
        return true;
    }

    public static enum EditMode {
        CREATION{

            @Override
            protected SQLComponent.Mode getCompMode() {
                return SQLComponent.Mode.INSERTION;
            }
        }
        ,
        MODIFICATION{

            @Override
            protected SQLComponent.Mode getCompMode() {
                return SQLComponent.Mode.MODIFICATION;
            }
        }
        ,
        READONLY{

            @Override
            protected SQLComponent.Mode getCompMode() {
                return SQLComponent.Mode.READ_ONLY;
            }
        };


        protected abstract SQLComponent.Mode getCompMode();
    }
}

