/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.ui;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openconcerto.sql.TM;
import org.openconcerto.sql.ui.SoftwareInfoPanel;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.SystemInfoPanel;

public class InfoPanel
extends JPanel {
    private final Locale locale;

    public InfoPanel(Locale locale) {
        super(new GridBagLayout());
        this.locale = locale;
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.add((Component)this.createTitle("infoPanel.softwareTitle"), c);
        ++c.gridy;
        this.add((Component)new SoftwareInfoPanel(locale), c);
        ++c.gridy;
        this.add((Component)this.createTitle("infoPanel.systemTitle"), c);
        ++c.gridy;
        this.add((Component)new SystemInfoPanel(locale), c);
    }

    private JLabel createTitle(String text) {
        final JLabel res = new JLabel(TM.tr(this.locale, text, new Object[0]));
        Font font = res.getFont();
        res.setFont(font.deriveFont(font.getSize2D() * 1.2f).deriveFont(1));
        res.setToolTipText(TM.tr(this.locale, "infoPanel.refresh", new Object[0]));
        res.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                InfoPanel.this.refresh(Arrays.asList(InfoPanel.this.getComponents()).indexOf(res) + 1);
            }
        });
        return res;
    }

    public final void refresh() {
        this.refresh(-1);
    }

    private final void refresh(int index) {
        if (index < 0 || index == 1) {
            ((SoftwareInfoPanel)this.getComponent(1)).refresh(this.locale);
        }
        if (index < 0 || index == 3) {
            ((SystemInfoPanel)this.getComponent(3)).refresh(this.locale);
        }
    }
}

