/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.PropsConfiguration;
import org.openconcerto.sql.TM;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.preferences.UserProps;
import org.openconcerto.sql.request.ComboSQLRequest;
import org.openconcerto.sql.sqlobject.IComboModel;
import org.openconcerto.sql.sqlobject.IComboSelectionItem;
import org.openconcerto.sql.sqlobject.SQLRequestComboBox;
import org.openconcerto.sql.ui.Login;
import org.openconcerto.sql.users.UserManager;
import org.openconcerto.sql.users.rights.UserRightsManager;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.ReloadPanel;
import org.openconcerto.ui.valuewrapper.EmptyValueWrapper;
import org.openconcerto.ui.valuewrapper.ValueWrapperFactory;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.ExceptionUtils;
import org.openconcerto.utils.JImage;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.cc.ITransformer;
import org.openconcerto.utils.checks.EmptyListener;
import org.openconcerto.utils.checks.EmptyObj;
import org.openconcerto.utils.i18n.TranslationManager;
import org.openconcerto.utils.text.SimpleDocumentListener;

public class ConnexionPanel
extends JPanel
implements ActionListener {
    public static final String QUICK_LOGIN = "org.openconcerto.quickLogin";
    private final Login login;
    private final JPasswordField textPassWord;
    private final EmptyValueWrapper<String> textLogin;
    private SQLRequestComboBox comboSociete;
    private String encryptedPassword;
    protected String clearPassword;
    private final Runnable r;
    private final boolean societeSelector;
    private final ReloadPanel reloadPanel;
    private boolean isConnecting = false;
    private String connectionAllowed;
    private final JCheckBox saveCheckBox = new JCheckBox(TM.getTM().translate("loginPanel.storePass", new Object[0]));
    private final JButton buttonConnect = new JButton(TM.getTM().translate("loginPanel.loginAction", new Object[0]));
    private String adminLogin = TM.getTM().translate("loginPanel.adminLogin", new Object[0]);
    private final JLabel loginLabel = new JLabel(TM.getTM().translate("loginPanel.loginLabel", new Object[0]));
    private final JLabel passwordLabel = new JLabel(TM.getTM().translate("loginPanel.passLabel", new Object[0]));
    private final JLabel companyLabel = new JLabel(TM.getTM().translate("loginPanel.companyLabel", new Object[0]));
    private String localeBaseName = null;
    private final List<Locale> localesToDisplay = new ArrayList<Locale>();
    private final JButton langButton = new JButton(Locale.ROOT.getLanguage());

    private static boolean quickLogin(Runnable r, boolean societeSelector) {
        Tuple2<String, String> res;
        String lastLogin = UserProps.getInstance().getLastLoginName();
        String pass = UserProps.getInstance().getStoredPassword();
        if (Boolean.getBoolean(QUICK_LOGIN) && lastLogin.length() > 0 && pass != null && (!societeSelector || UserProps.getInstance().getLastSocieteID() >= 0) && (res = new Login(Configuration.getInstance().getRoot()).connectEnc(lastLogin, pass)).get0() == null) {
            ConnexionPanel.execute(r);
            return true;
        }
        return false;
    }

    public static ConnexionPanel create(Runnable r, JImage imageLogo) {
        return ConnexionPanel.create(r, imageLogo, false);
    }

    public static ConnexionPanel create(Runnable r, JImage imageLogo, boolean societeSelector) {
        if (ConnexionPanel.quickLogin(r, societeSelector)) {
            return null;
        }
        return new ConnexionPanel(r, imageLogo, societeSelector);
    }

    public ConnexionPanel(Runnable r, JImage imageLogo) {
        this(r, imageLogo, false);
    }

    public ConnexionPanel(Runnable r, JImage imageLogo, boolean societeSelector) {
        this(r, imageLogo, societeSelector, true);
    }

    public ConnexionPanel(Runnable r, JImage imageLogo, boolean societeSelector, boolean allowStoredPass) {
        String storedPassword;
        if (r == null) {
            throw new IllegalArgumentException("null runnable");
        }
        this.login = new Login(Configuration.getInstance().getRoot());
        this.societeSelector = societeSelector;
        this.r = r;
        String lastLoginName = UserProps.getInstance().getLastLoginName();
        if (lastLoginName == null || lastLoginName.trim().length() == 0) {
            lastLoginName = this.adminLogin;
        }
        this.encryptedPassword = storedPassword = allowStoredPass ? UserProps.getInstance().getStoredPassword() : null;
        this.connectionAllowed = null;
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridheight = 1;
        c.gridwidth = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 0, 0, 0);
        c.fill = 2;
        imageLogo.check();
        this.add((Component)imageLogo, c);
        ++c.gridy;
        c.gridwidth = 0;
        this.add((Component)new JSeparator(0), c);
        c.insets = new Insets(2, 2, 1, 2);
        ++c.gridy;
        c.gridwidth = 1;
        c.weightx = 0.0;
        this.loginLabel.setHorizontalAlignment(4);
        this.add((Component)this.loginLabel, c);
        this.textLogin = new EmptyValueWrapper<String>(ValueWrapperFactory.create(new JTextField(), String.class));
        this.textLogin.setValue(lastLoginName);
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)this.textLogin.getComp(), c);
        ((JTextField)this.textLogin.getComp()).addActionListener(this);
        this.textLogin.addEmptyListener(new EmptyListener(){

            @Override
            public void emptyChange(EmptyObj src, boolean newValue) {
                ConnexionPanel.this.checkValidity();
            }
        });
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        this.passwordLabel.setHorizontalAlignment(4);
        this.add((Component)this.passwordLabel, c);
        this.textPassWord = new JPasswordField();
        if (storedPassword != null) {
            char[] s = new char[8];
            Arrays.fill(s, ' ');
            this.textPassWord.setText(new String(s));
            this.clearPassword = null;
        } else {
            this.clearPassword = "";
        }
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)this.textPassWord, c);
        this.textPassWord.getDocument().addDocumentListener(new SimpleDocumentListener(){

            @Override
            public void update(DocumentEvent e) {
                ConnexionPanel.this.clearPassword = String.valueOf(ConnexionPanel.this.textPassWord.getPassword());
                ConnexionPanel.this.checkValidity();
            }
        });
        this.textPassWord.addActionListener(this);
        if (societeSelector) {
            ++c.gridy;
            c.gridx = 0;
            c.weightx = 0.0;
            this.companyLabel.setHorizontalAlignment(4);
            this.add((Component)this.companyLabel, c);
            SQLTable tableSociete = this.login.getUserTable().getDBRoot().findTable("SOCIETE_COMMON");
            if (tableSociete == null) {
                throw ExceptionUtils.createExn(IllegalStateException.class, "Missing table : SOCIETE_COMMON", null);
            }
            this.comboSociete = new SQLRequestComboBox(false, 25);
            ComboSQLRequest req = Configuration.getInstance().getDirectory().getElement(tableSociete).getComboRequest(true);
            req.keepRows(true);
            IComboModel model = new IComboModel(req);
            int lastSociete = UserProps.getInstance().getLastSocieteID();
            if (lastSociete >= 0) {
                model.setValue(lastSociete);
            } else {
                model.setFirstFillSelection(new ITransformer<List<IComboSelectionItem>, IComboSelectionItem>(){

                    @Override
                    public IComboSelectionItem transformChecked(List<IComboSelectionItem> input) {
                        return CollectionUtils.getFirst(input);
                    }
                });
            }
            this.comboSociete.uiInit(model);
            this.comboSociete.addEmptyListener(new EmptyListener(){

                @Override
                public void emptyChange(EmptyObj src, boolean newValue) {
                    ConnexionPanel.this.checkValidity();
                }
            });
            this.comboSociete.addValueListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    ConnexionPanel.this.checkValidity();
                }
            });
            ++c.gridx;
            this.add((Component)this.comboSociete, c);
        }
        JPanel panelButton = new JPanel();
        panelButton.setOpaque(false);
        panelButton.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c2 = new DefaultGridBagConstraints();
        c2.weightx = 1.0;
        if (allowStoredPass) {
            this.saveCheckBox.setOpaque(false);
            panelButton.add((Component)this.saveCheckBox, c2);
            c2.weightx = 0.0;
            if (storedPassword != null && storedPassword.length() > 0) {
                this.saveCheckBox.setSelected(true);
            }
        }
        ++c2.gridx;
        this.reloadPanel = new ReloadPanel();
        this.reloadPanel.setOpaque(false);
        this.reloadPanel.setMode(2);
        panelButton.add((Component)this.reloadPanel, c2);
        ++c2.gridx;
        c2.weightx = 0.0;
        this.langButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JPopupMenu menu = new JPopupMenu();
                Locale locale = UserProps.getInstance().getLocale();
                for (final Locale l : ConnexionPanel.this.localesToDisplay) {
                    System.err.println("ConnexionPanel.ConnexionPanel(...).new ActionListener() {...}.actionPerformed()" + l);
                    JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(l.getDisplayName(l));
                    if (l.equals(locale)) {
                        menuItem.setSelected(true);
                    }
                    menu.add(menuItem);
                    menuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            ConnexionPanel.this.setUILanguage(l);
                        }
                    });
                }
                menu.show(ConnexionPanel.this.langButton, 0, 0);
            }
        });
        this.langButton.setOpaque(false);
        this.langButton.setBorderPainted(false);
        this.langButton.setContentAreaFilled(false);
        this.langButton.setBorder(BorderFactory.createEmptyBorder());
        this.langButton.setFocusable(false);
        this.langButton.setVisible(false);
        panelButton.add((Component)this.langButton, c2);
        ++c2.gridx;
        this.buttonConnect.setOpaque(false);
        panelButton.add((Component)this.buttonConnect, c2);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.gridwidth = 0;
        c.weighty = 1.0;
        this.add((Component)panelButton, c);
        this.buttonConnect.addActionListener(this);
        this.checkValidity();
    }

    public final void initLocalization(String baseName, List<Locale> toDisplay) {
        if (baseName == null) {
            throw new NullPointerException("Null baseName");
        }
        if (this.localeBaseName != null) {
            throw new IllegalStateException("Already inited to " + this.localeBaseName);
        }
        this.localeBaseName = baseName;
        this.localesToDisplay.addAll(toDisplay);
        this.setUILanguage(UserProps.getInstance().getLocale());
        TM.getInstance();
    }

    private void checkValidity() {
        this.buttonConnect.setEnabled(this.connectionAllowed == null && this.areFieldsValidated());
        this.buttonConnect.setToolTipText(this.connectionAllowed);
    }

    private boolean areFieldsValidated() {
        if (this.societeSelector && this.comboSociete.isEmpty()) {
            return false;
        }
        if (this.textLogin == null || this.textLogin.isEmpty() || this.textPassWord == null) {
            return false;
        }
        return this.textLogin.getValidState().isValid();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.isConnecting()) {
            return;
        }
        if (this.textLogin.getValue().length() < 1) {
            return;
        }
        this.setConnecting(true);
        ConnexionPanel.execute(new Runnable(){

            @Override
            public void run() {
                ConnexionPanel.this.connect();
            }
        });
    }

    private static void execute(Runnable runnable) {
        Thread t = new Thread(runnable, "ConnexionPanel Login");
        t.setPriority(1);
        t.start();
    }

    public void setConnectionAllowed(String connectionAllowed) {
        this.connectionAllowed = connectionAllowed;
        this.checkValidity();
    }

    private synchronized boolean isConnecting() {
        return this.isConnecting;
    }

    private synchronized void setConnecting(boolean b) {
        if (b) {
            this.reloadPanel.setMode(0);
            this.buttonConnect.setEnabled(false);
            this.saveCheckBox.setEnabled(false);
            if (this.comboSociete != null) {
                this.comboSociete.setEnabled(false);
            }
            ((JTextField)this.textLogin.getComp()).setEditable(false);
            this.textPassWord.setEditable(false);
        } else {
            this.buttonConnect.setEnabled(true);
            this.saveCheckBox.setEnabled(true);
            if (this.comboSociete != null) {
                this.comboSociete.setEnabled(true);
            }
            ((JTextField)this.textLogin.getComp()).setEditable(true);
            this.textPassWord.setEditable(true);
            this.reloadPanel.setMode(2);
        }
        this.isConnecting = b;
    }

    private void connect() {
        String userName = this.textLogin.getValue();
        Tuple2<String, String> loginRes = this.clearPassword == null ? this.login.connectEnc(userName, this.encryptedPassword) : this.login.connectClear(userName, this.clearPassword, "\"" + this.clearPassword + "\"");
        if (loginRes.get0() == null) {
            UserProps.getInstance().setLastLoginName(userName);
            if (this.societeSelector) {
                UserProps.getInstance().setLastSocieteID(this.comboSociete.getSelectedId());
            }
            if (this.saveCheckBox.isSelected()) {
                UserProps.getInstance().setEncryptedStoredPassword(loginRes.get1());
            } else {
                UserProps.getInstance().setEncryptedStoredPassword(null);
            }
            UserProps.getInstance().store();
            if (UserRightsManager.getInstance() != null) {
                UserRightsManager.getInstance().preloadRightsForUserId(UserManager.getUserID());
            }
            this.r.run();
            SwingUtilities.getWindowAncestor(this).dispose();
        } else {
            this.unlockUIOnError(loginRes.get0(), userName);
        }
    }

    private void unlockUIOnError(final String error, final String userName) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    ConnexionPanel.this.reloadPanel.setMode(1);
                    JOptionPane.showMessageDialog(ConnexionPanel.this, TM.getTM().translate("loginPanel." + error, userName));
                    if ("unknownUser".equals(error)) {
                        ConnexionPanel.this.textLogin.setValue(ConnexionPanel.this.adminLogin);
                    }
                    ConnexionPanel.this.setConnecting(false);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public int getSelectedSociete() {
        return this.comboSociete.getSelectedId();
    }

    protected void setUILanguage(Locale locale) {
        System.err.println("ConnexionPanel.setUILanguage()" + locale + " : " + locale.getDisplayName());
        ResourceBundle bundle = ResourceBundle.getBundle(this.localeBaseName, locale, TranslationManager.getControl());
        this.adminLogin = bundle.getString("adminLogin");
        this.loginLabel.setText(bundle.getString("loginLabel"));
        this.passwordLabel.setText(bundle.getString("passwordLabel"));
        this.companyLabel.setText(bundle.getString("companyLabel"));
        this.saveCheckBox.setText(bundle.getString("saveCheckBox"));
        this.buttonConnect.setText(bundle.getString("buttonConnect"));
        this.langButton.setText(locale.getLanguage());
        this.langButton.setVisible(true);
        UserProps.getInstance().setLocale(locale);
        ((PropsConfiguration)Configuration.getInstance()).setLocale(locale);
        Locale.setDefault(locale);
        JComponent.setDefaultLocale(locale);
        TranslationManager.createDefaultInstance();
        DateFormat df = DateFormat.getDateInstance();
        System.err.println("ConnexionPanel.setUILanguage() Date :" + Locale.getDefault() + " : " + new Date() + ": format: " + df.format(new Date()));
        System.err.println("ConnexionPanel.setUILanguage() Category :" + Locale.getDefault(Locale.Category.FORMAT));
    }
}

