/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openconcerto.sql.model.IResultSetHandler;
import org.openconcerto.sql.model.SQLData;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.TableRef;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.Value;

public final class SQLSelectHandlerBuilder {
    private final SQLSelect sel;
    private Value<TableRef> t;
    private boolean readCache;
    private boolean writeCache;
    private boolean immutableRows;

    public SQLSelectHandlerBuilder(SQLSelect sel) {
        if (sel == null) {
            throw new NullPointerException("Null query");
        }
        this.sel = sel;
        this.t = Value.getNone();
        this.setUseCache(true);
        this.immutableRows = true;
    }

    public SQLSelectHandlerBuilder setUseCache(boolean b) {
        this.setReadCache(b);
        this.setWriteCache(b);
        return this;
    }

    public SQLSelectHandlerBuilder setReadCache(boolean b) {
        this.readCache = b;
        return this;
    }

    public final boolean isReadCache() {
        return this.readCache;
    }

    public SQLSelectHandlerBuilder setWriteCache(boolean b) {
        this.writeCache = b;
        return this;
    }

    public final boolean isWriteCache() {
        return this.writeCache;
    }

    public final SQLSelectHandlerBuilder setImmutableRows(boolean immutableRows) {
        this.immutableRows = immutableRows;
        return this;
    }

    public final boolean isImmutableRows() {
        return this.immutableRows;
    }

    public SQLSelectHandlerBuilder setTableRef(TableRef t) throws NullPointerException {
        if (t == null) {
            throw new NullPointerException("Null table");
        }
        this.t = Value.getSome(t);
        return this;
    }

    public SQLSelectHandlerBuilder unsetTableRef() {
        this.t = Value.getNone();
        return this;
    }

    public IResultSetHandler createHandler() {
        Tuple2<SQLTable, List<String>> indexes = SQLRowListRSH.getIndexes(this.sel, this.t.toNonNull(), !this.t.hasValue());
        final HashSet<SQLTable> tables = new HashSet<SQLTable>();
        for (TableRef ref : this.sel.getTableRefs().values()) {
            tables.add(ref.getTable());
        }
        boolean acquireLock = this.sel.getLockStrength() != SQLSelect.LockStrength.NONE;
        return new IResultSetHandler(SQLRowListRSH.create(indexes, this.isImmutableRows()), this.isReadCache() && !acquireLock, this.isWriteCache() && !acquireLock){

            @Override
            public Set<? extends SQLData> getCacheModifiers() {
                return tables;
            }
        };
    }

    public List<SQLRow> execute() {
        return (List)this.sel.getSystemRoot().getDataSource().execute(this.sel.asString(), this.createHandler());
    }
}

