/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLSelect;

public class SQLRowMode {
    public static final SQLRowMode DATA = new SQLRowMode(SQLSelect.UNARCHIVED, true, true);
    public static final SQLRowMode DEFINED = new SQLRowMode(SQLSelect.BOTH, true, true);
    public static final SQLRowMode VALID = new SQLRowMode(SQLSelect.UNARCHIVED, true, false);
    public static final SQLRowMode EXIST = new SQLRowMode(SQLSelect.BOTH, true, false);
    public static final SQLRowMode INEXISTANT;
    public static final SQLRowMode NO_CHECK;
    private final SQLSelect.ArchiveMode archiveMode;
    private final boolean existing;
    private final boolean undefined;

    static {
        NO_CHECK = INEXISTANT = new SQLRowMode(SQLSelect.BOTH, false, false);
    }

    public static final boolean check(SQLSelect.ArchiveMode archiveMode, SQLRow r) {
        if (archiveMode == SQLSelect.BOTH) {
            return true;
        }
        return archiveMode == SQLSelect.ARCHIVED && r.isArchived() || archiveMode == SQLSelect.UNARCHIVED && !r.isArchived();
    }

    public SQLRowMode(SQLSelect.ArchiveMode archiveMode, boolean existing, boolean excludeUndefined) {
        this.archiveMode = archiveMode;
        this.existing = existing;
        this.undefined = excludeUndefined;
    }

    public SQLSelect.ArchiveMode getArchiveMode() {
        return this.archiveMode;
    }

    public boolean wantExisting() {
        return this.existing;
    }

    public boolean excludeUndefined() {
        return this.undefined;
    }

    public boolean check(SQLRow r) {
        if (this == NO_CHECK) {
            return true;
        }
        if (r == null) {
            return false;
        }
        if (this.excludeUndefined() && r.isUndefined()) {
            return false;
        }
        if (!SQLRowMode.check(this.getArchiveMode(), r)) {
            return false;
        }
        return this.wantExisting() == r.exists();
    }

    public SQLRow filter(SQLRow r) {
        return this.check(r) ? r : null;
    }
}

