/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.jcip.annotations.Immutable;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.cc.ITransformer;

@Immutable
public final class SQLName {
    private static final Pattern unquoted = Pattern.compile("\\w+");
    private static final Pattern MS_END_QUOTE = Pattern.compile("]", 16);
    private final List<String> items;

    public static SQLName parse(String name) {
        return SQLName.parse(name, '\"', '\"');
    }

    public static SQLName parseMS(String name) {
        return SQLName.parse(name, '[', ']');
    }

    private static SQLName parse(String name, char startQuote, char endQuote) {
        name = name.trim();
        ArrayList<String> res = new ArrayList<String>();
        int index = 0;
        while (index < name.length()) {
            boolean inQuote;
            char c = name.charAt(index);
            boolean bl = inQuote = c == startQuote;
            if (inQuote) {
                int index2 = SQLName.findNextQuote(name, ++index, endQuote);
                String part = "";
                while (index2 + 1 < name.length() && name.charAt(index2 + 1) == endQuote) {
                    part = String.valueOf(part) + name.substring(index, index2 + 1);
                    index = index2 + 2;
                    index2 = SQLName.findNextQuote(name, index, endQuote);
                }
                part = String.valueOf(part) + name.substring(index, index2);
                res.add(part);
                index = index2 + 1;
            } else {
                Matcher matcher = unquoted.matcher(name);
                if (!matcher.find(index)) {
                    throw new IllegalArgumentException("illegal unquoted name at " + index);
                }
                int index2 = matcher.end();
                res.add(name.substring(index, index2));
                index = index2;
            }
            if (index == name.length()) continue;
            if (name.charAt(index) != '.') {
                throw new IllegalArgumentException("no dot at " + index);
            }
            if (index == name.length() - 1) {
                throw new IllegalArgumentException("trailing dot");
            }
            ++index;
        }
        return new SQLName(res);
    }

    private static int findNextQuote(String name, int index, char c) {
        int res = name.indexOf(c, index);
        if (res < 0) {
            throw new IllegalArgumentException("no corresponding quote " + index);
        }
        return res;
    }

    public SQLName(String ... items) {
        this(Arrays.asList(items));
    }

    public SQLName(List<String> items) {
        this(items, false);
    }

    private SQLName(List<String> items, boolean safe) {
        if (safe) {
            this.items = items;
        } else {
            ArrayList<String> tmp = new ArrayList<String>(items.size());
            for (String item : items) {
                if (item == null || item.length() <= 0) continue;
                tmp.add(item);
            }
            this.items = Collections.unmodifiableList(tmp);
        }
    }

    public String quote() {
        return CollectionUtils.join(this.items, ".", new ITransformer<String, String>(){

            @Override
            public String transformChecked(String input) {
                return SQLBase.quoteIdentifier(input);
            }
        });
    }

    public String quoteMS() {
        return CollectionUtils.join(this.items, ".", new ITransformer<String, String>(){

            @Override
            public String transformChecked(String input) {
                return String.valueOf('[') + MS_END_QUOTE.matcher(input).replaceAll("]]") + ']';
            }
        });
    }

    public String getItem(int index) {
        if (index < 0) {
            index = this.getItemCount() + index;
        }
        return this.items.get(index);
    }

    public String getItemLenient(int index) {
        try {
            return this.getItem(index);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    public int getItemCount() {
        return this.items.size();
    }

    public String getName() {
        return this.getItem(this.items.size() - 1);
    }

    public String getFirst() {
        return this.getItem(0);
    }

    public SQLName getRest() {
        return new SQLName(this.items.subList(1, this.items.size()), true);
    }

    public final SQLName resolve(SQLName to) {
        int toCount;
        SQLName from = this;
        int fromCount = from.getItemCount();
        if (fromCount <= (toCount = to.getItemCount())) {
            return to;
        }
        ArrayList<String> l = new ArrayList<String>(fromCount);
        l.addAll(from.asList().subList(0, fromCount - toCount));
        l.addAll(to.asList());
        return new SQLName(Collections.unmodifiableList(l), true);
    }

    public final SQLName getContextualName(SQLName to) {
        int toCount;
        SQLName from = this;
        int fromCount = from.getItemCount();
        if (fromCount < (toCount = to.getItemCount())) {
            return to;
        }
        if (fromCount > toCount) {
            SQLName resolved = from.resolve(to);
            assert (resolved.getItemCount() == fromCount);
            return from.getContextualName(resolved);
        }
        assert (fromCount == toCount);
        int common = CollectionUtils.equalsFromStart(from.asList(), to.asList());
        if (common == 0) {
            return to;
        }
        return new SQLName(to.asList().subList(common, toCount), true);
    }

    public final List<String> asList() {
        return this.items;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SQLName) {
            SQLName o = (SQLName)obj;
            return this.items.equals(o.items);
        }
        return false;
    }

    public int hashCode() {
        return this.items.hashCode();
    }

    public String toString() {
        return this.quote();
    }
}

