/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.jcip.annotations.Immutable;
import org.apache.commons.dbutils.RowProcessor;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLTable;

@Immutable
public final class SQLFieldRowProcessor
implements RowProcessor {
    private final List<String> names;
    private final int rsOffset;
    private Boolean uniqueNames;

    public SQLFieldRowProcessor(SQLTable table, List<String> fields) {
        this(0, fields, table::getField);
    }

    public SQLFieldRowProcessor(List<? extends FieldRef> fields) {
        this(0, fields);
    }

    public SQLFieldRowProcessor(int rsOffset, List<? extends FieldRef> fields) {
        this(rsOffset, fields, FieldRef::getField);
    }

    private <F> SQLFieldRowProcessor(int rsOffset, List<? extends F> fields, Function<? super F, SQLField> func) {
        ArrayList<String> names = new ArrayList<String>(fields.size());
        for (F ref : fields) {
            if (ref == null) {
                names.add(null);
                continue;
            }
            SQLField f = func.apply(ref);
            names.add(f.getName());
        }
        this.names = Collections.unmodifiableList(names);
        this.rsOffset = rsOffset;
        this.uniqueNames = null;
    }

    public final List<String> getFieldNames() {
        return this.names;
    }

    public final boolean areNamesUnique() {
        if (this.uniqueNames == null) {
            this.uniqueNames = new HashSet<String>(this.names).size() == this.names.size();
        }
        return this.uniqueNames;
    }

    public final Object getObject(ResultSet rs, int rsIndex) throws SQLException {
        return rs.getObject(rsIndex + this.rsOffset);
    }

    @Override
    public Object[] toArray(ResultSet rs) throws SQLException {
        int count = this.names.size();
        Object[] result = new Object[count];
        int i = 0;
        while (i < count) {
            result[i] = this.getObject(rs, i + 1);
            ++i;
        }
        return result;
    }

    @Override
    public Object toBean(ResultSet rs, Class type) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List toBeanList(ResultSet rs, Class type) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, Object> toMap(ResultSet rs) throws SQLException {
        int count = this.names.size();
        HashMap<String, Object> result = new HashMap<String, Object>();
        int i = 0;
        while (i < count) {
            String name = this.names.get(i);
            if (name != null) {
                result.put(name, this.getObject(rs, i + 1));
            }
            ++i;
        }
        return result;
    }

    public int hashCode() {
        return Objects.hash(this.names, this.rsOffset);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SQLFieldRowProcessor other = (SQLFieldRowProcessor)obj;
        return this.rsOffset == other.rsOffset && this.names.equals(other.names);
    }
}

