/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLName;

public final class ResultSetFullnameHelper {
    private final ResultSet delegate;
    private ResultSetMetaData rsMD;
    private final Map<String, Map<String, Integer>> tablesMap;

    public ResultSetFullnameHelper(ResultSet rs) {
        this.delegate = rs;
        this.tablesMap = new HashMap<String, Map<String, Integer>>();
        this.rsMD = null;
    }

    public final ResultSet getRS() {
        return this.delegate;
    }

    private final ResultSetMetaData getMetaData() throws SQLException {
        if (this.rsMD == null) {
            this.rsMD = this.delegate.getMetaData();
        }
        return this.rsMD;
    }

    public final int getIndex(SQLField f) throws SQLException {
        return this.getIndex(f.getTable().getName(), f.getName());
    }

    public final int getIndex(String fieldFullName) throws SQLException {
        SQLName names = SQLName.parse(fieldFullName);
        return this.getIndex(names.getItem(-2), names.getName());
    }

    public final int getIndex(String tableName, String fieldName) throws SQLException {
        Integer val;
        Map m = this.tablesMap.computeIfAbsent(tableName, k -> new HashMap());
        if (!m.containsKey(fieldName)) {
            int index = this.searchIndex(tableName, fieldName);
            m.put(fieldName, index < 1 ? null : new Integer(index));
        }
        return (val = (Integer)m.get(fieldName)) == null ? -1 : val;
    }

    private final int searchIndex(String tableName, String fieldName) throws SQLException {
        int i = 1;
        while (i <= this.getMetaData().getColumnCount()) {
            String colName = this.getMetaData().getColumnName(i);
            if (colName.equals(fieldName) && this.getMetaData().getTableName(i).equals(tableName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

