/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Map;
import org.apache.commons.collections.map.CaseInsensitiveMap;
import org.apache.commons.dbutils.BasicRowProcessor;

public class RawRowProcessor
extends BasicRowProcessor {
    @Override
    public Map toMap(ResultSet rs) throws SQLException {
        CaseInsensitiveMap result = new CaseInsensitiveMap();
        ResultSetMetaData rsmd = rs.getMetaData();
        int cols = rsmd.getColumnCount();
        int i = 1;
        while (i <= cols) {
            result.put(rsmd.getColumnName(i), this.process(rs, i));
            ++i;
        }
        return result;
    }

    @Override
    public Object[] toArray(ResultSet rs) throws SQLException {
        ResultSetMetaData meta = rs.getMetaData();
        int cols = meta.getColumnCount();
        Object[] result = new Object[cols];
        int i = 0;
        while (i < cols) {
            result[i] = this.process(rs, i + 1);
            ++i;
        }
        return result;
    }

    protected Object process(ResultSet rs, int i) throws SQLException {
        return rs.getString(i);
    }
}

