/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.math.BigDecimal;
import java.util.Comparator;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.utils.CompareUtils;

public class OrderComparator
implements Comparator<SQLRowAccessor> {
    public static final Comparator<BigDecimal> BD_NULLS_FIRST = Comparator.nullsFirst(Comparator.naturalOrder());
    public static final Comparator<BigDecimal> BD_NULLS_LAST = Comparator.nullsLast(Comparator.naturalOrder());
    public static final OrderComparator INSTANCE = new OrderComparator(false, BD_NULLS_LAST);
    private static final OrderComparator INSTANCE_FALLBACK_TO_PK = new OrderComparator(true, BD_NULLS_LAST);
    private final boolean fallbackToPK;
    private final Comparator<BigDecimal> bdComparator;

    public static final Comparator<SQLRowAccessor> getFallbackToPKInstance() {
        return INSTANCE_FALLBACK_TO_PK;
    }

    public OrderComparator(boolean fallbackToPK, Comparator<BigDecimal> bdComparator) {
        this.fallbackToPK = fallbackToPK;
        this.bdComparator = bdComparator;
    }

    @Override
    public int compare(SQLRowAccessor r1, SQLRowAccessor r2) {
        if (r1 == r2) {
            return 0;
        }
        SQLTable t = r1.getTable();
        if (!t.equals(r2.getTable())) {
            throw new IllegalArgumentException(r1 + " and " + r2 + " are not of the same table");
        }
        SQLField orderField = t.getTable().getOrderField();
        if (orderField != null) {
            BigDecimal order1 = r1.getObjectAs(orderField.getName(), true, BigDecimal.class);
            BigDecimal order2 = r2.getObjectAs(orderField.getName(), true, BigDecimal.class);
            return this.bdComparator.compare(order1, order2);
        }
        if (this.fallbackToPK) {
            if (!t.isRowable()) {
                throw new IllegalArgumentException(t + " neither ordered nor rowable");
            }
            if (r1.hasID() && r2.hasID()) {
                return CompareUtils.compareInt(r1.getID(), r2.getID());
            }
            throw new IllegalArgumentException("Missing ID");
        }
        throw new IllegalArgumentException(t + " not ordered");
    }
}

