/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.element;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.element.SQLElementLink;
import org.openconcerto.sql.element.SQLElementLinkSetup;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.model.graph.PathBuilder;
import org.openconcerto.utils.CollectionMap2Itf;
import org.openconcerto.utils.SetMap;

public final class SQLElementLinksSetup {
    private final SQLElement elem;
    private final Map<Path, SQLElementLinkSetup> result;
    private Path parent;

    SQLElementLinksSetup(SQLElement elem) {
        this.elem = elem;
        this.result = new HashMap<Path, SQLElementLinkSetup>();
        for (Map.Entry e : this.elem.getDefaultLinkTypes().entrySet()) {
            SQLElementLink.LinkType lt = (SQLElementLink.LinkType)((Object)e.getKey());
            Set paths = (Set)e.getValue();
            String typeError = lt == SQLElementLink.LinkType.PARENT ? "it was set by getParentFFName()" : null;
            for (Path p : paths) {
                SQLElementLinkSetup previous = this.result.put(p, new SQLElementLinkSetup(this, p, lt, typeError));
                assert (previous == null) : "Duplicate for " + p + " : " + previous + " and " + (Object)((Object)lt);
            }
        }
    }

    public final SQLElement getElem() {
        return this.elem;
    }

    public final SQLElementLinkSetup get(String fk) {
        return this.get(((PathBuilder)new PathBuilder(this.elem.getTable()).addForeignField(fk)).build());
    }

    public final SQLElementLinkSetup get(Path p) {
        SQLElementLinkSetup res = this.result.get(p);
        if (res == null) {
            throw new IllegalArgumentException("Unknown path " + p + " : " + this.result.keySet());
        }
        return res;
    }

    public final Path getParent() {
        return this.parent;
    }

    final void setParent(Path parent) {
        if (parent != null && this.parent != null) {
            throw new IllegalArgumentException("Overwriting " + this.parent + " with " + parent);
        }
        this.parent = parent;
    }

    public final SQLElementLinksSetup ignore(Path p) {
        this.get(p).ignore();
        return this;
    }

    final CollectionMap2Itf.SetMapItf<SQLElementLink.LinkType, SQLElementLink> getResult() {
        SetMap<SQLElementLink.LinkType, SQLElementLink> res = new SetMap<SQLElementLink.LinkType, SQLElementLink>();
        for (Map.Entry<Path, SQLElementLinkSetup> e : this.result.entrySet()) {
            SQLElementLinkSetup setup = e.getValue();
            if (setup.isIgnored()) continue;
            boolean added = res.add(setup.getType(), setup.build());
            assert (added) : "Duplicates";
        }
        return res;
    }
}

