/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.element;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.jcip.annotations.Immutable;
import org.apache.commons.dbutils.ResultSetHandler;
import org.openconcerto.sql.element.JoinSQLElement;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLFieldRowProcessor;
import org.openconcerto.sql.model.SQLResultSet;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLSyntax;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.SQLType;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.Link;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.model.graph.Step;
import org.openconcerto.utils.CollectionUtils;

public final class SQLElementLink {
    private final SQLElement owner;
    private final SQLElement owned;
    private final Path path;
    private final LinkType type;
    private final String name;
    private SQLElement.ReferenceAction action;

    protected SQLElementLink(SQLElement owner, Path path, SQLElement owned, LinkType type, String name, SQLElement.ReferenceAction action) {
        SQLField singleField;
        int length = path.length();
        if (length == 0) {
            throw new IllegalArgumentException("Empty path");
        }
        if (owner != null && owner.getTable() != path.getFirst() || owned.getTable() != path.getLast()) {
            throw new IllegalArgumentException("Wrong path : " + path + " not from owner : " + owner + " to owned : " + owned);
        }
        if (!path.isSingleLink()) {
            throw new IllegalArgumentException("Isn't single link : " + path);
        }
        if (length > 2) {
            throw new IllegalArgumentException("Path too long : " + path);
        }
        Step lastStep = path.getStep(-1);
        boolean endsWithForeign = lastStep.getDirection().equals((Object)Link.Direction.FOREIGN);
        if (length == 1) {
            if (!endsWithForeign) {
                throw new IllegalArgumentException("Single step path isn't foreign : " + path);
            }
        } else {
            assert (length == 2);
            if (!endsWithForeign || !path.getStep(0).getDirection().equals((Object)Link.Direction.REFERENT)) {
                throw new IllegalArgumentException("Two steps path isn't a join : " + path);
            }
        }
        if (lastStep.getSingleField() == null) {
            throw new IllegalArgumentException("Multi-field not yet supported : " + lastStep);
        }
        this.path = path;
        this.owner = owner;
        this.owned = owned;
        if (type == null || action == null) {
            throw new NullPointerException();
        }
        this.type = type;
        this.name = name != null ? name : (length == 1 ? ((singleField = lastStep.getSingleField()) != null ? singleField.getName() : lastStep.getSingleLink().getName()) : lastStep.getFrom().getName());
        assert (this.getName() != null);
        this.action = action;
    }

    public final Path getPath() {
        return this.path;
    }

    public final boolean isJoin() {
        return this.path.length() == 2;
    }

    public final Link getSingleLink() {
        if (this.isJoin()) {
            return null;
        }
        Link res = this.path.getStep(0).getSingleLink();
        assert (res != null);
        return res;
    }

    public final SQLField getSingleField() {
        Link l = this.getSingleLink();
        if (l == null) {
            return null;
        }
        SQLField res = l.getSingleField();
        assert (res != null);
        return res;
    }

    public final SQLElement getOwner() {
        return this.owner;
    }

    public final SQLElement getOwned() {
        return this.owned;
    }

    public final JoinSQLElement getJoinElement() {
        if (!this.isJoin()) {
            return null;
        }
        return (JoinSQLElement)this.getOwner().getElement(this.getPath().getTable(1));
    }

    public final boolean isOwnerTheParent() {
        boolean owner;
        if (this.getLinkType().equals((Object)LinkType.COMPOSITION)) {
            owner = true;
        } else if (this.getLinkType().equals((Object)LinkType.PARENT)) {
            owner = false;
        } else {
            throw new IllegalStateException("Invalid type : " + (Object)((Object)this.getLinkType()));
        }
        return owner;
    }

    public final SQLElement getParent() {
        return this.getParentOrChild(true);
    }

    private final SQLElement getParentOrChild(boolean parent) {
        return parent == this.isOwnerTheParent() ? this.getOwner() : this.getOwned();
    }

    public final SQLElement getChild() {
        return this.getParentOrChild(false);
    }

    public final Path getPathToParent() {
        return this.getPathToParentOrChild(true);
    }

    public final Step getStepToParent() {
        return this.getPathToParent().getStep(-1);
    }

    private final Path getPathToParentOrChild(boolean toParent) {
        return toParent == this.isOwnerTheParent() ? this.getPath().reverse() : this.getPath();
    }

    public final Path getPathToChild() {
        return this.getPathToParentOrChild(false);
    }

    public final Step getStepToChild() {
        return this.getPathToChild().getStep(-1);
    }

    public final List<SQLRow> getRowsUntilRoot(Number id) {
        return this.getRowsUntilRoot(id, null).getRows();
    }

    public final RecursiveRows getRowsUntilRoot(Number id, Set<String> fields) {
        return this.getRecursiveRows(true, id, fields, -1, null);
    }

    public final List<SQLRow> getSubTreeRows(Number id) {
        return this.getSubTreeRows(id, null).getRows();
    }

    public final RecursiveRows getSubTreeRows(Number id, Set<String> fields) {
        return this.getSubTreeRows(id, fields, -1);
    }

    public final RecursiveRows getSubTreeRows(Number id, Set<String> fields, int maxLevel) {
        return this.getRecursiveRows(false, id, fields, maxLevel, this.getOwned().getTable().getOrderField());
    }

    private static final String findUnusedName(Collection<String> usedNames, String base) {
        String res = base;
        int i = 0;
        while (usedNames.contains(res)) {
            res = String.valueOf(base) + i++;
        }
        return res;
    }

    private final RecursiveRows getRecursiveRows(boolean foreign, Number id, Set<String> fields, int maxLevel, SQLField orderField) {
        int index;
        boolean useOrder;
        if (this.getOwner() != this.getOwned() || this.isJoin()) {
            throw new IllegalStateException("Not a recurive link : " + this);
        }
        final SQLTable t = this.getOwned().getTable();
        Link singleLink = this.getSingleLink();
        SQLField singleField = singleLink.getSingleField();
        if (singleField == null) {
            throw new UnsupportedOperationException("Multiple fields not yet supported : " + singleLink);
        }
        Objects.requireNonNull(id, "id is null");
        if (maxLevel == 0) {
            return RecursiveRows.ZERO_LEVEL;
        }
        SQLSyntax syntax = t.getDBSystemRoot().getSyntax();
        if (fields == null) {
            fields = t.getFieldsName();
        }
        String recursiveT = "recT";
        String visitedIDsF = SQLElementLink.findUnusedName(fields, "visitedIDs");
        String visitedIDsRef = "recT." + visitedIDsF;
        String visitedIDsCount = syntax.getSQLArrayLength(visitedIDsRef);
        String loopF = SQLElementLink.findUnusedName(fields, "loop");
        SQLSelect selNonRec = new SQLSelect();
        selNonRec.addRawSelect(syntax.getSQLArray(Collections.singletonList(t.getKey().getFieldRef())), visitedIDsF);
        selNonRec.addRawSelect(SQLType.getBoolean(syntax).toString(Boolean.FALSE), loopF);
        boolean bl = useOrder = !foreign && orderField != null;
        if (useOrder) {
            selNonRec.addRawSelect(syntax.cast("null", orderField.getType().getJavaType()), "parentOrder");
        }
        selNonRec.addAllSelect(t, fields);
        if (!fields.contains(singleField.getName())) {
            selNonRec.addSelect(singleField);
        }
        if (!fields.contains(t.getKey().getName())) {
            selNonRec.addSelect(t.getKey());
        }
        selNonRec.setWhere(new Where((FieldRef)t.getKey(), "=", (Object)id));
        StringBuilder recSelect = new StringBuilder("SELECT ");
        recSelect.append(syntax.getSQLArrayAppend(visitedIDsRef, t.getKey().getFieldRef())).append(", ");
        recSelect.append(syntax.getSQLArrayContains(visitedIDsRef, t.getKey().getFieldRef())).append(", ");
        if (useOrder) {
            recSelect.append("recT").append('.').append(orderField.getName()).append(", ");
            index = 3;
        } else {
            index = 2;
        }
        recSelect.append(CollectionUtils.join(selNonRec.getSelect().subList(index, selNonRec.getSelect().size()), ", "));
        recSelect.append("\nFROM ").append(t.getSQLName().quote()).append(", ").append("recT");
        recSelect.append("\nWHERE ");
        if (foreign) {
            recSelect.append(t.getKey().getFieldRef()).append(" = ").append("recT." + singleField.getName());
        } else {
            recSelect.append(singleField.getFieldRef()).append(" = ").append("recT." + t.getKey().getName());
        }
        recSelect.append(" and not (").append("recT").append('.').append(loopF).append(')');
        if (t.getUndefinedIDNumber() != null) {
            recSelect.append(" and ").append(new Where((FieldRef)t.getKey(), "!=", t.getUndefinedID()).getClause());
        }
        if (maxLevel > 0) {
            recSelect.append(" and ").append(visitedIDsCount).append(" < ").append(maxLevel);
        }
        String cte = "with recursive recT(" + CollectionUtils.join(selNonRec.getSelectNames(), ", ") + ") as (\n" + selNonRec.asString() + "\nunion all\n" + recSelect + ")\nSELECT * from " + "recT" + " ORDER BY " + visitedIDsCount;
        if (useOrder) {
            cte = String.valueOf(cte) + ", 2, recT." + orderField.getName();
        }
        final ArrayList<String> rsNames = new ArrayList<String>(selNonRec.getSelectNames());
        rsNames.set(0, null);
        rsNames.set(1, null);
        if (useOrder) {
            rsNames.set(2, null);
        }
        final ArrayList<SQLRow> res = new ArrayList<SQLRow>();
        final HashMap<SQLRow, List<Number>> cycleRows = new HashMap<SQLRow, List<Number>>();
        final Class<Number> keyType = t.getKey().getType().getJavaType().asSubclass(Number.class);
        t.getDBSystemRoot().getDataSource().execute(cte, new ResultSetHandler(){

            @Override
            public Object handle(ResultSet rs) throws SQLException {
                SQLFieldRowProcessor rowProc = new SQLFieldRowProcessor(t, rsNames);
                while (rs.next()) {
                    SQLRow row = SQLRow.createFromRS(t, rs, rowProc, true);
                    boolean looped = rs.getBoolean(2);
                    if (looped) {
                        cycleRows.put(row, SQLResultSet.getList(rs, 1, keyType));
                        continue;
                    }
                    res.add(row);
                }
                return null;
            }
        });
        return new RecursiveRows(maxLevel, res, cycleRows);
    }

    public final LinkType getLinkType() {
        return this.type;
    }

    public final String getName() {
        return this.name;
    }

    public final SQLElement.ReferenceAction getAction() {
        return this.action;
    }

    @Deprecated
    public final void setAction(SQLElement.ReferenceAction action) {
        List<SQLElement.ReferenceAction> possibleActions = this.getOwner().getPossibleActions(this.getLinkType(), this.getOwned());
        if (!possibleActions.contains((Object)action)) {
            throw new IllegalArgumentException("Not allowed : " + (Object)((Object)action));
        }
        this.action = action;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.action.hashCode();
        result = 31 * result + this.path.hashCode();
        result = 31 * result + this.type.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SQLElementLink other = (SQLElementLink)obj;
        return this.action.equals((Object)other.action) && this.path.equals(other.path) && this.type.equals((Object)other.type);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " '" + this.getName() + "' " + (Object)((Object)this.getLinkType()) + " " + this.getPath();
    }

    public static enum LinkType {
        PARENT,
        COMPOSITION,
        ASSOCIATION;

    }

    @Immutable
    public static final class RecursiveRows {
        public static final RecursiveRows ZERO_LEVEL = new RecursiveRows(0, Collections.emptyList(), Collections.emptyMap());
        private final int maxLevel;
        private final List<SQLRow> rows;
        private final Map<SQLRow, List<Number>> cycles;

        RecursiveRows(int maxLevel, List<SQLRow> rows, Map<SQLRow, List<Number>> cycles) {
            this.maxLevel = maxLevel;
            this.rows = Collections.unmodifiableList(rows);
            this.cycles = Collections.unmodifiableMap(cycles);
        }

        public final int getMaxLevelRequested() {
            return this.maxLevel;
        }

        public final List<SQLRow> getRows() {
            if (this.getCycles().isEmpty()) {
                return this.getPartialRows();
            }
            throw new IllegalStateException("Cycle detected : " + this.getCycles());
        }

        public final List<SQLRow> getPartialRows() {
            return this.rows;
        }

        public final Map<SQLRow, List<Number>> getCycles() {
            return this.cycles;
        }
    }
}

