/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.element;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openconcerto.ui.group.Group;
import org.openconcerto.utils.StringUtils;

public class GlobalMapper {
    private final Map<String, Object> idToObject = new HashMap<String, Object>();
    private final Map<Object, List<String>> objectsToIds = new HashMap<Object, List<String>>();
    private static GlobalMapper instance = new GlobalMapper();

    public static GlobalMapper getInstance() {
        return instance;
    }

    public void map(String id, Object obj) {
        this.idToObject.put(id, obj);
        List<String> l = this.objectsToIds.get(obj);
        if (l == null) {
            l = new ArrayList<String>(3);
            this.objectsToIds.put(obj, l);
            l.add(id);
        } else if (!l.contains(obj)) {
            l.add(id);
        }
    }

    public Object get(String id) {
        return this.idToObject.get(id);
    }

    public String getString(String id) {
        Object object = this.idToObject.get(id);
        if (object instanceof String) {
            return (String)object;
        }
        return null;
    }

    public Group getGroup(String id) {
        Object object = this.idToObject.get(id);
        if (object instanceof Group) {
            return (Group)object;
        }
        return null;
    }

    public List<String> getIds(Object o) {
        return this.objectsToIds.get(o);
    }

    public void dump() {
        System.out.println(this.getClass().getName());
        ArrayList<String> ids = new ArrayList<String>();
        ids.addAll(this.idToObject.keySet());
        Collections.sort(ids);
        for (String id : ids) {
            System.out.println(String.valueOf(StringUtils.leftAlign(id, 40)) + " : " + this.idToObject.get(id));
        }
        System.out.println(String.valueOf(ids.size()) + " identifiers found");
    }
}

