/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.panel.compta;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openconcerto.erp.generationEcritures.Ecriture;
import org.openconcerto.erp.generationEcritures.Exercice;
import org.openconcerto.erp.generationEcritures.Mouvement;
import org.openconcerto.erp.generationEcritures.Piece;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.users.User;
import org.openconcerto.utils.StringUtils;

public class ImportRImport {
    private String error = null;
    private final Map<String, Piece> mapPiece = new HashMap<String, Piece>();
    private final Map<String, String> mapJournal = new HashMap<String, String>();

    public void loadFrom(File file) throws IOException {
        this.mapPiece.clear();
        this.mapJournal.clear();
        this.error = null;
        this.parseJournaux(file);
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader bReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), Charset.forName("Cp1252")));){
            String line = bReader.readLine();
            while (!line.startsWith("##Section") || !line.contains("Mvt")) {
                line = bReader.readLine();
            }
            line = bReader.readLine();
            while (line != null && !line.contains("#Section")) {
                List<String> parts = StringUtils.fastSplit(line, '\t');
                if (parts.size() > 6) {
                    Mouvement mouvement;
                    String journalCode = this.unquote(parts.get(1).trim());
                    Date ecritureDate = this.parseDate(this.unquote(parts.get(2).trim()));
                    String compteNum = this.unquote(parts.get(3).trim());
                    String compteLib = this.unquote(parts.get(4).trim());
                    BigDecimal m = new BigDecimal(this.cleanMontant(parts.get(5)));
                    BigDecimal debit = BigDecimal.ZERO;
                    BigDecimal credit = BigDecimal.ZERO;
                    if (parts.get(6).equalsIgnoreCase("D")) {
                        debit = m;
                    } else {
                        credit = m;
                    }
                    String valid = parts.get(7);
                    Date validDate = null;
                    if (valid.equalsIgnoreCase("V")) {
                        validDate = ecritureDate;
                    }
                    String ecritureLib = this.unquote(parts.get(8).trim());
                    String pieceRef = "Import " + journalCode;
                    Piece p = this.mapPiece.get(pieceRef);
                    if (p == null) {
                        p = new Piece(pieceRef);
                        mouvement = new Mouvement();
                        p.add(mouvement);
                        this.mapPiece.put(pieceRef, p);
                    } else {
                        mouvement = p.getMouvements().get(0);
                    }
                    Ecriture ecriture = new Ecriture(ecritureDate, debit, credit);
                    ecriture.setNom(ecritureLib);
                    ecriture.setCompte(compteNum, compteLib);
                    String journal = this.getJournal(journalCode);
                    if (journal == null) {
                        this.error = "Pas de journal trouv\u00e9 pour le code journal : " + journalCode;
                        return;
                    }
                    ecriture.setJournal(journalCode, journal);
                    ecriture.setDateValidation(validDate);
                    if ("AN".equals(journalCode)) {
                        ecriture.setaNouveau(true);
                    }
                    mouvement.add(ecriture);
                } else {
                    System.err.println("Ignoring : " + line);
                }
                line = bReader.readLine();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private String unquote(String str) {
        if (str.length() < 3) {
            return str;
        }
        return str.substring(1, str.length() - 1);
    }

    private void parseJournaux(File file) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader bReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), Charset.forName("Cp1252")));){
            String line = bReader.readLine();
            while (!line.startsWith("##Section") || !line.contains("Jnl")) {
                line = bReader.readLine();
            }
            line = bReader.readLine();
            while (line != null && !line.contains("#Section")) {
                List<String> parts = StringUtils.fastSplit(line, '\t');
                this.mapJournal.put(this.unquote(parts.get(0)), this.unquote(parts.get(1)));
                line = bReader.readLine();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private String getJournal(String journalCode) {
        return this.mapJournal.get(journalCode);
    }

    private String cleanMontant(String str) {
        int l = str.length();
        StringBuilder b = new StringBuilder(l);
        int i = 0;
        while (i < l) {
            char c = str.charAt(i);
            if (Character.isDigit(c)) {
                b.append(c);
            } else if (c == ',') {
                b.append('.');
            }
            ++i;
        }
        return b.toString();
    }

    private Date parseDate(String str) {
        if (str.length() != 10) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        int day = Integer.parseInt(str.substring(0, 2));
        int month = Integer.parseInt(str.substring(3, 5));
        int year = Integer.parseInt(str.substring(6, 10));
        c.set(year, month - 1, day, 0, 0, 0);
        return c.getTime();
    }

    public String getError() {
        return this.error;
    }

    public List<Piece> getPieces() {
        return new ArrayList<Piece>(this.mapPiece.values());
    }

    public void importTo(SQLElementDirectory directory, DBRoot rootSociete, User user) throws SQLException {
        Exercice e = new Exercice();
        e.insert(directory, rootSociete, user, new ArrayList<Piece>(this.mapPiece.values()));
    }

    public static void main(String[] args) throws IOException {
        ImportRImport i = new ImportRImport();
        i.loadFrom(new File("Y:\\Projets\\OpenConcerto\\ExportCiel\\RImport.txt"));
        System.err.println("ImportRImport.main() " + i.getPieces().size() + " pieces");
        System.err.println("ImportRImport.main()" + i.getError());
        for (Piece p : i.getPieces()) {
            System.err.println(String.valueOf(p.getNom()) + " " + p.getMouvements().size() + " mouvements");
            for (Mouvement m : p.getMouvements()) {
                System.err.println(m.asString());
            }
        }
    }
}

