/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.panel.compta;

import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.openconcerto.erp.panel.compta.AbstractExport;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.utils.GestionDevise;
import org.openconcerto.utils.StringUtils;

public class ExportRelationExpertPanel
extends AbstractExport {
    private List<Object[]> data;

    public ExportRelationExpertPanel(DBRoot rootSociete) {
        super(rootSociete, "relationExpert", ".txt");
    }

    @Override
    protected int fetchData(Date from, Date to, SQLRow selectedJournal, boolean onlyNew) {
        List l;
        SQLTable tableEcriture = this.getEcritureT();
        SQLTable tableMouvement = tableEcriture.getForeignTable("ID_MOUVEMENT");
        SQLTable tableCompte = tableEcriture.getForeignTable("ID_COMPTE_PCE");
        SQLTable tableJrnl = tableEcriture.getForeignTable("ID_JOURNAL");
        SQLTable tablePiece = tableMouvement.getForeignTable("ID_PIECE");
        SQLSelect sel = this.createSelect(from, to, selectedJournal, onlyNew);
        sel.addSelect(tableEcriture.getField("NOM"));
        sel.addSelect(tableMouvement.getField("NUMERO"));
        sel.addSelect(tableCompte.getField("NUMERO"));
        sel.addSelect(tableEcriture.getField("DATE"));
        sel.addSelect(tableEcriture.getField("DEBIT"));
        sel.addSelect(tableEcriture.getField("CREDIT"));
        sel.addSelect(tableJrnl.getField("CODE"));
        if (tableEcriture.contains("CODE_CLIENT")) {
            SQLField fieldCodeClient = tableEcriture.getField("CODE_CLIENT");
            sel.addSelect(fieldCodeClient);
        }
        sel.addSelect(tablePiece.getField("NOM"));
        sel.addFieldOrder(tableEcriture.getField("ID_MOUVEMENT"));
        sel.addFieldOrder(tableCompte.getField("NUMERO"));
        this.data = l = (List)this.getRootSociete().getDBSystemRoot().getDataSource().execute(sel.asString(), new ArrayListHandler());
        return l == null ? 0 : l.size();
    }

    @Override
    protected void export(OutputStream bufOut) throws IOException {
        List<Object[]> l = this.data;
        boolean containsCodeClient = this.getEcritureT().contains("CODE_CLIENT");
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
        int size = l.size();
        int i = 0;
        while (i < size) {
            StringBuilder line = new StringBuilder();
            Object[] tmp = l.get(i);
            Date d = (Date)tmp[3];
            line.append(dateFormat.format(d));
            line.append('\t');
            line.append(StringUtils.toAsciiString(tmp[6].toString().trim()));
            line.append('\t');
            String cpt = tmp[2].toString().trim();
            line.append(this.getFormattedCompte(cpt));
            line.append('\t');
            line.append('\t');
            line.append(StringUtils.toAsciiString(tmp[0].toString().trim()));
            line.append('\t');
            Long debit = new Long(tmp[4].toString().trim());
            line.append(GestionDevise.currencyToString(debit, false));
            line.append('\t');
            Long credit = new Long(tmp[5].toString().trim());
            line.append(GestionDevise.currencyToString(credit, false));
            line.append('\t');
            line.append('E');
            int z = 7;
            if (containsCodeClient) {
                String codeClient = "";
                if (tmp[z] != null) {
                    codeClient = tmp[z].toString().trim();
                }
                line.append('\t');
                line.append(StringUtils.toAsciiString(codeClient));
                ++z;
            }
            line.append('\t');
            line.append(StringUtils.toAsciiString(tmp[z].toString().trim()));
            line.append('\r');
            line.append('\n');
            bufOut.write(line.toString().getBytes(StringUtils.Cp1252));
            ++i;
        }
    }
}

