/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.panel.compta;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.finance.accounting.element.JournalSQLElement;
import org.openconcerto.erp.panel.compta.AbstractExport;
import org.openconcerto.erp.panel.compta.ExportCCMX;
import org.openconcerto.erp.panel.compta.ExportEBPPivot;
import org.openconcerto.erp.panel.compta.ExportEBP_ComptaPro;
import org.openconcerto.erp.panel.compta.ExportEBP_OL;
import org.openconcerto.erp.panel.compta.ExportFEC;
import org.openconcerto.erp.panel.compta.ExportRelationExpertPanel;
import org.openconcerto.erp.panel.compta.ExportSageEtendu;
import org.openconcerto.erp.panel.compta.ExportSageXimport;
import org.openconcerto.erp.panel.compta.ExportToQuadraCompta;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.request.ComboSQLRequest;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.ISpinnerIntegerModel;
import org.openconcerto.ui.JDate;
import org.openconcerto.ui.JLabelBold;
import org.openconcerto.ui.TitledSeparator;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.Tuple2;

public class ExportPanel
extends JPanel {
    private final JDate du;
    private final JDate au;
    private final JButton buttonGen = new JButton("Exporter");
    private final JFileChooser fileChooser = new JFileChooser();
    private final JTextField textDestination = new JTextField();
    private final ElementComboBox boxJournal = new ElementComboBox(true);
    private final JCheckBox boxExport = new JCheckBox("Seulement les nouvelles ecritures");
    private final JCheckBox boxReplaceLib = new JCheckBox("Remplacer le libell\u00e9 par le nom du client");
    private final JCheckBox boxCompteAuxiliaire = new JCheckBox("Utiliser les comptes auxiliares pour les comptes 411 et 401");
    private JSpinner spinNbChar = new JSpinner(new ISpinnerIntegerModel(0, 20, 0));
    private JSpinner spinNbCharLimit = new JSpinner(new ISpinnerIntegerModel(0, 20, 0));

    public ExportPanel() {
        super(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridwidth = 4;
        this.add((Component)new JLabelBold("Export des \u00e9critures comptables"), c);
        JPanel panelFichier = new JPanel(new GridBagLayout());
        DefaultGridBagConstraints cFic = new DefaultGridBagConstraints();
        cFic.insets.left = 0;
        cFic.insets.bottom = 0;
        ++cFic.gridx;
        cFic.weightx = 1.0;
        panelFichier.add((Component)this.textDestination, cFic);
        JButton buttonChoose = new JButton("...");
        ++cFic.gridx;
        cFic.weightx = 0.0;
        cFic.fill = 0;
        panelFichier.add((Component)buttonChoose, cFic);
        this.buttonGen.setEnabled(false);
        this.textDestination.setEditable(false);
        this.fileChooser.setFileSelectionMode(1);
        buttonChoose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int answer = ExportPanel.this.fileChooser.showSaveDialog(ExportPanel.this);
                if (answer == 0) {
                    ExportPanel.this.textDestination.setText(ExportPanel.this.fileChooser.getSelectedFile().getAbsolutePath());
                }
                ExportPanel.this.buttonGen.setEnabled(answer == 0);
            }
        });
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        this.add((Component)new JLabel("Dossier de destination", 4), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.gridwidth = 4;
        this.add((Component)panelFichier, c);
        c.gridx = 0;
        c.gridwidth = 1;
        ++c.gridy;
        c.weightx = 0.0;
        c.anchor = 13;
        this.add((Component)new JLabel("P\u00e9riode du", 4), c);
        ++c.gridx;
        c.anchor = 17;
        c.fill = 0;
        this.du = new JDate(true);
        this.add((Component)this.du, c);
        ++c.gridx;
        this.add((Component)new JLabel("au"), c);
        ++c.gridx;
        this.au = new JDate(true);
        this.add((Component)this.au, c);
        this.boxExport.setSelected(true);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 3;
        this.add((Component)this.boxExport, c);
        this.boxCompteAuxiliaire.setSelected(false);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 3;
        this.add((Component)this.boxCompteAuxiliaire, c);
        JournalSQLElement elt = Configuration.getInstance().getDirectory().getElement(JournalSQLElement.class);
        ComboSQLRequest comboRequest = elt.getComboRequest(true);
        comboRequest.setUndefLabel("Tous");
        this.boxJournal.init(elt, comboRequest);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.fill = 2;
        this.add((Component)new JLabel("Ecritures du journal", 4), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.gridwidth = 4;
        c.fill = 0;
        this.boxJournal.setValue(3);
        this.add((Component)this.boxJournal, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.fill = 2;
        this.add((Component)new JLabel("Type d'export", 4), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.gridwidth = 4;
        final JComboBox<ExportType> comboType = new JComboBox<ExportType>(ExportType.values());
        comboType.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                return super.getListCellRendererComponent((JList<?>)list, ((ExportType)((Object)value)).getLabel(), index, isSelected, cellHasFocus);
            }
        });
        c.fill = 0;
        comboType.setSelectedIndex(0);
        this.add(comboType, c);
        final JPanel p = new JPanel(new GridBagLayout());
        DefaultGridBagConstraints c2 = new DefaultGridBagConstraints();
        c2.gridx = 0;
        c2.weightx = 1.0;
        c2.gridwidth = 0;
        c2.fill = 2;
        p.add((Component)new TitledSeparator("Option export relation expert", true), c2);
        ++c2.gridy;
        c2.gridx = 0;
        c2.weightx = 0.0;
        c2.gridwidth = 3;
        c2.fill = 2;
        p.add((Component)new JLabel("Formater les num\u00e9ros de compte suivant le nombre de caract\u00e8res suivants", 4), c2);
        c2.gridx += 3;
        c2.weightx = 1.0;
        c2.gridwidth = 1;
        p.add((Component)this.spinNbChar, c2);
        ++c2.gridy;
        c2.gridx = 0;
        c2.weightx = 0.0;
        c2.gridwidth = 3;
        c2.fill = 2;
        p.add((Component)new JLabel("Limiter le nombre de caract\u00e9res des num\u00e9ros compte \u00e0", 4), c2);
        c2.gridx += 3;
        c2.weightx = 1.0;
        c2.gridwidth = 1;
        p.add((Component)this.spinNbCharLimit, c2);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 0;
        c.fill = 2;
        this.add((Component)p, c);
        ++c.gridy;
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridwidth = 1;
        JPanel panelButton = new JPanel();
        panelButton.add(this.buttonGen);
        c.gridwidth = 0;
        c.fill = 0;
        c.anchor = 14;
        c.weightx = 0.0;
        c.weighty = 1.0;
        this.add((Component)panelButton, c);
        this.buttonGen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportPanel.this.export((ExportType)((Object)comboType.getSelectedItem()));
            }
        });
        p.setVisible(false);
        comboType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportType selectedItem = (ExportType)((Object)comboType.getSelectedItem());
                p.setVisible(selectedItem == ExportType.RelationExpert);
                boolean isFEC = selectedItem == ExportType.FEC || selectedItem == ExportType.FEC_NON_CLOTURE;
                ExportPanel.this.boxCompteAuxiliaire.setVisible(isFEC);
                if (!isFEC) {
                    ExportPanel.this.boxCompteAuxiliaire.setSelected(false);
                }
            }
        });
    }

    protected final void export(ExportType type) {
        try {
            AbstractExport createExport = type.createExport(ComptaPropsConfiguration.getInstanceCompta().getRootSociete());
            createExport.setNbCharCpt((Integer)this.spinNbChar.getValue());
            createExport.setNbCharLimitCpt((Integer)this.spinNbCharLimit.getValue());
            createExport.setAuxiliaire(this.boxCompteAuxiliaire.isSelected());
            Tuple2<File, Number> res = createExport.export(this.fileChooser.getSelectedFile(), this.du.getDate(), this.au.getDate(), this.boxJournal.getSelectedRow(), this.boxExport.isSelected());
            if (res.get1().intValue() == 0) {
                JOptionPane.showMessageDialog(this, "Aucune \u00e9criture trouv\u00e9e. La p\u00e9riode est-elle correcte ?");
            } else {
                JOptionPane.showMessageDialog(this, "L'export des " + res.get1() + " \u00e9critures est termin\u00e9.\nLe fichier cr\u00e9\u00e9 est " + res.get0().getAbsolutePath());
                SwingUtilities.getWindowAncestor(this).dispose();
            }
        }
        catch (FileNotFoundException ex) {
            JOptionPane.showMessageDialog(this, "Cr\u00e9ation du fichier impossible : " + ex.getMessage());
        }
        catch (Exception e) {
            ExceptionHandler.handle(this, "Erreur d'export", e);
        }
    }

    static enum ExportType {
        FEC("Fichier des \u00e9critures comptables pour exercice cl\u00f4tur\u00e9(FEC norme DGFIP)"){

            @Override
            public AbstractExport createExport(DBRoot root) {
                return new ExportFEC(root, true);
            }
        }
        ,
        FEC_NON_CLOTURE("Fichier des \u00e9critures comptables interm\u00e9diaire pour l'exercice courant"){

            @Override
            public AbstractExport createExport(DBRoot root) {
                return new ExportFEC(root, false);
            }
        }
        ,
        RelationExpert("Relation expert (Coala)"){

            @Override
            public AbstractExport createExport(DBRoot root) {
                return new ExportRelationExpertPanel(root);
            }
        }
        ,
        EBP_PIVOT("EBP Pivot"){

            @Override
            public AbstractExport createExport(DBRoot root) {
                return new ExportEBPPivot(root);
            }
        }
        ,
        EBP_OL("EBP Open Line"){

            @Override
            public AbstractExport createExport(DBRoot root) {
                return new ExportEBP_OL(root);
            }
        }
        ,
        EBP("EBP Compta Pro"){

            @Override
            public AbstractExport createExport(DBRoot root) {
                return new ExportEBP_ComptaPro(root);
            }
        }
        ,
        SAGE("Sage Ximport"){

            @Override
            public AbstractExport createExport(DBRoot root) {
                return new ExportSageXimport(root);
            }
        }
        ,
        SAGE_ETENDU("Sage Etendu"){

            @Override
            public AbstractExport createExport(DBRoot root) {
                return new ExportSageEtendu(root);
            }
        }
        ,
        QUADRACOMPTA("Quadratus : Export des \u00e9critures vers QuadraCompta"){

            @Override
            public AbstractExport createExport(DBRoot root) {
                return new ExportToQuadraCompta(root);
            }
        }
        ,
        CCMX("Cegid CCMX"){

            @Override
            public AbstractExport createExport(DBRoot root) {
                return new ExportCCMX(root);
            }
        };

        private final String label;

        private ExportType(String label) {
            this.label = label;
        }

        public final String getLabel() {
            return this.label;
        }

        public abstract AbstractExport createExport(DBRoot var1);
    }
}

